/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.filtered;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FilteringTreeStructure
extends AbstractTreeStructure {
    private final ElementFilter<Object> myFilter;
    private final AbstractTreeStructure myBaseStructure;
    protected final FilteringNode myRoot;
    protected final HashSet<FilteringNode> myLeaves;
    private final Map<FilteringNode, List<FilteringNode>> myNodesCache;
    private final Map<Object, FilteringNode> myDescriptors2Nodes;

    public FilteringTreeStructure(@NotNull ElementFilter filter, @NotNull AbstractTreeStructure originalStructure) {
        if (filter == null) {
            FilteringTreeStructure.$$$reportNull$$$0(0);
        }
        if (originalStructure == null) {
            FilteringTreeStructure.$$$reportNull$$$0(1);
        }
        this(filter, originalStructure, true);
    }

    public FilteringTreeStructure(@NotNull ElementFilter filter, @NotNull AbstractTreeStructure originalStructure, boolean initNow) {
        if (filter == null) {
            FilteringTreeStructure.$$$reportNull$$$0(2);
        }
        if (originalStructure == null) {
            FilteringTreeStructure.$$$reportNull$$$0(3);
        }
        this.myLeaves = new HashSet();
        this.myNodesCache = new HashMap<FilteringNode, List<FilteringNode>>();
        this.myDescriptors2Nodes = new HashMap<Object, FilteringNode>();
        this.myFilter = filter;
        this.myBaseStructure = originalStructure;
        this.myRoot = new FilteringNode(null, this.myBaseStructure.getRootElement());
        if (initNow) {
            this.rebuild();
        }
    }

    public void rebuild() {
        this.myLeaves.clear();
        this.myNodesCache.clear();
        this.myDescriptors2Nodes.clear();
        this.addToCache(this.myRoot, false);
    }

    private void addToCache(FilteringNode node, boolean duplicate) {
        Object delegate = node.getDelegate();
        Object[] delegates = this.myBaseStructure.getChildElements(delegate);
        if (delegates == null || delegates.length == 0 || duplicate) {
            this.myLeaves.add(node);
        } else {
            ArrayList<FilteringNode> nodes = new ArrayList<FilteringNode>(delegates.length);
            for (Object d : delegates) {
                boolean isDuplicate = this.myDescriptors2Nodes.containsKey(d);
                if (isDuplicate) continue;
                FilteringNode n = new FilteringNode(node, d);
                this.myDescriptors2Nodes.put(d, n);
                nodes.add(n);
            }
            this.myNodesCache.put(node, nodes);
            for (FilteringNode n : nodes) {
                this.addToCache(n, false);
            }
            if (nodes.isEmpty()) {
                this.myLeaves.add(node);
            }
        }
    }

    public void refilter() {
        this.setUnknown(this.myRoot);
        for (FilteringNode node : this.myLeaves) {
            State state = this.getState(node);
            while (node != null && node.state != State.VISIBLE && node.state != state) {
                node.state = state;
                if ((node = node.getParentNode()) == null || state != State.HIDDEN) continue;
                state = this.getState(node);
            }
        }
    }

    private State getState(@NotNull FilteringNode node) {
        if (node == null) {
            FilteringTreeStructure.$$$reportNull$$$0(4);
        }
        return this.myFilter.shouldBeShowing(node.getDelegate()) ? State.VISIBLE : State.HIDDEN;
    }

    private void setUnknown(FilteringNode node) {
        if (node.state == State.UNKNOWN) {
            return;
        }
        node.state = State.UNKNOWN;
        List<FilteringNode> nodes = this.myNodesCache.get(node);
        if (nodes != null) {
            for (FilteringNode n : nodes) {
                this.setUnknown(n);
            }
        }
    }

    public FilteringNode getVisibleNodeFor(Object nodeObject) {
        return this.myDescriptors2Nodes.get(nodeObject);
    }

    @Override
    @NotNull
    public FilteringNode getRootElement() {
        FilteringNode filteringNode = this.myRoot;
        if (filteringNode == null) {
            FilteringTreeStructure.$$$reportNull$$$0(5);
        }
        return filteringNode;
    }

    @Override
    @NotNull
    public Object[] getChildElements(@NotNull Object element) {
        if (element == null) {
            FilteringTreeStructure.$$$reportNull$$$0(6);
        }
        Object[] objectArray = ((FilteringNode)element).getChildren();
        if (objectArray == null) {
            FilteringTreeStructure.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @Override
    public Object getParentElement(@NotNull Object element) {
        if (element == null) {
            FilteringTreeStructure.$$$reportNull$$$0(8);
        }
        return ((FilteringNode)element).getParent();
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull Object element) {
        if (element == null) {
            FilteringTreeStructure.$$$reportNull$$$0(9);
        }
        return element instanceof FilteringNode && ((FilteringNode)element).isAlwaysLeaf();
    }

    @Override
    public boolean isToBuildChildrenInBackground(@NotNull Object element) {
        if (element == null) {
            FilteringTreeStructure.$$$reportNull$$$0(10);
        }
        return this.myBaseStructure.isToBuildChildrenInBackground(element);
    }

    @Override
    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            FilteringTreeStructure.$$$reportNull$$$0(11);
        }
        FilteringNode filteringNode = element instanceof FilteringNode ? (FilteringNode)element : new FilteringNode((SimpleNode)parentDescriptor, element);
        if (filteringNode == null) {
            FilteringTreeStructure.$$$reportNull$$$0(12);
        }
        return filteringNode;
    }

    @Override
    public void commit() {
        this.myBaseStructure.commit();
    }

    @Override
    public boolean hasSomethingToCommit() {
        return this.myBaseStructure.hasSomethingToCommit();
    }

    @Override
    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = this.myBaseStructure.asyncCommit();
        if (actionCallback == null) {
            FilteringTreeStructure.$$$reportNull$$$0(13);
        }
        return actionCallback;
    }

    public FilteringNode createFilteringNode(Object delegate) {
        return new FilteringNode(null, delegate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalStructure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: 
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysLeaf";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isToBuildChildrenInBackground";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class FilteringNode
    extends SimpleNode {
        private Object myDelegate;
        private State state;

        public FilteringNode(SimpleNode parent, Object delegate) {
            super(parent);
            this.state = State.VISIBLE;
            this.myDelegate = delegate;
        }

        public void setDelegate(Object delegate) {
            this.myDelegate = delegate;
        }

        public FilteringNode getParentNode() {
            return (FilteringNode)this.getParent();
        }

        public Object getDelegate() {
            return this.myDelegate;
        }

        public List<FilteringNode> children() {
            List nodes = (List)FilteringTreeStructure.this.myNodesCache.get(this);
            return nodes == null ? Collections.emptyList() : nodes;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getDelegate());
        }

        @Override
        public boolean isContentHighlighted() {
            return this.myDelegate instanceof SimpleNode && ((SimpleNode)this.myDelegate).isContentHighlighted();
        }

        @Override
        public boolean isHighlightableContentNode(@NotNull PresentableNodeDescriptor kid) {
            if (kid == null) {
                FilteringNode.$$$reportNull$$$0(0);
            }
            return this.myDelegate instanceof PresentableNodeDescriptor && ((PresentableNodeDescriptor)this.myDelegate).isHighlightableContentNode(kid);
        }

        @Override
        protected void updateFileStatus() {
        }

        @Override
        protected void doUpdate() {
            this.clearColoredText();
            if (this.myDelegate instanceof PresentableNodeDescriptor) {
                PresentableNodeDescriptor node = (PresentableNodeDescriptor)this.myDelegate;
                node.update();
                this.apply(node.getPresentation());
            } else if (this.myDelegate != null) {
                NodeDescriptor descriptor = FilteringTreeStructure.this.myBaseStructure.createDescriptor(this.myDelegate, this.getParentDescriptor());
                descriptor.update();
                this.setUniformIcon(descriptor.getIcon());
                this.setPlainText(this.myDelegate.toString());
            }
        }

        @Override
        @NotNull
        public SimpleNode[] getChildren() {
            List nodes = (List)FilteringTreeStructure.this.myNodesCache.get(this);
            if (nodes == null) {
                SimpleNode[] simpleNodeArray = this.myDelegate instanceof SimpleNode ? (SimpleNode[])ContainerUtil.map((Object[])((SimpleNode)this.myDelegate).getChildren(), node -> new FilteringNode(this, node), (Object[])NO_CHILDREN) : NO_CHILDREN;
                if (simpleNodeArray == null) {
                    FilteringNode.$$$reportNull$$$0(1);
                }
                return simpleNodeArray;
            }
            ArrayList<FilteringNode> result = new ArrayList<FilteringNode>();
            for (FilteringNode node2 : nodes) {
                if (node2.state != State.VISIBLE) continue;
                result.add(node2);
            }
            SimpleNode[] simpleNodeArray = result.toArray(new FilteringNode[0]);
            if (simpleNodeArray == null) {
                FilteringNode.$$$reportNull$$$0(2);
            }
            return simpleNodeArray;
        }

        @Override
        public int getWeight() {
            if (this.getDelegate() instanceof SimpleNode) {
                return ((SimpleNode)this.getDelegate()).getWeight();
            }
            return super.getWeight();
        }

        @Override
        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.myDelegate};
            if (objectArray == null) {
                FilteringNode.$$$reportNull$$$0(3);
            }
            return objectArray;
        }

        @Override
        public boolean isAlwaysShowPlus() {
            if (this.myDelegate instanceof SimpleNode) {
                return ((SimpleNode)this.myDelegate).isAlwaysShowPlus();
            }
            return super.isAlwaysShowPlus();
        }

        @Override
        public boolean isAlwaysLeaf() {
            if (this.myDelegate instanceof SimpleNode) {
                return ((SimpleNode)this.myDelegate).isAlwaysLeaf();
            }
            return super.isAlwaysLeaf();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kid";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure$FilteringNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure$FilteringNode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEqualityObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isHighlightableContentNode";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static enum State {
        UNKNOWN,
        VISIBLE,
        HIDDEN;

    }
}

