/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.UIBundle;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.Function;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListWithFilter<T>
extends JPanel
implements DataProvider {
    private final JList<T> myList;
    private final SearchTextField mySearchField;
    private final NameFilteringListModel<T> myModel;
    private final JScrollPane myScrollPane;
    private final MySpeedSearch mySpeedSearch;
    private boolean myAutoPackHeight;

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ListWithFilter.$$$reportNull$$$0(0);
        }
        if (SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.is(dataId)) {
            return this.mySearchField.getText();
        }
        return null;
    }

    @NotNull
    public static <T> JComponent wrap(@NotNull JList<? extends T> list, @NotNull JScrollPane scrollPane, @Nullable Function<? super T, String> namer) {
        if (list == null) {
            ListWithFilter.$$$reportNull$$$0(1);
        }
        if (scrollPane == null) {
            ListWithFilter.$$$reportNull$$$0(2);
        }
        JComponent jComponent = ListWithFilter.wrap(list, scrollPane, namer, false);
        if (jComponent == null) {
            ListWithFilter.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    public static <T> JComponent wrap(@NotNull JList<? extends T> list, @NotNull JScrollPane scrollPane, @Nullable Function<? super T, String> namer, boolean highlightAllOccurrences) {
        if (list == null) {
            ListWithFilter.$$$reportNull$$$0(4);
        }
        if (scrollPane == null) {
            ListWithFilter.$$$reportNull$$$0(5);
        }
        ListWithFilter<? super T> listWithFilter = new ListWithFilter<T>(list, scrollPane, namer, highlightAllOccurrences);
        if (listWithFilter == null) {
            ListWithFilter.$$$reportNull$$$0(6);
        }
        return listWithFilter;
    }

    private ListWithFilter(@NotNull JList<T> list, @NotNull JScrollPane scrollPane, @Nullable Function<? super T, String> namer, boolean highlightAllOccurrences) {
        if (list == null) {
            ListWithFilter.$$$reportNull$$$0(7);
        }
        if (scrollPane == null) {
            ListWithFilter.$$$reportNull$$$0(8);
        }
        super(new BorderLayout());
        this.mySearchField = new SearchTextField(false);
        this.myAutoPackHeight = true;
        if (list instanceof ComponentWithEmptyText) {
            ((ComponentWithEmptyText)((Object)list)).getEmptyText().setText(UIBundle.message((String)"message.noMatchesFound", (Object[])new Object[0]));
        }
        this.myList = list;
        this.myScrollPane = scrollPane;
        this.mySearchField.getTextEditor().setFocusable(false);
        this.mySearchField.setVisible(false);
        this.add((Component)this.mySearchField, "North");
        this.add((Component)this.myScrollPane, "Center");
        this.mySpeedSearch = new MySpeedSearch(highlightAllOccurrences);
        this.mySpeedSearch.setEnabled(namer != null);
        this.myList.addKeyListener(this.mySpeedSearch);
        int selectedIndex = this.myList.getSelectedIndex();
        int modelSize = this.myList.getModel().getSize();
        this.myModel = new NameFilteringListModel<T>(this.myList.getModel(), namer, (Condition<? super String>)((Condition)this.mySpeedSearch::shouldBeShowing), (Computable<String>)((Computable)() -> StringUtil.notNullize((String)this.mySpeedSearch.getFilter())));
        this.myList.setModel(this.myModel);
        if (this.myModel.getSize() == modelSize) {
            this.myList.setSelectedIndex(selectedIndex);
        }
        this.setBackground(list.getBackground());
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
        }
    }

    public boolean resetFilter() {
        boolean hadPattern = this.mySpeedSearch.isHoldingFilter();
        if (this.mySearchField.isVisible()) {
            this.mySpeedSearch.reset();
        }
        return hadPattern;
    }

    public SpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    protected void onSpeedSearchPatternChanged() {
        T prevSelection = this.myList.getSelectedValue();
        this.myModel.refilter();
        if (this.myModel.getSize() > 0) {
            int fullMatchIndex;
            int n = fullMatchIndex = this.mySpeedSearch.isHoldingFilter() ? this.myModel.getClosestMatchIndex() : this.myModel.getElementIndex(prevSelection);
            if (fullMatchIndex != -1) {
                this.myList.setSelectedIndex(fullMatchIndex);
            }
            if (this.myModel.getSize() <= this.myList.getSelectedIndex() || !this.myModel.contains(this.myList.getSelectedValue())) {
                this.myList.setSelectedIndex(0);
            }
        } else {
            this.mySpeedSearch.noHits();
            this.revalidate();
        }
    }

    @NotNull
    public JList<T> getList() {
        JList<T> jList = this.myList;
        if (jList == null) {
            ListWithFilter.$$$reportNull$$$0(9);
        }
        return jList;
    }

    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            ListWithFilter.$$$reportNull$$$0(10);
        }
        return jScrollPane;
    }

    public void setAutoPackHeight(boolean autoPackHeight) {
        this.myAutoPackHeight = autoPackHeight;
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollPane";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/speedSearch/ListWithFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/speedSearch/ListWithFilter";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MySpeedSearch
    extends SpeedSearch {
        boolean searchFieldShown;
        boolean myInUpdate;

        private MySpeedSearch(boolean highlightAllOccurrences) {
            super(highlightAllOccurrences);
            ListWithFilter.this.mySearchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (MySpeedSearch.this.myInUpdate) {
                        return;
                    }
                    if (ListWithFilter.this.mySearchField.getText().isEmpty()) {
                        ListWithFilter.this.mySpeedSearch.reset();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/speedSearch/ListWithFilter$MySpeedSearch$1", "textChanged"));
                }
            });
            this.installSupplyTo(ListWithFilter.this.myList);
        }

        @Override
        public void update() {
            this.myInUpdate = true;
            ListWithFilter.this.mySearchField.getTextEditor().setBackground(UIUtil.getTextFieldBackground());
            ListWithFilter.this.onSpeedSearchPatternChanged();
            ListWithFilter.this.mySearchField.setText(this.getFilter());
            if (this.isHoldingFilter() && !this.searchFieldShown) {
                ListWithFilter.this.mySearchField.setVisible(true);
                this.searchFieldShown = true;
            } else if (!this.isHoldingFilter() && this.searchFieldShown) {
                ListWithFilter.this.mySearchField.setVisible(false);
                this.searchFieldShown = false;
            }
            this.myInUpdate = false;
            this.revalidate();
        }

        @Override
        public void noHits() {
            ListWithFilter.this.mySearchField.getTextEditor().setBackground(LightColors.RED);
        }

        private void revalidate() {
            JBPopup popup = PopupUtil.getPopupContainerFor(ListWithFilter.this.mySearchField);
            if (popup != null) {
                popup.pack(false, ListWithFilter.this.myAutoPackHeight);
            }
            ListWithFilter.this.revalidate();
        }
    }
}

