/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandableItemsHandlerFactory;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.SelectionAwareListCellRenderer;
import com.intellij.ui.components.WideSelectionListUI;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBList<E>
extends JList<E>
implements ComponentWithEmptyText,
ComponentWithExpandableItems<Integer> {
    private StatusText myEmptyText;
    private ExpandableItemsHandler<Integer> myExpandableItemsHandler;
    @Nullable
    private AsyncProcessIcon myBusyIcon;
    private boolean myBusy;

    public JBList() {
        this.init();
    }

    public JBList(@NotNull ListModel<E> dataModel) {
        if (dataModel == null) {
            JBList.$$$reportNull$$$0(0);
        }
        super(dataModel);
        this.init();
    }

    public JBList(E ... listData) {
        if (listData == null) {
            JBList.$$$reportNull$$$0(1);
        }
        super(JBList.createDefaultListModel(listData));
        this.init();
    }

    @NotNull
    public static <T> DefaultListModel<T> createDefaultListModel(T ... items) {
        if (items == null) {
            JBList.$$$reportNull$$$0(2);
        }
        DefaultListModel<T> defaultListModel = JBList.createDefaultListModel(Arrays.asList(items));
        if (defaultListModel == null) {
            JBList.$$$reportNull$$$0(3);
        }
        return defaultListModel;
    }

    @NotNull
    public static <T> DefaultListModel<T> createDefaultListModel(@NotNull Iterable<? extends T> items) {
        if (items == null) {
            JBList.$$$reportNull$$$0(4);
        }
        DefaultListModel<T> model = new DefaultListModel<T>();
        for (T item : items) {
            model.add(model.getSize(), item);
        }
        DefaultListModel<T> defaultListModel = model;
        if (defaultListModel == null) {
            JBList.$$$reportNull$$$0(5);
        }
        return defaultListModel;
    }

    public JBList(@NotNull Collection<? extends E> items) {
        if (items == null) {
            JBList.$$$reportNull$$$0(6);
        }
        this((ListModel<? extends E>)JBList.createDefaultListModel(items));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (!ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            return;
        }
        if (this.myBusyIcon != null) {
            this.remove(this.myBusyIcon);
            Disposer.dispose((Disposable)this.myBusyIcon);
            this.myBusyIcon = null;
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        if (width > 0 && height > 0) {
            ListUI ui = this.getUI();
            if (ui instanceof WideSelectionListUI && 0 == this.getLayoutOrientation()) {
                x = 0;
                width = this.getWidth();
            }
            super.repaint(tm, x, y, width, height);
        }
    }

    @Override
    public void setUI(ListUI ui) {
        Class<?> type;
        if (ui != null && Registry.is((String)"ide.wide.selection.list.ui") && (type = ui.getClass()) == BasicListUI.class) {
            ui = new WideSelectionListUI();
        }
        super.setUI(ui);
    }

    public void setPaintBusy(boolean paintBusy) {
        if (this.myBusy == paintBusy) {
            return;
        }
        this.myBusy = paintBusy;
        this.updateBusy();
    }

    private void updateBusy() {
        if (this.myBusy && this.myBusyIcon == null) {
            this.myBusyIcon = new AsyncProcessIcon(this.toString());
            this.myBusyIcon.setOpaque(false);
            this.myBusyIcon.setPaintPassiveIcon(false);
            this.add(this.myBusyIcon);
        }
        if (this.myBusyIcon != null) {
            if (this.myBusy) {
                this.myBusyIcon.resume();
            } else {
                this.myBusyIcon.suspend();
                SwingUtilities.invokeLater(() -> {
                    if (this.myBusyIcon != null) {
                        this.repaint();
                    }
                });
            }
            if (this.myBusyIcon != null) {
                this.myBusyIcon.updateLocation(this);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myEmptyText.paint(this, g);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getModel().getSize() == 0 && !StringUtil.isEmpty((String)this.getEmptyText().getText())) {
            Dimension s = this.getEmptyText().getPreferredSize();
            JBInsets.addTo((Dimension)s, (Insets)this.getInsets());
            return s;
        }
        return super.getPreferredSize();
    }

    private void init() {
        this.setSelectionBackground(UIUtil.getListSelectionBackground((boolean)true));
        this.setSelectionForeground(UIUtil.getListSelectionForeground((boolean)true));
        this.installDefaultCopyAction();
        this.myEmptyText = new StatusText(this){

            @Override
            protected boolean isStatusVisible() {
                return JBList.this.isEmpty();
            }
        };
        this.myExpandableItemsHandler = this.createExpandableItemsHandler();
        this.setCellRenderer(new DefaultListCellRenderer());
    }

    private void installDefaultCopyAction() {
        Action copy = this.getActionMap().get("copy");
        if (copy == null || copy instanceof UIResource) {
            AbstractAction newCopy = new AbstractAction(){

                @Override
                public boolean isEnabled() {
                    return JBList.this.getSelectedIndex() != -1;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    JBList.this.doCopyToClipboardAction();
                }
            };
            this.getActionMap().put("copy", newCopy);
        }
    }

    protected void doCopyToClipboardAction() {
        ArrayList selected = new ArrayList();
        for (int index : this.getSelectedIndices()) {
            Object value = this.getModel().getElementAt(index);
            String text = this.itemToText(index, value);
            ContainerUtil.addIfNotNull(selected, (Object)text);
        }
        if (selected.size() > 0) {
            String text = StringUtil.join(selected, (String)"\n");
            CopyPasteManager.getInstance().setContents(new StringSelection(text));
        }
    }

    @Nullable
    private String itemToText(int index, E value) {
        ListCellRenderer<E> renderer = this.getCellRenderer();
        Component c = renderer == null ? null : renderer.getListCellRendererComponent(this, value, index, true, true);
        SimpleColoredComponent coloredComponent = null;
        if (c instanceof JComponent) {
            coloredComponent = (SimpleColoredComponent)UIUtil.findComponentOfType((JComponent)((JComponent)c), SimpleColoredComponent.class);
        }
        return coloredComponent != null ? coloredComponent.getCharSequence(true).toString() : (c instanceof JTextComponent ? ((JTextComponent)c).getText() : (value != null ? value.toString() : null));
    }

    public boolean isEmpty() {
        return this.getItemsCount() == 0;
    }

    public int getItemsCount() {
        ListModel model = this.getModel();
        return model == null ? 0 : model.getSize();
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myEmptyText;
        if (statusText == null) {
            JBList.$$$reportNull$$$0(7);
        }
        return statusText;
    }

    public void setEmptyText(@NotNull String text) {
        if (text == null) {
            JBList.$$$reportNull$$$0(8);
        }
        this.myEmptyText.setText(text);
    }

    @Override
    @NotNull
    public ExpandableItemsHandler<Integer> getExpandableItemsHandler() {
        ExpandableItemsHandler<Integer> expandableItemsHandler = this.myExpandableItemsHandler;
        if (expandableItemsHandler == null) {
            JBList.$$$reportNull$$$0(9);
        }
        return expandableItemsHandler;
    }

    @NotNull
    protected ExpandableItemsHandler<Integer> createExpandableItemsHandler() {
        ExpandableItemsHandler<Integer> expandableItemsHandler = ExpandableItemsHandlerFactory.install(this);
        if (expandableItemsHandler == null) {
            JBList.$$$reportNull$$$0(10);
        }
        return expandableItemsHandler;
    }

    @Override
    public void setExpandableItemsEnabled(boolean enabled) {
        this.myExpandableItemsHandler.setEnabled(enabled);
    }

    @Override
    public void setCellRenderer(@NotNull ListCellRenderer<? super E> cellRenderer) {
        if (cellRenderer == null) {
            JBList.$$$reportNull$$$0(11);
        }
        if (this.myExpandableItemsHandler == null) {
            super.setCellRenderer(cellRenderer);
            return;
        }
        super.setCellRenderer(new ExpandedItemListCellRendererWrapper<E>(cellRenderer, this.myExpandableItemsHandler));
    }

    public <T> void installCellRenderer(@NotNull NotNullFunction<? super T, ? extends JComponent> fun) {
        if (fun == null) {
            JBList.$$$reportNull$$$0(12);
        }
        this.setCellRenderer(new SelectionAwareListCellRenderer<T>(fun));
    }

    public void setDataProvider(@NotNull DataProvider provider) {
        if (provider == null) {
            JBList.$$$reportNull$$$0(13);
        }
        DataManager.registerDataProvider(this, provider);
    }

    public void disableEmptyText() {
        this.getEmptyText().setText("");
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJBList();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listData";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/JBList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/JBList";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultListModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandableItemsHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpandableItemsHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultListModel";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCellRenderer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "installCellRenderer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setDataProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleJBList
    extends JList.AccessibleJList {
        protected AccessibleJBList() {
            super(JBList.this);
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            return this.getAccessibleChild(JBList.this.locationToIndex(p));
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= JBList.this.getModel().getSize()) {
                return null;
            }
            return new AccessibleJBListChild(JBList.this, i);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return (AccessibleRole)UIUtil.invokeAndWaitIfNeeded(() -> super.getAccessibleRole());
        }

        /*
         * Signature claims super is javax.swing.JList$AccessibleJList.AccessibleJListChild, not javax.swing.JList$AccessibleJList$AccessibleJListChild - discarding signature.
         */
        protected class AccessibleJBListChild
        extends JList.AccessibleJList.AccessibleJListChild {
            public AccessibleJBListChild(JBList<E> parent, int indexInParent) {
                super(AccessibleJBList.this, parent, indexInParent);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return (AccessibleRole)UIUtil.invokeAndWaitIfNeeded(() -> super.getAccessibleRole());
            }
        }
    }

    public static class StripedListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!isSelected && index % 2 == 0) {
                this.setBackground(UIUtil.getDecoratedRowColor());
            }
            return this;
        }
    }
}

