/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.BooleanAccessor;
import com.intellij.application.options.codeStyle.properties.BraceStyleAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CommaSeparatedValues;
import com.intellij.application.options.codeStyle.properties.CommaSeparatedValuesAccessor;
import com.intellij.application.options.codeStyle.properties.EnumPropertyAccessor;
import com.intellij.application.options.codeStyle.properties.ForceBracesAccessor;
import com.intellij.application.options.codeStyle.properties.IntegerAccessor;
import com.intellij.application.options.codeStyle.properties.StringAccessor;
import com.intellij.application.options.codeStyle.properties.WrapOnTypingAccessor;
import com.intellij.application.options.codeStyle.properties.WrappingAccessor;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FieldAccessorFactory {
    private final Field myField;

    FieldAccessorFactory(Field field) {
        this.myField = field;
    }

    private ValueType getValueType() {
        String fieldName = this.myField.getName();
        Class<?> fieldType = this.myField.getType();
        String name = fieldType.getName();
        if (fieldType.isPrimitive()) {
            if ("int".equals(name)) {
                CommonCodeStyleSettings.WrapConstant wrapAnnotation = this.myField.getAnnotation(CommonCodeStyleSettings.WrapConstant.class);
                if (wrapAnnotation != null) {
                    return ValueType.WRAP;
                }
                CommonCodeStyleSettings.BraceStyleConstant braceAnnotation = this.myField.getAnnotation(CommonCodeStyleSettings.BraceStyleConstant.class);
                if (braceAnnotation != null) {
                    return ValueType.BRACE_STYLE;
                }
                if (fieldName.endsWith("_BRACE_FORCE")) {
                    return ValueType.FORCE_BRACES;
                }
                return ValueType.INT;
            }
            if ("boolean".equals(name)) {
                return ValueType.BOOLEAN;
            }
        } else {
            if ("java.lang.String".equals(name)) {
                return ValueType.STRING;
            }
            if (fieldType.isEnum()) {
                return ValueType.ENUM;
            }
        }
        return ValueType.OTHER;
    }

    @Nullable
    CodeStyleFieldAccessor createAccessor(@NotNull Object codeStyleObject) {
        if (codeStyleObject == null) {
            FieldAccessorFactory.$$$reportNull$$$0(0);
        }
        if (this.mayHaveAccessor()) {
            switch (this.getValueType()) {
                case BOOLEAN: {
                    if ("USE_TAB_CHARACTER".equals(this.myField.getName())) {
                        return new TabCharPropertyAccessor(codeStyleObject, this.myField);
                    }
                    return new BooleanAccessor(codeStyleObject, this.myField);
                }
                case INT: {
                    if ("WRAP_ON_TYPING".equals(this.myField.getName())) {
                        return new WrapOnTypingAccessor(codeStyleObject, this.myField);
                    }
                    return new IntegerAccessor(codeStyleObject, this.myField);
                }
                case STRING: {
                    CommaSeparatedValues annotation = this.myField.getAnnotation(CommaSeparatedValues.class);
                    if (annotation != null) {
                        return new CommaSeparatedValuesAccessor(codeStyleObject, this.myField);
                    }
                    return new StringAccessor(codeStyleObject, this.myField);
                }
                case WRAP: {
                    return new WrappingAccessor(codeStyleObject, this.myField);
                }
                case BRACE_STYLE: {
                    return new BraceStyleAccessor(codeStyleObject, this.myField);
                }
                case FORCE_BRACES: {
                    return new ForceBracesAccessor(codeStyleObject, this.myField);
                }
                case ENUM: {
                    return new EnumPropertyAccessor(codeStyleObject, this.myField);
                }
            }
        }
        return null;
    }

    private boolean mayHaveAccessor() {
        return this.myField.getType().getCanonicalName() != null && this.myField.getAnnotation(Deprecated.class) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleObject", "com/intellij/application/options/codeStyle/properties/FieldAccessorFactory", "createAccessor"));
    }

    private static class TabCharPropertyAccessor
    extends CodeStyleFieldAccessor<Boolean, String> {
        TabCharPropertyAccessor(@NotNull Object object, @NotNull Field field) {
            if (object == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(0);
            }
            if (field == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(1);
            }
            super(object, field);
        }

        @Override
        @Nullable
        protected String parseString(@NotNull String string) {
            if (string == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        protected String valueToString(@NotNull String value) {
            if (value == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(3);
            }
            return value;
        }

        @Override
        @Nullable
        protected Boolean fromExternal(@NotNull String str) {
            if (str == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(4);
            }
            return "tab".equalsIgnoreCase(str);
        }

        @Override
        @NotNull
        protected String toExternal(@NotNull Boolean value) {
            if (value == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(5);
            }
            String string = value != false ? "tab" : "space";
            if (string == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        public String getPropertyName() {
            return "indent_style";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/properties/FieldAccessorFactory$TabCharPropertyAccessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/properties/FieldAccessorFactory$TabCharPropertyAccessor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toExternal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseString";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "valueToString";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fromExternal";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "toExternal";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum ValueType {
        BOOLEAN,
        INT,
        STRING,
        WRAP,
        BRACE_STYLE,
        FORCE_BRACES,
        ENUM,
        OTHER;

    }
}

