/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EmptyStatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\u001a\u000e\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getEventLogProvider", "recorderId", "", "getEventLogProviders", "", "intellij.platform.ide.impl"})
public final class StatisticsEventLoggerKt {
    private static final Logger LOG;
    private static final ExtensionPointName<StatisticsEventLoggerProvider> EP_NAME;

    @NotNull
    public static final List<StatisticsEventLoggerProvider> getEventLogProviders() {
        if (Extensions.getRootArea().hasExtensionPoint(EP_NAME.getName())) {
            List list2 = EP_NAME.getExtensionList();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"EP_NAME.extensionList");
            return list2;
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final StatisticsEventLoggerProvider getEventLogProvider(@NotNull String recorderId) {
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        List<StatisticsEventLoggerProvider> providers = StatisticsEventLoggerKt.getEventLogProviders();
        for (StatisticsEventLoggerProvider provider : providers) {
            if (!StringUtil.equals((CharSequence)provider.getRecorderId(), (CharSequence)recorderId)) continue;
            return provider;
        }
        LOG.warn("Cannot find event log provider with recorder-id=" + recorderId);
        return new EmptyStatisticsEventLoggerProvider(recorderId);
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.internal.statistic.eventLog.StatisticsEventLogger");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026g.StatisticsEventLogger\")");
        LOG = logger;
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.statistic.eventLog.eventLoggerProvider");
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026Log.eventLoggerProvider\")");
        EP_NAME = extensionPointName;
    }
}

