/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class SearchEverywherePsiRenderer
extends PsiElementListCellRenderer<PsiElement> {
    public SearchEverywherePsiRenderer() {
        this.setFocusBorderEnabled(false);
        this.setLayout(new BorderLayout(){

            @Override
            public void layoutContainer(Container target2) {
                super.layoutContainer(target2);
                Component right = this.getLayoutComponent("East");
                Component left = this.getLayoutComponent("West");
                if (right != null && left != null && left.getBounds().x + left.getBounds().width > right.getBounds().x) {
                    Rectangle bounds2 = right.getBounds();
                    int newX = left.getBounds().x + left.getBounds().width;
                    right.setBounds(newX, bounds2.y, bounds2.width - (newX - bounds2.x), bounds2.height);
                }
            }
        });
    }

    @Override
    public String getElementText(PsiElement element) {
        VirtualFile file2;
        Object object = element instanceof PsiFile ? PsiUtilCore.getVirtualFile((PsiElement)element) : (file2 = element instanceof VirtualFile ? (VirtualFile)element : null);
        if (file2 != null) {
            return VfsPresentationUtil.getPresentableNameForUI(element.getProject(), file2);
        }
        String name = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null;
        return StringUtil.notNullize((String)name, (String)"<unnamed>");
    }

    @Override
    @Nullable
    protected String getContainerText(PsiElement element, String name) {
        return this.getContainerTextForLeftComponent(element, name, -1, (FontMetrics)null);
    }

    @Override
    @Nullable
    protected String getContainerTextForLeftComponent(PsiElement element, String name, int maxWidth, FontMetrics fm) {
        boolean in;
        String text2 = SymbolPresentationUtil.getSymbolContainerText(element);
        if (text2 == null) {
            return null;
        }
        if (text2.startsWith("(") && text2.endsWith(")")) {
            text2 = text2.substring(1, text2.length() - 1);
        }
        if ((text2.contains("/") || text2.contains(File.separator)) && element instanceof PsiFileSystemItem) {
            Project project = element.getProject();
            String basePath = Optional.ofNullable(project.getBasePath()).map(FileUtil::toSystemDependentName).orElse(null);
            VirtualFile file2 = ((PsiFileSystemItem)element).getVirtualFile();
            if (file2 != null) {
                text2 = FileUtil.toSystemDependentName((String)text2);
                String filePath = FileUtil.toSystemDependentName((String)file2.getPath());
                if (basePath != null && FileUtil.isAncestor((String)basePath, (String)filePath, (boolean)true)) {
                    text2 = (String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((String)basePath, (String)text2, (char)File.separatorChar), (Object)text2);
                } else {
                    String rootPath = Optional.ofNullable(GotoFileCellRenderer.getAnyRoot(file2, project)).map(root -> FileUtil.toSystemDependentName((String)root.getPath())).filter(root -> basePath != null && FileUtil.isAncestor((String)basePath, (String)root, (boolean)true)).orElse(null);
                    String string = text2 = rootPath != null ? (String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((String)rootPath, (String)text2, (char)File.separatorChar), (Object)text2) : FileUtil.getLocationRelativeToUserHome((String)text2);
                }
            }
        }
        if (in = text2.startsWith("in ")) {
            text2 = text2.substring(3);
        }
        String left = in ? "(in " : "(";
        String right = ")";
        String adjustedText = left + text2 + right;
        if (maxWidth < 0) {
            return adjustedText;
        }
        int fullWidth = fm.stringWidth(adjustedText);
        if (fullWidth < maxWidth) {
            return adjustedText;
        }
        String separator = text2.contains("/") ? "/" : (SystemInfo.isWindows && text2.contains("\\") ? "\\" : (text2.contains(".") ? "." : (text2.contains("-") ? "-" : " ")));
        LinkedList<String> parts = new LinkedList<String>(StringUtil.split((String)text2, (String)separator));
        while (parts.size() > 1) {
            int index = parts.size() / 2 - 1;
            parts.remove(index);
            if (fm.stringWidth(StringUtil.join(parts, (String)separator) + "...") >= maxWidth) continue;
            parts.add(index, "...");
            return left + StringUtil.join(parts, (String)separator) + right;
        }
        int adjustedWidth = Math.max(adjustedText.length() * maxWidth / fullWidth - 1, left.length() + right.length() + 3);
        return StringUtil.trimMiddle((String)adjustedText, (int)adjustedWidth);
    }

    @Override
    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer2, JList list2, Object value, int index, boolean selected2, boolean hasFocus) {
        return GotoFileCellRenderer.doCustomizeNonPsiElementLeftRenderer(renderer2, list2, value, this.getNavigationItemAttributes(value));
    }

    @Override
    protected DefaultListCellRenderer getRightCellRenderer(Object value) {
        DefaultListCellRenderer rightRenderer = super.getRightCellRenderer(value);
        if (rightRenderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
            return null;
        }
        return rightRenderer;
    }

    @Override
    protected int getIconFlags() {
        return 2;
    }
}

