/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServiceViewDragHelper {
    ServiceViewDragHelper() {
    }

    static DnDSource createSource(@NotNull ServiceView serviceView) {
        if (serviceView == null) {
            ServiceViewDragHelper.$$$reportNull$$$0(0);
        }
        return new ServiceViewDnDSource(serviceView);
    }

    static void installDnDSupport(final @NotNull Project project, final @NotNull InternalDecorator decorator, final @NotNull ContentManager contentManager) {
        if (project == null) {
            ServiceViewDragHelper.$$$reportNull$$$0(1);
        }
        if (decorator == null) {
            ServiceViewDragHelper.$$$reportNull$$$0(2);
        }
        if (contentManager == null) {
            ServiceViewDragHelper.$$$reportNull$$$0(3);
        }
        final Content dropTargetContent = ServiceViewDragHelper.createDropTargetContent();
        DnDSupport.createBuilder((JComponent)decorator).setTargetChecker(new DnDTargetChecker(){

            public boolean update(DnDEvent event) {
                Object o = event.getAttachedObject();
                boolean dropPossible = o instanceof ServiceViewDragBean && event.getPoint().y < decorator.getHeaderHeight();
                event.setDropPossible(dropPossible, "");
                if (dropPossible) {
                    ServiceViewDragBean dragBean;
                    if (contentManager.getIndexOfContent(dropTargetContent) < 0) {
                        contentManager.addContent(dropTargetContent);
                    }
                    ItemPresentation presentation = (dragBean = (ServiceViewDragBean)o).getItems().size() > 1 && dragBean.getContributor() != null ? dragBean.getContributor().getViewDescriptor().getPresentation() : dragBean.getItems().get(0).getViewDescriptor().getPresentation();
                    dropTargetContent.setDisplayName(ServiceViewDragHelper.getDisplayName(presentation));
                    dropTargetContent.setIcon(presentation.getIcon(false));
                } else if (contentManager.getIndexOfContent(dropTargetContent) >= 0) {
                    contentManager.removeContent(dropTargetContent, false);
                }
                return true;
            }
        }).setCleanUpOnLeaveCallback(() -> {
            if (!contentManager.isDisposed() && contentManager.getIndexOfContent(dropTargetContent) >= 0) {
                contentManager.removeContent(dropTargetContent, false);
            }
        }).setDropHandler(new DnDDropHandler(){

            public void drop(DnDEvent event) {
                Object o = event.getAttachedObject();
                if (o instanceof ServiceViewDragBean) {
                    ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).extract((ServiceViewDragBean)o);
                }
            }
        }).install();
        decorator.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (contentManager.getIndexOfContent(dropTargetContent) >= 0) {
                    contentManager.removeContent(dropTargetContent, false);
                }
            }
        });
    }

    static String getDisplayName(ItemPresentation presentation) {
        StringBuilder result2 = new StringBuilder();
        if (presentation instanceof PresentationData) {
            List fragments = ((PresentationData)presentation).getColoredText();
            if (fragments.isEmpty() && presentation.getPresentableText() != null) {
                result2.append(presentation.getPresentableText());
            } else {
                for (PresentableNodeDescriptor.ColoredFragment fragment : fragments) {
                    result2.append(fragment.getText());
                }
            }
        } else if (presentation.getPresentableText() != null) {
            result2.append(presentation.getPresentableText());
        }
        return result2.toString();
    }

    @Nullable
    static ServiceViewContributor getTheOnlyRootContributor(List<ServiceModel.ServiceViewItem> items) {
        ServiceViewContributor result2 = null;
        for (ServiceModel.ServiceViewItem node : items) {
            if (result2 == null) {
                result2 = node.getRootContributor();
                continue;
            }
            if (result2 == node.getRootContributor()) continue;
            return null;
        }
        return result2;
    }

    private static Content createDropTargetContent() {
        Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)new JPanel(), null, false);
        content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content2.setCloseable(true);
        return content2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/services/ServiceViewDragHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSource";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installDnDSupport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ServiceViewDnDSource
    implements DnDSource {
        private final ServiceView myServiceView;

        ServiceViewDnDSource(@NotNull ServiceView serviceView) {
            if (serviceView == null) {
                ServiceViewDnDSource.$$$reportNull$$$0(0);
            }
            this.myServiceView = serviceView;
        }

        public boolean canStartDragging(DnDAction action2, Point dragOrigin) {
            return !this.myServiceView.getSelectedItems().isEmpty();
        }

        public DnDDragStartBean startDragging(DnDAction action2, Point dragOrigin) {
            return new DnDDragStartBean((Object)new ServiceViewDragBean(this.myServiceView, this.myServiceView.getSelectedItems()));
        }

        public void dragDropEnd() {
        }

        public void dropActionChanged(int gestureModifiers) {
        }

        public Pair<Image, Point> createDraggedImage(DnDAction action2, Point dragOrigin, @NotNull DnDDragStartBean bean) {
            if (bean == null) {
                ServiceViewDnDSource.$$$reportNull$$$0(1);
            }
            ServiceViewDragBean dragBean = (ServiceViewDragBean)bean.getAttachedObject();
            int size = dragBean.getItems().size();
            ItemPresentation presentation = null;
            if (size == 1) {
                presentation = dragBean.getItems().get(0).getViewDescriptor().getPresentation();
            } else {
                ServiceViewContributor contributor = dragBean.getContributor();
                if (contributor != null) {
                    presentation = contributor.getViewDescriptor().getPresentation();
                }
            }
            SimpleColoredComponent c2 = new SimpleColoredComponent();
            c2.setForeground(this.myServiceView.getForeground());
            c2.setBackground(this.myServiceView.getBackground());
            if (presentation != null) {
                c2.setIcon(presentation.getIcon(false));
                c2.append(ServiceViewDragHelper.getDisplayName(presentation));
            } else {
                String text2 = size + StringUtil.pluralize((String)" item", (int)size);
                c2.append(text2);
            }
            Dimension preferredSize = c2.getPreferredSize();
            c2.setSize(preferredSize);
            BufferedImage image = UIUtil.createImage((Component)c2, (int)preferredSize.width, (int)preferredSize.height, (int)2);
            c2.setOpaque(false);
            Graphics2D g = image.createGraphics();
            c2.paint((Graphics)g);
            g.dispose();
            return Pair.create((Object)image, (Object)new Point(0, 0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/services/ServiceViewDragHelper$ServiceViewDnDSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createDraggedImage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ServiceViewDragBean
    implements DataProvider {
        private final ServiceView myServiceView;
        private final List<ServiceModel.ServiceViewItem> myItems;
        private final ServiceViewContributor myContributor;

        ServiceViewDragBean(ServiceView serviceView, List<ServiceModel.ServiceViewItem> items) {
            this.myServiceView = serviceView;
            this.myItems = ContainerUtil.filter(items, item -> {
                for (ServiceModel.ServiceViewItem parent = item.getParent(); parent != null; parent = parent.getParent()) {
                    if (!items.contains(parent)) continue;
                    return false;
                }
                return true;
            });
            this.myContributor = ServiceViewDragHelper.getTheOnlyRootContributor(this.myItems);
        }

        ServiceView getServiceView() {
            return this.myServiceView;
        }

        List<ServiceModel.ServiceViewItem> getItems() {
            return this.myItems;
        }

        @Nullable
        ServiceViewContributor getContributor() {
            return this.myContributor;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                ServiceViewDragBean.$$$reportNull$$$0(0);
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return ContainerUtil.map2Array(this.myItems, ServiceModel.ServiceViewItem::getValue);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/execution/services/ServiceViewDragHelper$ServiceViewDragBean", "getData"));
        }
    }
}

