/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class ConsoleViewRunningState
extends ConsoleState {
    private final ConsoleViewImpl myConsole;
    private final ProcessHandler myProcessHandler;
    private final ConsoleState myFinishedStated;
    private final Writer myUserInputWriter;
    private final ProcessAdapter myProcessListener = new ProcessAdapter(){

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                1.$$$reportNull$$$0(1);
            }
            ConsoleViewRunningState.this.myConsole.print(event.getText(), ConsoleViewContentType.getConsoleViewType((Key)outputType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/ConsoleViewRunningState$1";
            objectArray[2] = "onTextAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public ConsoleViewRunningState(ConsoleViewImpl console, ProcessHandler processHandler2, ConsoleState finishedStated, boolean attachToStdOut, boolean attachToStdIn) {
        OutputStream processInput;
        this.myConsole = console;
        this.myProcessHandler = processHandler2;
        this.myFinishedStated = finishedStated;
        if (attachToStdOut) {
            processHandler2.addProcessListener((ProcessListener)this.myProcessListener);
        }
        this.myUserInputWriter = attachToStdIn ? ((processInput = this.myProcessHandler.getProcessInput()) == null ? null : ConsoleViewRunningState.createOutputStreamWriter(processInput, processHandler2)) : null;
    }

    private static OutputStreamWriter createOutputStreamWriter(OutputStream processInput, ProcessHandler processHandler2) {
        Charset charset = null;
        if (processHandler2 instanceof OSProcessHandler) {
            charset = ((OSProcessHandler)processHandler2).getCharset();
        }
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
        }
        return new OutputStreamWriter(processInput, charset);
    }

    @Override
    @NotNull
    public ConsoleState dispose() {
        if (this.myProcessHandler != null) {
            this.myProcessHandler.removeProcessListener((ProcessListener)this.myProcessListener);
        }
        ConsoleState consoleState = this.myFinishedStated;
        if (consoleState == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(0);
        }
        return consoleState;
    }

    @Override
    public boolean isCommandLine(@NotNull String line2) {
        if (line2 == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(1);
        }
        return this.myProcessHandler instanceof BaseProcessHandler && line2.equals(((BaseProcessHandler)this.myProcessHandler).getCommandLine());
    }

    @Override
    public boolean isFinished() {
        return this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated();
    }

    @Override
    public boolean isRunning() {
        return this.myProcessHandler != null && !this.myProcessHandler.isProcessTerminated();
    }

    @Override
    public void sendUserInput(@NotNull String input) throws IOException {
        if (input == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(2);
        }
        if (this.myUserInputWriter == null) {
            throw new IOException(ExecutionBundle.message((String)"no.user.process.input.error.message", (Object[])new Object[0]));
        }
        this.myUserInputWriter.write(input);
        this.myUserInputWriter.flush();
    }

    @Override
    @NotNull
    public ConsoleState attachTo(@NotNull ConsoleViewImpl console, ProcessHandler processHandler2) {
        if (console == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(3);
        }
        ConsoleState consoleState = this.dispose().attachTo(console, processHandler2);
        if (consoleState == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(4);
        }
        return consoleState;
    }

    public String toString() {
        return "Running state";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ConsoleViewRunningState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "dispose";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ConsoleViewRunningState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "attachTo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCommandLine";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sendUserInput";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "attachTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

