/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeUtil {
    @NotNull
    public static Action createSimpleResolveAction(final @NotNull MergeResult result2, final @NotNull MergeRequest request, final @NotNull MergeContext context, final @NotNull MergeTool.MergeViewer viewer, final boolean contentWasModified) {
        if (result2 == null) {
            MergeUtil.$$$reportNull$$$0(0);
        }
        if (request == null) {
            MergeUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MergeUtil.$$$reportNull$$$0(2);
        }
        if (viewer == null) {
            MergeUtil.$$$reportNull$$$0(3);
        }
        String caption = MergeUtil.getResolveActionTitle(result2, request, context);
        AbstractAction abstractAction = new AbstractAction(caption){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (result2 == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(viewer, request, context, contentWasModified)) {
                    return;
                }
                context.finishMerge(result2);
            }
        };
        if (abstractAction == null) {
            MergeUtil.$$$reportNull$$$0(4);
        }
        return abstractAction;
    }

    @NotNull
    public static String getResolveActionTitle(@NotNull MergeResult result2, @Nullable MergeRequest request, @Nullable MergeContext context) {
        Function<MergeResult, String> getter;
        String message;
        if (result2 == null) {
            MergeUtil.$$$reportNull$$$0(5);
        }
        String string = message = (getter = DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS)) != null ? (String)getter.fun((Object)result2) : null;
        if (message != null) {
            String string2 = message;
            if (string2 == null) {
                MergeUtil.$$$reportNull$$$0(6);
            }
            return string2;
        }
        switch (result2) {
            case CANCEL: {
                if ("Abort" == null) {
                    MergeUtil.$$$reportNull$$$0(7);
                }
                return "Abort";
            }
            case LEFT: {
                if ("Accept Left" == null) {
                    MergeUtil.$$$reportNull$$$0(8);
                }
                return "Accept Left";
            }
            case RIGHT: {
                if ("Accept Right" == null) {
                    MergeUtil.$$$reportNull$$$0(9);
                }
                return "Accept Right";
            }
            case RESOLVED: {
                if ("Apply" == null) {
                    MergeUtil.$$$reportNull$$$0(10);
                }
                return "Apply";
            }
        }
        throw new IllegalArgumentException(result2.toString());
    }

    @NotNull
    public static List<String> notNullizeContentTitles(@NotNull List<String> mergeContentTitles) {
        if (mergeContentTitles == null) {
            MergeUtil.$$$reportNull$$$0(11);
        }
        String left = StringUtil.notNullize((String)((String)ThreeSide.LEFT.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0]));
        String base = StringUtil.notNullize((String)((String)ThreeSide.BASE.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]));
        String right = StringUtil.notNullize((String)((String)ThreeSide.RIGHT.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.their", (Object[])new Object[0]));
        List<String> list2 = Arrays.asList(left, base, right);
        if (list2 == null) {
            MergeUtil.$$$reportNull$$$0(12);
        }
        return list2;
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull MergeTool.MergeViewer viewer, @NotNull MergeRequest request, @NotNull MergeContext context, boolean contentWasModified) {
        Condition<MergeTool.MergeViewer> customHandler;
        if (viewer == null) {
            MergeUtil.$$$reportNull$$$0(13);
        }
        if (request == null) {
            MergeUtil.$$$reportNull$$$0(14);
        }
        if (context == null) {
            MergeUtil.$$$reportNull$$$0(15);
        }
        if ((customHandler = DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_CANCEL_HANDLER)) != null) {
            return customHandler.value((Object)viewer);
        }
        return !contentWasModified || MergeUtil.showExitWithoutApplyingChangesDialog(viewer.getComponent(), request, context);
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull JComponent component, @NotNull MergeRequest request, @NotNull MergeContext context) {
        if (component == null) {
            MergeUtil.$$$reportNull$$$0(16);
        }
        if (request == null) {
            MergeUtil.$$$reportNull$$$0(17);
        }
        if (context == null) {
            MergeUtil.$$$reportNull$$$0(18);
        }
        String message = DiffBundle.message((String)"merge.dialog.exit.without.applying.changes.confirmation.message", (Object[])new Object[0]);
        String title = DiffBundle.message((String)"cancel.visual.merge.dialog.title", (Object[])new Object[0]);
        Couple<String> customMessage = DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_CANCEL_MESSAGE);
        if (customMessage != null) {
            title = (String)customMessage.first;
            message = (String)customMessage.second;
        }
        return Messages.showYesNoDialog((Component)component.getRootPane(), (String)message, (String)title, (Icon)Messages.getQuestionIcon()) == 0;
    }

    public static boolean shouldRestoreOriginalContentOnCancel(@NotNull MergeRequest request) {
        MergeCallback callback2;
        if (request == null) {
            MergeUtil.$$$reportNull$$$0(19);
        }
        if ((callback2 = MergeCallback.getCallback((MergeRequest)request)).checkIsValid()) {
            return true;
        }
        return Messages.showYesNoDialog((String)"Merge conflict is outdated. Restore file content prior to conflict resolve start?", (String)DiffBundle.message((String)"cancel.visual.merge.dialog.title", (Object[])new Object[0]), (String)"Restore", (String)"Do nothing", (Icon)Messages.getQuestionIcon()) == 0;
    }

    public static void putRevisionInfos(@NotNull MergeRequest request, @NotNull MergeData data) {
        if (request == null) {
            MergeUtil.$$$reportNull$$$0(20);
        }
        if (data == null) {
            MergeUtil.$$$reportNull$$$0(21);
        }
        if (request instanceof ThreesideMergeRequest) {
            List contents = ((ThreesideMergeRequest)request).getContents();
            MergeUtil.putRevisionInfo(contents, data);
        }
    }

    public static void putRevisionInfos(@NotNull DiffRequest request, @NotNull MergeData data) {
        List contents;
        if (request == null) {
            MergeUtil.$$$reportNull$$$0(22);
        }
        if (data == null) {
            MergeUtil.$$$reportNull$$$0(23);
        }
        if (request instanceof ContentDiffRequest && (contents = ((ContentDiffRequest)request).getContents()).size() == 3) {
            MergeUtil.putRevisionInfo(contents, data);
        }
    }

    private static void putRevisionInfo(@NotNull List<? extends DiffContent> contents, @NotNull MergeData data) {
        if (contents == null) {
            MergeUtil.$$$reportNull$$$0(24);
        }
        if (data == null) {
            MergeUtil.$$$reportNull$$$0(25);
        }
        for (ThreeSide side : ThreeSide.values()) {
            DiffContent content2 = (DiffContent)side.select(contents);
            FilePath filePath = (FilePath)side.select((Object)data.CURRENT_FILE_PATH, (Object)data.ORIGINAL_FILE_PATH, (Object)data.LAST_FILE_PATH);
            VcsRevisionNumber revision = (VcsRevisionNumber)side.select((Object)data.CURRENT_REVISION_NUMBER, (Object)data.ORIGINAL_REVISION_NUMBER, (Object)data.LAST_REVISION_NUMBER);
            if (filePath == null || revision == null) continue;
            content2.putUserData(DiffUserDataKeysEx.REVISION_INFO, (Object)Pair.create((Object)filePath, (Object)revision));
        }
    }

    public static void reportProjectFileChangeIfNeeded(@Nullable Project project, @Nullable VirtualFile file2) {
        if (project != null && file2 != null && MergeUtil.isProjectFile(file2)) {
            StoreReloadManager.getInstance().saveChangedProjectFile(file2, project);
        }
    }

    private static boolean isProjectFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            MergeUtil.$$$reportNull$$$0(26);
        }
        if (file2.isDirectory()) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2)) {
            return true;
        }
        ProjectOpenProcessor importProvider = ProjectOpenProcessor.getImportProvider((VirtualFile)file2);
        return importProvider != null && importProvider.lookForProjectsInDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/MergeUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContentTitles";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/MergeUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleResolveAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveActionTitle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullizeContentTitles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleResolveAction";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolveActionTitle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notNullizeContentTitles";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showExitWithoutApplyingChangesDialog";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldRestoreOriginalContentOnCancel";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "putRevisionInfos";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "putRevisionInfo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isProjectFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ProxyDiffContext
    extends DiffContext {
        @NotNull
        private final MergeContext myMergeContext;

        public ProxyDiffContext(@NotNull MergeContext mergeContext) {
            if (mergeContext == null) {
                ProxyDiffContext.$$$reportNull$$$0(0);
            }
            this.myMergeContext = mergeContext;
        }

        @Nullable
        public Project getProject() {
            return this.myMergeContext.getProject();
        }

        public boolean isWindowFocused() {
            return true;
        }

        public boolean isFocusedInWindow() {
            return this.myMergeContext.isFocusedInWindow();
        }

        public void requestFocusInWindow() {
            this.myMergeContext.requestFocusInWindow();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                ProxyDiffContext.$$$reportNull$$$0(1);
            }
            return (T)this.myMergeContext.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                ProxyDiffContext.$$$reportNull$$$0(2);
            }
            this.myMergeContext.putUserData(key, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergeContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeUtil$ProxyDiffContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

