/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.PopupActionsKt$sam$com_intellij_openapi_util_Condition$0;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsConfigurable;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\b\u0010\n\u001a\u00020\u000bH\u0002\u001a$\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u001a\f\u0010\u0012\u001a\u00020\u0011*\u00020\u0011H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0011*\u00020\u0011H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\t*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\n\u0010\u0018\u001a\u00020\u0011*\u00020\u0019\u00a8\u0006\u001a"}, d2={"getHintInfoFromProvider", "Lcom/intellij/codeInsight/hints/HintInfo;", "offset", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasEditorParameterHintAtOffset", "", "refreshAllOpenEditors", "", "showParameterHintsDialog", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getPattern", "Lkotlin/Function1;", "", "capitalize", "capitalizeFirstLetter", "hasDisabledOptionHintInfo", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "element", "Lcom/intellij/psi/PsiElement;", "toPattern", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "intellij.platform.lang.impl"})
public final class PopupActionsKt {
    public static final void showParameterHintsDialog(@NotNull AnActionEvent e, @NotNull Function1<? super HintInfo, String> getPattern) {
        HintInfo.MethodInfo methodInfo;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull(getPattern, (String)"getPattern");
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"CommonDataKeys.PSI_FILE.\u2026(e.dataContext) ?: return");
        PsiFile file2 = psiFile;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"CommonDataKeys.EDITOR.ge\u2026(e.dataContext) ?: return");
        Editor editor2 = editor;
        Language language = file2.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"file.language");
        Language fileLanguage = language;
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(fileLanguage) == null) {
            return;
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        HintInfo hintInfo = PopupActionsKt.getHintInfoFromProvider(offset, file2, editor2);
        if (hintInfo == null) {
            return;
        }
        HintInfo info = hintInfo;
        HintInfo hintInfo2 = info;
        if (!(hintInfo2 instanceof HintInfo.MethodInfo)) {
            hintInfo2 = null;
        }
        if ((methodInfo = (HintInfo.MethodInfo)hintInfo2) == null || (methodInfo = methodInfo.getLanguage()) == null) {
            methodInfo = fileLanguage;
        }
        HintInfo.MethodInfo selectedLanguage = methodInfo;
        ParameterNameHintsConfigurable dialog2 = new ParameterNameHintsConfigurable((Language)selectedLanguage, (String)getPattern.invoke((Object)info));
        dialog2.show();
    }

    private static final boolean hasDisabledOptionHintInfo(@NotNull InlayParameterHintsProvider $this$hasDisabledOptionHintInfo, PsiElement element) {
        HintInfo info = $this$hasDisabledOptionHintInfo.getHintInfo(element);
        return info instanceof HintInfo.OptionInfo && !((HintInfo.OptionInfo)info).isOptionEnabled();
    }

    private static final boolean hasEditorParameterHintAtOffset(Editor editor, PsiFile file2) {
        if (editor instanceof EditorWindow) {
            return false;
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement element = file2.findElementAt(offset);
        PsiElement psiElement = element;
        int startOffset = psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.getStartOffset() : offset;
        PsiElement psiElement2 = element;
        int endOffset = psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.getEndOffset() : offset;
        return !ParameterHintsPresentationManager.getInstance().getParameterHintsInRange(editor, startOffset, endOffset).isEmpty();
    }

    private static final void refreshAllOpenEditors() {
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
        Project[] projectArray = projectManager.getOpenProjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
        Project[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        Project[] projectArray2 = $this$forEach$iv;
        int n = projectArray2.length;
        for (int i = 0; i < n; ++i) {
            VirtualFile[] $this$forEach$iv2;
            FileEditorManager fileEditorManager;
            Project element$iv;
            Project it = element$iv = projectArray2[i];
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiManager.getInstance((Project)it), (String)"PsiManager.getInstance(it)");
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)it);
            FileEditorManager fileEditorManager2 = fileEditorManager = FileEditorManager.getInstance((Project)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager2, (String)"fileEditorManager");
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager2.getSelectedFiles(), (String)"fileEditorManager.selectedFiles");
            boolean $i$f$forEach2 = false;
            VirtualFile[] virtualFileArray = $this$forEach$iv2;
            int n2 = virtualFileArray.length;
            for (int j = 0; j < n2; ++j) {
                PsiFile psiFile;
                PsiManager psiManager;
                VirtualFile element$iv2;
                VirtualFile it2 = element$iv2 = virtualFileArray[j];
                boolean bl2 = false;
                if (psiManager.findFile(it2) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                PsiFile it3 = psiFile;
                boolean bl5 = false;
                daemonCodeAnalyzer.restart(it3);
            }
        }
    }

    private static final HintInfo getHintInfoFromProvider(int offset, PsiFile file2, Editor editor) {
        Function1 isHintOwnedByElement2;
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"file.findElementAt(offset) ?: return null");
        PsiElement element = psiElement;
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return null;
        }
        InlayParameterHintsProvider provider = inlayParameterHintsProvider;
        Function1 function1 = isHintOwnedByElement2 = (Function1)new Function1<PsiElement, Boolean>(provider, editor){
            final /* synthetic */ InlayParameterHintsProvider $provider;
            final /* synthetic */ Editor $editor;

            public final boolean invoke(@NotNull PsiElement e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                HintInfo hintInfo = this.$provider.getHintInfo(e);
                return hintInfo != null ? hintInfo.isOwnedByPsiElement(e, this.$editor) : false;
            }
            {
                this.$provider = inlayParameterHintsProvider;
                this.$editor = editor;
                super(1);
            }
        };
        PsiElement psiElement2 = PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)new PopupActionsKt$sam$com_intellij_openapi_util_Condition$0(function1));
        if (psiElement2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"PsiTreeUtil.findFirstPar\u2026ByElement) ?: return null");
        PsiElement method = psiElement2;
        return provider.getHintInfo(method);
    }

    @NotNull
    public static final String toPattern(@NotNull HintInfo.MethodInfo $this$toPattern) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toPattern, (String)"$this$toPattern");
        return $this$toPattern.getFullyQualifiedName() + '(' + CollectionsKt.joinToString$default((Iterable)$this$toPattern.getParamNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')';
    }

    private static final String capitalize(@NotNull String $this$capitalize) {
        String string = StringUtil.capitalizeWords((String)$this$capitalize, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.capitalizeWords(this, true)");
        return string;
    }

    private static final String capitalizeFirstLetter(@NotNull String $this$capitalizeFirstLetter) {
        String string = StringUtil.capitalize((String)$this$capitalizeFirstLetter);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.capitalize(this)");
        return string;
    }

    public static final /* synthetic */ HintInfo access$getHintInfoFromProvider(int offset, PsiFile file2, Editor editor) {
        return PopupActionsKt.getHintInfoFromProvider(offset, file2, editor);
    }

    public static final /* synthetic */ boolean access$hasEditorParameterHintAtOffset(Editor editor, PsiFile file2) {
        return PopupActionsKt.hasEditorParameterHintAtOffset(editor, file2);
    }

    public static final /* synthetic */ void access$refreshAllOpenEditors() {
        PopupActionsKt.refreshAllOpenEditors();
    }

    public static final /* synthetic */ String access$capitalizeFirstLetter(String $this$access_u24capitalizeFirstLetter) {
        return PopupActionsKt.capitalizeFirstLetter($this$access_u24capitalizeFirstLetter);
    }

    public static final /* synthetic */ boolean access$hasDisabledOptionHintInfo(InlayParameterHintsProvider $this$access_u24hasDisabledOptionHintInfo, PsiElement element) {
        return PopupActionsKt.hasDisabledOptionHintInfo($this$access_u24hasDisabledOptionHintInfo, element);
    }

    public static final /* synthetic */ String access$capitalize(String $this$access_u24capitalize) {
        return PopupActionsKt.capitalize($this$access_u24capitalize);
    }
}

