/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bootRuntime.command;

import com.intellij.bootRuntime.Controller;
import com.intellij.bootRuntime.bundles.Runtime;
import com.intellij.bootRuntime.command.Copy;
import com.intellij.bootRuntime.command.Delete;
import com.intellij.bootRuntime.command.Download;
import com.intellij.bootRuntime.command.Extract;
import com.intellij.bootRuntime.command.Install;
import com.intellij.bootRuntime.command.RemoteInstall;
import com.intellij.bootRuntime.command.RuntimeCommand;
import com.intellij.openapi.project.Project;

public class CommandFactory {
    private final Project myProject;
    private final Controller myController;
    private static CommandFactory instance;

    private CommandFactory(Project project, Controller controller) {
        this.myProject = project;
        this.myController = controller;
    }

    public static void initialize(Project project, Controller controller) {
        instance = new CommandFactory(project, controller);
    }

    public static CommandFactory getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Command Factory has not been initialized");
        }
        return instance;
    }

    public static RuntimeCommand produce(Type commandType, Runtime runtime) {
        switch (commandType) {
            case REMOTE_INSTALL: {
                return new RemoteInstall(CommandFactory.getInstance().myProject, CommandFactory.getInstance().myController, runtime);
            }
            case DOWNLOAD: {
                return new Download(CommandFactory.getInstance().myProject, CommandFactory.getInstance().myController, runtime);
            }
            case EXTRACT: {
                return new Extract(CommandFactory.getInstance().myProject, CommandFactory.getInstance().myController, runtime);
            }
            case COPY: {
                return new Copy(CommandFactory.getInstance().myProject, CommandFactory.getInstance().myController, runtime);
            }
            case INSTALL: {
                return new Install(CommandFactory.getInstance().myProject, CommandFactory.getInstance().myController, runtime);
            }
            case UNINSTALL: {
                Install install = new Install(CommandFactory.getInstance().myProject, CommandFactory.getInstance().myController, runtime);
                install.setEnabled(false);
                return install;
            }
            case DELETE: {
                return new Delete(CommandFactory.getInstance().myProject, CommandFactory.getInstance().myController, runtime);
            }
        }
        throw new IllegalStateException("Unknown Command Type");
    }

    public static enum Type {
        DOWNLOAD,
        EXTRACT,
        COPY,
        INSTALL,
        UNINSTALL,
        DELETE,
        REMOTE_INSTALL;

    }
}

