/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NonNls;

public abstract class WaitFor {
    private static final int DEFAULT_STEP = 10;
    private static final int MAX_TIMEOUT = 60000;
    private long myWaitTime;
    private boolean myInterrupted;
    private volatile boolean myConditionRealized;
    @NonNls
    private static final String WAIT_FOR_THREAD_NAME = "WaitFor thread";
    private Thread myThread;

    public WaitFor() {
        this(60000);
    }

    public WaitFor(int timeoutMsecs) {
        this(timeoutMsecs, 10);
    }

    public WaitFor(int timeoutMsecs, int step) {
        long started = System.currentTimeMillis();
        long deadline = timeoutMsecs == -1 ? Long.MAX_VALUE : started + (long)timeoutMsecs;
        this.myConditionRealized = false;
        try {
            while (!(this.myConditionRealized = this.condition()) && System.currentTimeMillis() < deadline) {
                Thread.sleep(step);
            }
        }
        catch (InterruptedException e) {
            this.myInterrupted = true;
        }
        this.myWaitTime = System.currentTimeMillis() - started;
    }

    public WaitFor(final int timeoutMsecs, final Runnable toRunOnTrue) {
        this.myThread = new Thread(WAIT_FOR_THREAD_NAME){

            @Override
            public void run() {
                WaitFor.this.myConditionRealized = new WaitFor(timeoutMsecs){

                    @Override
                    protected boolean condition() {
                        return WaitFor.this.condition();
                    }
                }.isConditionRealized();
                if (WaitFor.this.myConditionRealized) {
                    toRunOnTrue.run();
                }
            }
        };
        this.myThread.start();
    }

    public long getWaitedTime() {
        return this.myWaitTime;
    }

    public boolean isConditionRealized() {
        return this.myConditionRealized;
    }

    public boolean isInterrupted() {
        return this.myInterrupted;
    }

    protected abstract boolean condition();

    public void assertCompleted() {
        this.assertCompleted("");
    }

    public void assertCompleted(String message) {
        assert (this.condition()) : message;
    }

    public void join() throws InterruptedException {
        Thread thread = this.myThread;
        if (thread != null) {
            thread.join();
        }
    }
}

