/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/editorconfig/language/psi/EditorConfigTokenSeparatorGenerator;", "Lcom/intellij/lang/TokenSeparatorGenerator;", "()V", "createLineBreak", "Lcom/intellij/psi/impl/source/tree/LeafElement;", "manager", "Lcom/intellij/psi/PsiManager;", "createWhitespace", "text", "", "generateWhitespaceBetweenTokens", "Lcom/intellij/lang/ASTNode;", "left", "right", "intellij.editorconfig"})
public final class EditorConfigTokenSeparatorGenerator
implements TokenSeparatorGenerator {
    @Nullable
    public ASTNode generateWhitespaceBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        ASTNode aSTNode = right.getTreeParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"right.treeParent");
        PsiElement psiElement = aSTNode.getPsi();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"right.treeParent.psi");
        PsiManager manager = psiElement.getManager();
        if (Intrinsics.areEqual((Object)left.getElementType(), (Object)EditorConfigElementTypes.LINE_COMMENT)) {
            PsiManager psiManager = manager;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"manager");
            return (ASTNode)this.createLineBreak(psiManager);
        }
        return null;
    }

    private final LeafElement createLineBreak(PsiManager manager) {
        return this.createWhitespace(manager, "\n");
    }

    private final LeafElement createWhitespace(PsiManager manager, String text) {
        LeafElement leafElement = Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)text, (int)0, (int)text.length(), null, (PsiManager)manager);
        Intrinsics.checkExpressionValueIsNotNull((Object)leafElement, (String)"Factory.createSingleLeaf\u2026xt.length, null, manager)");
        return leafElement;
    }
}

