/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewManager;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.util.EditorConfigPresentationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigNavigationActionsFactory {
    private static final Key<EditorConfigNavigationActionsFactory> NAVIGATION_FACTORY_KEY = Key.create((String)"editor.config.navigation.factory");
    private final List<String> myEditorConfigFilePaths = new ArrayList<String>();
    private static final Object INSTANCE_LOCK = new Object();

    private EditorConfigNavigationActionsFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<AnAction> getNavigationActions(@NotNull Project project, @NotNull VirtualFile sourceFile) {
        if (project == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(0);
        }
        if (sourceFile == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(1);
        }
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        List<String> list = this.myEditorConfigFilePaths;
        synchronized (list) {
            List<VirtualFile> editorConfigFiles = Utils.pathsToFiles(this.myEditorConfigFilePaths);
            for (VirtualFile editorConfigFile : editorConfigFiles) {
                if (editorConfigFile == null) continue;
                actions.add((AnAction)DumbAwareAction.create((String)EditorConfigNavigationActionsFactory.getActionName(editorConfigFile, editorConfigFiles.size() > 1), event -> EditorConfigNavigationActionsFactory.openEditorConfig(project, sourceFile, editorConfigFile)));
            }
        }
        List<Object> list2 = actions.size() <= 1 ? actions : Collections.singletonList(new NavigationActionGroup(actions.toArray(AnAction.EMPTY_ARRAY)));
        if (list2 == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private static void openEditorConfig(@NotNull Project project, @NotNull VirtualFile sourceFile, @NotNull VirtualFile editorConfigFile) {
        FileEditorManager fileEditorManager;
        if (project == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(3);
        }
        if (sourceFile == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(4);
        }
        if (editorConfigFile == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(5);
        }
        if ((fileEditorManager = FileEditorManager.getInstance((Project)project)).isFileOpen(editorConfigFile)) {
            fileEditorManager.closeFile(editorConfigFile);
        }
        EditorConfigPreviewManager.getInstance(project).associateWithPreviewFile(editorConfigFile, sourceFile);
        fileEditorManager.openFile(editorConfigFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEditorConfigFilePaths(@NotNull List<String> editorConfigFilePaths) {
        if (editorConfigFilePaths == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(6);
        }
        List<String> list = this.myEditorConfigFilePaths;
        synchronized (list) {
            this.myEditorConfigFilePaths.clear();
            this.myEditorConfigFilePaths.addAll(editorConfigFilePaths);
        }
    }

    @NotNull
    private static String getActionName(@NotNull VirtualFile file, boolean withFolder) {
        if (file == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(7);
        }
        String fileName = EditorConfigPresentationUtil.getFileName(file, withFolder);
        String string = !withFolder ? EditorConfigBundle.message("action.open.file") : fileName;
        if (string == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(8);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static EditorConfigNavigationActionsFactory getInstance(@NotNull VirtualFile file) {
        if (file == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(9);
        }
        Object object = INSTANCE_LOCK;
        // MONITORENTER : object
        EditorConfigNavigationActionsFactory instance = (EditorConfigNavigationActionsFactory)file.getUserData(NAVIGATION_FACTORY_KEY);
        if (instance == null) {
            instance = new EditorConfigNavigationActionsFactory();
            file.putUserData(NAVIGATION_FACTORY_KEY, (Object)instance);
        }
        EditorConfigNavigationActionsFactory editorConfigNavigationActionsFactory = instance;
        // MONITOREXIT : object
        if (editorConfigNavigationActionsFactory != null) return editorConfigNavigationActionsFactory;
        EditorConfigNavigationActionsFactory.$$$reportNull$$$0(10);
        return editorConfigNavigationActionsFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/EditorConfigNavigationActionsFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorConfigFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorConfigFilePaths";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigNavigationActionsFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationActions";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openEditorConfig";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateEditorConfigFilePaths";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NavigationActionGroup
    extends ActionGroup {
        private final AnAction[] myChildActions;

        private NavigationActionGroup(AnAction[] actions) {
            super(EditorConfigBundle.message("action.open.file"), true);
            this.myChildActions = actions;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (this.myChildActions == null) {
                NavigationActionGroup.$$$reportNull$$$0(0);
            }
            return this.myChildActions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/editorconfig/configmanagement/EditorConfigNavigationActionsFactory$NavigationActionGroup", "getChildren"));
        }
    }
}

