/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveTrailingBlankLinesFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    @NotNull
    public String getText() {
        if ("Remove trailing blank lines" == null) {
            RemoveTrailingBlankLinesFix.$$$reportNull$$$0(0);
        }
        return "Remove trailing blank lines";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            RemoveTrailingBlankLinesFix.$$$reportNull$$$0(1);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            RemoveTrailingBlankLinesFix.$$$reportNull$$$0(2);
        }
        RemoveTrailingBlankLinesFix.removeTrailingBlankLines(file);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            RemoveTrailingBlankLinesFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            RemoveTrailingBlankLinesFix.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            RemoveTrailingBlankLinesFix.$$$reportNull$$$0(5);
        }
        RemoveTrailingBlankLinesFix.removeTrailingBlankLines(descriptor2.getPsiElement().getContainingFile());
    }

    private static void removeTrailingBlankLines(PsiFile file) {
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        int lastBlankLineOffset = -1;
        for (int i = document.getLineCount() - 1; i >= 0; --i) {
            int lineStart = document.getLineStartOffset(i);
            String trimmed = document.getCharsSequence().subSequence(lineStart, document.getLineEndOffset(i)).toString().trim();
            if (trimmed.length() > 0) break;
            lastBlankLineOffset = lineStart;
        }
        if (lastBlankLineOffset > 0) {
            document.deleteString(lastBlankLineOffset, document.getTextLength());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/RemoveTrailingBlankLinesFix";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/RemoveTrailingBlankLinesFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

