/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.kdbx.IncorrectMasterPasswordException;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KdbxPassword;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.keePass.BaseKeePassCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.credentialStore.keePass.MasterKey;
import com.intellij.credentialStore.keePass.MasterKeyFileStorage;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.util.io.PathKt;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0013\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0017H\u0014J\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R$\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t@VX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/credentialStore/keePass/KeePassCredentialStore;", "Lcom/intellij/credentialStore/keePass/BaseKeePassCredentialStore;", "dbFile", "Ljava/nio/file/Path;", "masterKeyFile", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "masterKeyStorage", "Lcom/intellij/credentialStore/keePass/MasterKeyFileStorage;", "preloadedDb", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "(Ljava/nio/file/Path;Lcom/intellij/credentialStore/keePass/MasterKeyFileStorage;Lcom/intellij/credentialStore/kdbx/KeePassDatabase;)V", "<set-?>", "db", "getDb", "()Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "setDb", "(Lcom/intellij/credentialStore/kdbx/KeePassDatabase;)V", "getDbFile$intellij_platform_credentialStore", "()Ljava/nio/file/Path;", "isNeedToSave", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMasterKeyFile", "clear", "", "deleteFileStorage", "", "markDirty", "reload", "save", "masterKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "setMasterPassword", "masterKey", "Lcom/intellij/credentialStore/keePass/MasterKey;", "secureRandom", "Ljava/security/SecureRandom;", "intellij.platform.credentialStore"})
public final class KeePassCredentialStore
extends BaseKeePassCredentialStore {
    private final AtomicBoolean isNeedToSave;
    @NotNull
    private KeePassDatabase db;
    @NotNull
    private final Path dbFile;
    private final MasterKeyFileStorage masterKeyStorage;

    @Override
    @NotNull
    protected KeePassDatabase getDb() {
        return this.db;
    }

    public void setDb(@NotNull KeePassDatabase keePassDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)keePassDatabase, (String)"<set-?>");
        this.db = keePassDatabase;
    }

    @NotNull
    public final Path getMasterKeyFile() {
        return this.masterKeyStorage.getPasswordFile();
    }

    public final synchronized void reload() {
        byte[] byArray = this.masterKeyStorage.load();
        if (byArray == null) {
            Intrinsics.throwNpe();
        }
        byte[] key = byArray;
        KdbxPassword kdbxPassword = new KdbxPassword(key);
        ArraysKt.fill$default((byte[])key, (byte)0, (int)0, (int)0, (int)6, null);
        this.setDb(KdbxKt.loadKdbx(this.dbFile, kdbxPassword));
        this.isNeedToSave.set(false);
    }

    public final synchronized void save(@NotNull EncryptionSpec masterKeyEncryptionSpec) {
        Intrinsics.checkParameterIsNotNull((Object)masterKeyEncryptionSpec, (String)"masterKeyEncryptionSpec");
        if (!this.isNeedToSave.compareAndSet(true, false) && !this.getDb().isDirty()) {
            return;
        }
        try {
            SecureRandom secureRandom2 = CredentialStoreKt.createSecureRandom();
            byte[] masterKey = this.masterKeyStorage.load();
            KdbxPassword kdbxPassword = null;
            if (masterKey == null) {
                MasterKey key = KeePassCredentialStoreKt.generateRandomMasterKey(masterKeyEncryptionSpec, secureRandom2);
                byte[] byArray = key.getValue();
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
                kdbxPassword = new KdbxPassword(byArray);
                this.masterKeyStorage.save(key);
            } else {
                kdbxPassword = new KdbxPassword(masterKey);
                ArraysKt.fill$default((byte[])masterKey, (byte)0, (int)0, (int)0, (int)6, null);
            }
            PathKt.writeSafe((Path)this.dbFile, (Function1)((Function1)new Function1<OutputStream, Unit>(this, kdbxPassword, secureRandom2){
                final /* synthetic */ KeePassCredentialStore this$0;
                final /* synthetic */ KdbxPassword $kdbxPassword;
                final /* synthetic */ SecureRandom $secureRandom;

                public final void invoke(@NotNull OutputStream it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.this$0.getDb().save$intellij_platform_credentialStore(this.$kdbxPassword, it, this.$secureRandom);
                }
                {
                    this.this$0 = keePassCredentialStore;
                    this.$kdbxPassword = kdbxPassword;
                    this.$secureRandom = secureRandom2;
                    super(1);
                }
            }));
            FileUtilKt.setOwnerPermissions((Path)this.dbFile);
        }
        catch (Throwable e) {
            this.isNeedToSave.set(true);
            CredentialStoreKt.getLOG().error("Cannot save password database", e);
        }
    }

    public final synchronized boolean isNeedToSave() {
        return this.isNeedToSave.get() || this.getDb().isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void deleteFileStorage() {
        try {
            PathKt.delete$default((Path)this.dbFile, (boolean)false, (int)1, null);
        }
        finally {
            this.masterKeyStorage.save(null);
        }
    }

    public final void clear() {
        this.getDb().getRootGroup$intellij_platform_credentialStore().removeGroup("IntelliJ Platform");
        this.isNeedToSave.set(this.getDb().isDirty());
    }

    public final void setMasterPassword(@NotNull MasterKey masterKey, @NotNull SecureRandom secureRandom2) {
        Intrinsics.checkParameterIsNotNull((Object)masterKey, (String)"masterKey");
        Intrinsics.checkParameterIsNotNull((Object)secureRandom2, (String)"secureRandom");
        KeePassCredentialStoreKt.saveDatabase(this.dbFile, this.getDb(), masterKey, this.masterKeyStorage, secureRandom2);
    }

    @Override
    protected void markDirty() {
        this.isNeedToSave.set(true);
    }

    @NotNull
    public final Path getDbFile$intellij_platform_credentialStore() {
        return this.dbFile;
    }

    public KeePassCredentialStore(@NotNull Path dbFile, @NotNull MasterKeyFileStorage masterKeyStorage, @Nullable KeePassDatabase preloadedDb) {
        KeePassDatabase keePassDatabase;
        Intrinsics.checkParameterIsNotNull((Object)dbFile, (String)"dbFile");
        Intrinsics.checkParameterIsNotNull((Object)masterKeyStorage, (String)"masterKeyStorage");
        this.dbFile = dbFile;
        this.masterKeyStorage = masterKeyStorage;
        if (preloadedDb == null) {
            this.isNeedToSave = new AtomicBoolean(false);
            if (PathKt.exists((Path)this.dbFile)) {
                byte[] byArray = this.masterKeyStorage.load();
                if (byArray == null) {
                    throw (Throwable)new IncorrectMasterPasswordException(true);
                }
                byte[] masterPassword = byArray;
                keePassDatabase = KdbxKt.loadKdbx(this.dbFile, KdbxPassword.Companion.createAndClear(masterPassword));
            } else {
                keePassDatabase = new KeePassDatabase(null, 1, null);
            }
        } else {
            this.isNeedToSave = new AtomicBoolean(true);
            keePassDatabase = preloadedDb;
        }
        this.db = keePassDatabase;
    }

    public /* synthetic */ KeePassCredentialStore(Path path, MasterKeyFileStorage masterKeyFileStorage, KeePassDatabase keePassDatabase, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            keePassDatabase = null;
        }
        this(path, masterKeyFileStorage, keePassDatabase);
    }

    public KeePassCredentialStore(@NotNull Path dbFile, @NotNull Path masterKeyFile) {
        Intrinsics.checkParameterIsNotNull((Object)dbFile, (String)"dbFile");
        Intrinsics.checkParameterIsNotNull((Object)masterKeyFile, (String)"masterKeyFile");
        this(dbFile, new MasterKeyFileStorage(masterKeyFile), null);
    }
}

