/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sejda.io.BufferedCountingChannelWriter;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSBoolean;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.output.COSWriter;
import org.sejda.sambox.util.CharUtils;
import org.sejda.sambox.util.Hex;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;

class DefaultCOSWriter
implements COSWriter {
    protected static final byte SPACE = 32;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte SOLIDUS = 47;
    private static final byte REVERSE_SOLIDUS = 92;
    private static final byte NUMBER_SIGN = 35;
    private static final byte LESS_THEN = 60;
    private static final byte GREATER_THEN = 62;
    private static final byte LEFT_PARENTHESIS = 40;
    private static final byte RIGHT_PARENTHESIS = 41;
    private static final byte LEFT_SQUARE_BRACKET = 91;
    private static final byte RIGHT_SQUARE_BRACKET = 93;
    private static final byte[] STREAM = "stream".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ENDSTREAM = "endstream".getBytes(StandardCharsets.US_ASCII);
    private BufferedCountingChannelWriter writer;

    public DefaultCOSWriter(CountingWritableByteChannel channel) {
        RequireUtils.requireNotNullArg((Object)channel, (String)"Cannot write to a null channel");
        this.writer = new BufferedCountingChannelWriter(channel);
    }

    public DefaultCOSWriter(BufferedCountingChannelWriter writer) {
        RequireUtils.requireNotNullArg((Object)writer, (String)"Cannot write to a null writer");
        this.writer = writer;
    }

    @Override
    public void visit(COSArray value) throws IOException {
        this.writer.write((byte)91);
        Iterator<COSBase> i = value.iterator();
        while (i.hasNext()) {
            COSBase current = i.next();
            this.writeValue(Optional.ofNullable(current).orElse(COSNull.NULL));
            if (!i.hasNext()) continue;
            this.writer.write((byte)32);
        }
        this.writer.write((byte)93);
        this.writeComplexObjectSeparator();
    }

    @Override
    public void visit(COSBoolean value) throws IOException {
        this.writer.write(value.toString());
    }

    @Override
    public void visit(COSDictionary dictionary) throws IOException {
        this.writer.write((byte)60);
        this.writer.write((byte)60);
        this.writeDictionaryItemsSeparator();
        for (Map.Entry<COSName, COSBase> entry : dictionary.entrySet()) {
            COSBase value = entry.getValue();
            if (value == null) continue;
            entry.getKey().accept(this);
            this.writer.write((byte)32);
            this.writeValue(entry.getValue());
            this.writeDictionaryItemsSeparator();
        }
        this.writer.write((byte)62);
        this.writer.write((byte)62);
        this.writeComplexObjectSeparator();
    }

    @Override
    public void visit(COSFloat value) throws IOException {
        this.writer.write(value.toString());
    }

    @Override
    public void visit(COSInteger value) throws IOException {
        this.writer.write(value.toString());
    }

    @Override
    public void visit(COSName value) throws IOException {
        this.writer.write((byte)47);
        byte[] bytes = value.getName().getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < bytes.length; ++i) {
            int current = bytes[i] & 0xFF;
            if (CharUtils.isLetter(current) || CharUtils.isDigit(current)) {
                this.writer.write(bytes[i]);
                continue;
            }
            this.writer.write((byte)35);
            this.writer.write(Hex.getBytes(bytes[i]));
        }
    }

    @Override
    public void visit(COSNull value) throws IOException {
        this.writer.write("null".getBytes(StandardCharsets.US_ASCII));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(COSStream value) throws IOException {
        try {
            COSBase length = value.getItem(COSName.LENGTH);
            if (Objects.isNull(length)) {
                value.setLong(COSName.LENGTH, value.getFilteredLength());
            }
            this.visit((COSDictionary)value);
            this.writer.write(STREAM);
            this.writer.write(CRLF);
            long streamStartingPosition = this.writer.offset();
            this.writer.write(value.getFilteredStream());
            if (length instanceof IndirectCOSObjectReference) {
                ((IndirectCOSObjectReference)length).setValue(new COSInteger(this.writer.offset() - streamStartingPosition));
            }
            this.writer.write(CRLF);
            this.writer.write(ENDSTREAM);
            this.writeComplexObjectSeparator();
        }
        finally {
            IOUtils.closeQuietly((Closeable)value);
        }
    }

    @Override
    public void visit(COSString value) throws IOException {
        if (value.isForceHexForm()) {
            this.writer.write((byte)60);
            this.writer.write(value.toHexString());
            this.writer.write((byte)62);
        } else {
            this.writer.write((byte)40);
            for (byte b : value.getBytes()) {
                switch (b) {
                    case 40: 
                    case 41: 
                    case 92: {
                        this.writer.write((byte)92);
                    }
                }
                this.writer.write(b);
            }
            this.writer.write((byte)41);
        }
    }

    @Override
    public void visit(IndirectCOSObjectReference value) throws IOException {
        this.writer.write(value.toString());
    }

    void writeValue(COSBase value) throws IOException {
        value.accept(this);
    }

    @Override
    public BufferedCountingChannelWriter writer() {
        return this.writer;
    }
}

