/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintDeclarationException;
import org.hibernate.validator.metadata.MethodMetaConstraint;
import org.hibernate.validator.metadata.MethodMetaData;
import org.hibernate.validator.metadata.ParameterMetaData;
import org.hibernate.validator.util.CollectionHelper;
import org.hibernate.validator.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedMethodMetaData
implements Iterable<MethodMetaConstraint<?>> {
    private final Method method;
    private final Map<Class<?>, MethodMetaData> metaDataByDefiningType;
    private final boolean isCascading;
    private final boolean isConstrained;
    private final List<MethodMetaConstraint<?>> returnValueConstraints;
    private final List<ParameterMetaData> parameterMetaData;
    private final ConstraintDeclarationException parameterConstraintDeclarationException;

    private AggregatedMethodMetaData(Builder builder, List<MethodMetaConstraint<?>> returnValueConstraints, List<ParameterMetaData> parameterMetaData, ConstraintDeclarationException parameterConstraintDeclarationException) {
        this.method = builder.method;
        this.metaDataByDefiningType = Collections.unmodifiableMap(builder.metaDataByDefiningType);
        this.isCascading = builder.isCascading;
        this.isConstrained = builder.isConstrained;
        this.returnValueConstraints = Collections.unmodifiableList(returnValueConstraints);
        this.parameterMetaData = Collections.unmodifiableList(parameterMetaData);
        this.parameterConstraintDeclarationException = parameterConstraintDeclarationException;
    }

    public void assertCorrectnessOfMethodParameterConstraints() throws ConstraintDeclarationException {
        if (this.parameterConstraintDeclarationException != null) {
            throw this.parameterConstraintDeclarationException;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public ParameterMetaData getParameterMetaData(int parameterIndex) {
        return this.parameterMetaData.get(parameterIndex);
    }

    public List<ParameterMetaData> getAllParameterMetaData() {
        return this.parameterMetaData;
    }

    public boolean isCascading() {
        return this.isCascading;
    }

    public boolean isConstrained() {
        return this.isConstrained;
    }

    public MethodMetaData getSingleMetaDataFor(Method method) {
        return this.metaDataByDefiningType.get(method.getDeclaringClass());
    }

    public Iterable<MethodMetaData> getAllMethodMetaData() {
        return this.metaDataByDefiningType.values();
    }

    @Override
    public Iterator<MethodMetaConstraint<?>> iterator() {
        return this.returnValueConstraints.iterator();
    }

    public String toString() {
        return "AggregatedMethodMetaData [method=" + this.method + ", isCascading=" + this.isCascading() + ", isConstrained=" + this.isConstrained() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregatedMethodMetaData other = (AggregatedMethodMetaData)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final Method method;
        private final Map<Class<?>, MethodMetaData> metaDataByDefiningType = CollectionHelper.newHashMap();
        private boolean isCascading;
        private boolean isConstrained;

        public Builder(MethodMetaData metaData) {
            this.method = metaData.getMethod();
            this.metaDataByDefiningType.put(this.method.getDeclaringClass(), metaData);
            this.isCascading = metaData.isCascading();
            this.isConstrained = metaData.isConstrained();
        }

        public boolean accepts(MethodMetaData metaData) {
            return ReflectionHelper.haveSameSignature(this.method, metaData.getMethod());
        }

        public void addMetaData(MethodMetaData metaData) {
            MethodMetaData existingMetaData = this.metaDataByDefiningType.get(metaData.getMethod().getDeclaringClass());
            if (existingMetaData != null) {
                metaData = existingMetaData.merge(metaData);
            }
            this.metaDataByDefiningType.put(metaData.getMethod().getDeclaringClass(), metaData);
            this.isCascading = this.isCascading || metaData.isCascading();
            this.isConstrained = this.isConstrained || metaData.isConstrained();
        }

        public AggregatedMethodMetaData build() {
            return new AggregatedMethodMetaData(this, this.collectReturnValueConstraints(), this.findParameterMetaData(), this.checkParameterConstraints());
        }

        private List<MethodMetaConstraint<?>> collectReturnValueConstraints() {
            ArrayList<MethodMetaConstraint<?>> theValue = CollectionHelper.newArrayList();
            for (MethodMetaData oneMethodMetaData : this.metaDataByDefiningType.values()) {
                for (MethodMetaConstraint<?> oneConstraint : oneMethodMetaData) {
                    theValue.add(oneConstraint);
                }
            }
            return theValue;
        }

        private List<ParameterMetaData> findParameterMetaData() {
            for (MethodMetaData oneMethod : this.metaDataByDefiningType.values()) {
                if (!oneMethod.hasParameterConstraints()) continue;
                return oneMethod.getAllParameterMetaData();
            }
            return this.metaDataByDefiningType.get(this.method.getDeclaringClass()).getAllParameterMetaData();
        }

        private ConstraintDeclarationException checkParameterConstraints() {
            Collection<MethodMetaData> allMethods = this.metaDataByDefiningType.values();
            Set<MethodMetaData> methodsWithParameterConstraints = this.getMethodsWithParameterConstraints(allMethods);
            if (methodsWithParameterConstraints.isEmpty()) {
                return null;
            }
            if (methodsWithParameterConstraints.size() > 1) {
                return new ConstraintDeclarationException("Only the root method of an overridden method in an inheritance hierarchy may be annotated with parameter constraints, but there are parameter constraints defined at all of the following overridden methods: " + methodsWithParameterConstraints);
            }
            MethodMetaData constrainedMethod = methodsWithParameterConstraints.iterator().next();
            for (MethodMetaData oneMethod : allMethods) {
                if (constrainedMethod.getMethod().getDeclaringClass().isAssignableFrom(oneMethod.getMethod().getDeclaringClass())) continue;
                return new ConstraintDeclarationException("Only the root method of an overridden method in an inheritance hierarchy may be annotated with parameter constraints. The following method itself has no parameter constraints but it is not defined on a sub-type of " + constrainedMethod.getMethod().getDeclaringClass() + ": " + oneMethod);
            }
            return null;
        }

        private Set<MethodMetaData> getMethodsWithParameterConstraints(Iterable<MethodMetaData> methods) {
            HashSet<MethodMetaData> theValue = CollectionHelper.newHashSet();
            for (MethodMetaData oneMethod : methods) {
                if (!oneMethod.hasParameterConstraints()) continue;
                theValue.add(oneMethod);
            }
            return theValue;
        }
    }
}

