/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.BasePdfToImageTask;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.image.AbstractPdfToMultipleImageParameters;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfToMultipleImageTask<T extends AbstractPdfToMultipleImageParameters>
extends BasePdfToImageTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfToMultipleImageTask.class);
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> sourceOpener = new DefaultPdfSourceOpener();
    private PDDocumentHandler documentHandler = null;

    @Override
    public void before(T parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(T parameters) throws TaskException {
        int currentStep = 0;
        int currentFileNumber = 0;
        int totalSteps = parameters.getSourceList().size();
        for (PdfSource source : parameters.getSourceList()) {
            block8: {
                this.executionContext().assertTaskNotCancelled();
                ++currentStep;
                try {
                    LOG.debug("Opening {}", (Object)source);
                    this.documentHandler = (PDDocumentHandler)source.open(this.sourceOpener);
                    Set requestedPages = parameters.getPages(this.documentHandler.getNumberOfPages());
                    if (!requestedPages.isEmpty()) {
                        LOG.trace("Found {} pages to convert", (Object)totalSteps);
                        Iterator iterator = requestedPages.iterator();
                        while (iterator.hasNext()) {
                            int currentPage = (Integer)iterator.next();
                            File tmpFile = IOUtils.createTemporaryBuffer();
                            LOG.debug("Created output temporary buffer {} ", (Object)tmpFile);
                            try {
                                LOG.trace("Converting page {}", (Object)currentPage);
                                BufferedImage pageImage = this.documentHandler.renderImage(currentPage, parameters.getResolutionInDpi(), parameters.getOutputImageColorType());
                                this.getWriter().openDestination(tmpFile, parameters);
                                this.getWriter().write((RenderedImage)pageImage, parameters);
                                this.getWriter().closeDestination();
                                String outName = NameGenerator.nameGenerator((String)parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest((String)parameters.getOutputImageType().getExtension()).page(currentPage).originalName(source.getName()).fileNumber(currentFileNumber));
                                this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
                            }
                            catch (TaskException e) {
                                this.executionContext().assertTaskIsLenient((Exception)((Object)e));
                                ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).taskWarning(String.format("Page %d was skipped, could not be converted", currentPage), (Exception)((Object)e));
                            }
                        }
                        break block8;
                    }
                    throw new TaskException("No pages converted");
                }
                finally {
                    ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
                }
            }
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(totalSteps);
        }
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Documents converted to {} and saved to {}", (Object)parameters.getOutputImageType(), (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        super.after();
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
    }
}

