/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class UpdateMetadataResponse
extends AbstractResponse {
    private static final Schema UPDATE_METADATA_RESPONSE_V0;
    private static final Schema UPDATE_METADATA_RESPONSE_V1;
    private static final Schema UPDATE_METADATA_RESPONSE_V2;
    private static final Schema UPDATE_METADATA_RESPONSE_V3;
    private static final Schema UPDATE_METADATA_RESPONSE_V4;
    private final Errors error;

    public static Schema[] schemaVersions() {
        return new Schema[]{UPDATE_METADATA_RESPONSE_V0, UPDATE_METADATA_RESPONSE_V1, UPDATE_METADATA_RESPONSE_V2, UPDATE_METADATA_RESPONSE_V3, UPDATE_METADATA_RESPONSE_V4};
    }

    public UpdateMetadataResponse(Errors error) {
        this.error = error;
    }

    public UpdateMetadataResponse(Struct struct) {
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    public static UpdateMetadataResponse parse(ByteBuffer buffer, short version) {
        return new UpdateMetadataResponse(ApiKeys.UPDATE_METADATA.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.UPDATE_METADATA.responseSchema(version));
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        return struct;
    }

    static {
        UPDATE_METADATA_RESPONSE_V4 = UPDATE_METADATA_RESPONSE_V3 = (UPDATE_METADATA_RESPONSE_V2 = (UPDATE_METADATA_RESPONSE_V1 = (UPDATE_METADATA_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE))));
    }
}

