/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.AllTestResults;
import org.gradle.api.internal.tasks.testing.report.ClassPageRenderer;
import org.gradle.api.internal.tasks.testing.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.report.CompositeTestResults;
import org.gradle.api.internal.tasks.testing.report.OverviewPageRenderer;
import org.gradle.api.internal.tasks.testing.report.PackagePageRenderer;
import org.gradle.api.internal.tasks.testing.report.PackageTestResults;
import org.gradle.api.internal.tasks.testing.report.PageRenderer;
import org.gradle.api.internal.tasks.testing.report.TestReporter;
import org.gradle.api.internal.tasks.testing.report.TestResult;
import org.gradle.api.internal.tasks.testing.report.TestResultModel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.reporting.HtmlReportBuilder;
import org.gradle.reporting.HtmlReportRenderer;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.GFileUtils;

public class DefaultTestReport
implements TestReporter {
    private final BuildOperationExecutor buildOperationExecutor;
    private static final Logger LOG = Logging.getLogger(DefaultTestReport.class);

    public DefaultTestReport(BuildOperationExecutor buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void generateReport(TestResultsProvider resultsProvider, File reportDir) {
        LOG.info("Generating HTML test report...");
        Timer clock = Time.startTimer();
        AllTestResults model = this.loadModelFromProvider(resultsProvider);
        this.generateFiles(model, resultsProvider, reportDir);
        LOG.info("Finished generating test html results ({}) into: {}", (Object)clock.getElapsed(), (Object)reportDir);
    }

    private AllTestResults loadModelFromProvider(TestResultsProvider resultsProvider) {
        final AllTestResults model = new AllTestResults();
        resultsProvider.visitClasses((Action<? super TestClassResult>)new Action<TestClassResult>(){

            public void execute(TestClassResult classResult) {
                model.addTestClass(classResult.getId(), classResult.getClassName(), classResult.getClassDisplayName());
                List<TestMethodResult> collectedResults = classResult.getResults();
                for (TestMethodResult collectedResult : collectedResults) {
                    TestResult testResult = model.addTest(classResult.getId(), classResult.getClassName(), classResult.getClassDisplayName(), collectedResult.getName(), collectedResult.getDisplayName(), collectedResult.getDuration());
                    if (collectedResult.getResultType() == TestResult.ResultType.SKIPPED) {
                        testResult.setIgnored();
                        continue;
                    }
                    List<TestFailure> failures = collectedResult.getFailures();
                    for (TestFailure failure : failures) {
                        testResult.addFailure(failure);
                    }
                }
            }
        });
        return model;
    }

    private void generateFiles(AllTestResults model, final TestResultsProvider resultsProvider, final File reportDir) {
        try {
            HtmlReportRenderer htmlRenderer = new HtmlReportRenderer();
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    GFileUtils.deleteQuietly((File)new File(reportDir, "packages"));
                    GFileUtils.deleteQuietly((File)new File(reportDir, "classes"));
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)"Delete old HTML results");
                }
            });
            htmlRenderer.render((Object)model, (ReportRenderer)new ReportRenderer<AllTestResults, HtmlReportBuilder>(){

                public void render(final AllTestResults model, final HtmlReportBuilder output) throws IOException {
                    DefaultTestReport.this.buildOperationExecutor.runAll((Action)new Action<BuildOperationQueue<HtmlReportFileGenerator<? extends CompositeTestResults>>>(){

                        public void execute(BuildOperationQueue<HtmlReportFileGenerator<? extends CompositeTestResults>> queue) {
                            queue.add(DefaultTestReport.generator("index.html", model, new OverviewPageRenderer(), output));
                            for (PackageTestResults packageResults : model.getPackages()) {
                                queue.add(DefaultTestReport.generator(packageResults.getBaseUrl(), packageResults, new PackagePageRenderer(), output));
                                for (ClassTestResults classResults : packageResults.getClasses()) {
                                    queue.add(DefaultTestReport.generator(classResults.getBaseUrl(), classResults, new ClassPageRenderer(resultsProvider), output));
                                }
                            }
                        }
                    });
                }
            }, reportDir);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not generate test report to '%s'.", reportDir), (Throwable)e);
        }
    }

    public static <T extends CompositeTestResults> HtmlReportFileGenerator<T> generator(String fileUrl, T results, PageRenderer<T> renderer, HtmlReportBuilder output) {
        return new HtmlReportFileGenerator<T>(fileUrl, results, renderer, output);
    }

    private static class HtmlReportFileGenerator<T extends CompositeTestResults>
    implements RunnableBuildOperation {
        private final String fileUrl;
        private final T results;
        private final PageRenderer<T> renderer;
        private final HtmlReportBuilder output;

        HtmlReportFileGenerator(String fileUrl, T results, PageRenderer<T> renderer, HtmlReportBuilder output) {
            this.fileUrl = fileUrl;
            this.results = results;
            this.renderer = renderer;
            this.output = output;
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)"Generate HTML test report for ".concat(((TestResultModel)this.results).getTitle()));
        }

        public void run(BuildOperationContext context) {
            this.output.renderHtmlPage(this.fileUrl, this.results, this.renderer);
        }
    }
}

