/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.JavaErrorMessages;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterLazyParseableNode;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesAndCommentsBinder;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderAdapter;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaParserDefinition;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexingDataKeys;

public class JavaParserUtil {
    private static final Key<LanguageLevel> LANG_LEVEL_KEY = Key.create("JavaParserUtil.LanguageLevel");
    private static final Key<Boolean> DEEP_PARSE_BLOCKS_IN_STATEMENTS = Key.create("JavaParserUtil.ParserExtender");
    private static final TokenSet PRECEDING_COMMENT_SET = TokenSet.orSet(TokenSet.create(JavaElementType.MODULE), ElementType.FULL_MEMBER_BIT_SET);
    private static final TokenSet TRAILING_COMMENT_SET = TokenSet.orSet(TokenSet.create(JavaElementType.PACKAGE_STATEMENT), ElementType.IMPORT_STATEMENT_BASE_BIT_SET, ElementType.FULL_MEMBER_BIT_SET, ElementType.JAVA_STATEMENT_BIT_SET);
    public static final WhitespacesAndCommentsBinder PRECEDING_COMMENT_BINDER = new PrecedingWhitespacesAndCommentsBinder(false);
    public static final WhitespacesAndCommentsBinder SPECIAL_PRECEDING_COMMENT_BINDER = new PrecedingWhitespacesAndCommentsBinder(true);
    public static final WhitespacesAndCommentsBinder TRAILING_COMMENT_BINDER = new TrailingWhitespacesAndCommentsBinder();

    private JavaParserUtil() {
    }

    public static void setLanguageLevel(PsiBuilder builder, LanguageLevel level) {
        builder.putUserData(LANG_LEVEL_KEY, level);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(PsiBuilder builder) {
        LanguageLevel level = builder.getUserData(LANG_LEVEL_KEY);
        assert (level != null) : builder;
        LanguageLevel languageLevel = level;
        if (languageLevel == null) {
            JavaParserUtil.$$$reportNull$$$0(0);
        }
        return languageLevel;
    }

    public static boolean isParseStatementCodeBlocksDeep(PsiBuilder builder) {
        return Boolean.TRUE.equals(builder.getUserData(DEEP_PARSE_BLOCKS_IN_STATEMENTS));
    }

    @NotNull
    public static PsiBuilder createBuilder(ASTNode chameleon) {
        CharSequence text2;
        PsiElement psi = chameleon.getPsi();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        if (TreeUtil.isCollapsedChameleon(chameleon)) {
            text2 = chameleon.getChars();
        } else {
            text2 = psi.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
            if (text2 == null) {
                text2 = chameleon.getChars();
            }
        }
        PsiBuilderFactory factory2 = PsiBuilderFactory.getInstance();
        LanguageLevel level = PsiUtil.getLanguageLevel(psi);
        Lexer lexer = JavaParserDefinition.createLexer(level);
        Language language = psi.getLanguage();
        if (!language.isKindOf(JavaLanguage.INSTANCE)) {
            language = JavaLanguage.INSTANCE;
        }
        PsiBuilder builder = factory2.createBuilder(project, chameleon, lexer, language, text2);
        JavaParserUtil.setLanguageLevel(builder, level);
        PsiBuilder psiBuilder = builder;
        if (psiBuilder == null) {
            JavaParserUtil.$$$reportNull$$$0(1);
        }
        return psiBuilder;
    }

    @NotNull
    public static PsiBuilder createBuilder(LighterLazyParseableNode chameleon) {
        PsiFile psi = chameleon.getContainingFile();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        PsiBuilderFactory factory2 = PsiBuilderFactory.getInstance();
        LanguageLevel level = PsiUtil.getLanguageLevel(psi);
        Lexer lexer = JavaParserDefinition.createLexer(level);
        PsiBuilder builder = factory2.createBuilder(project, chameleon, lexer, chameleon.getTokenType().getLanguage(), chameleon.getText());
        JavaParserUtil.setLanguageLevel(builder, level);
        PsiBuilder psiBuilder = builder;
        if (psiBuilder == null) {
            JavaParserUtil.$$$reportNull$$$0(2);
        }
        return psiBuilder;
    }

    @Nullable
    public static ASTNode parseFragment(ASTNode chameleon, ParserWrapper wrapper) {
        return JavaParserUtil.parseFragment(chameleon, wrapper, true, LanguageLevel.HIGHEST);
    }

    @Nullable
    public static ASTNode parseFragment(ASTNode chameleon, ParserWrapper wrapper, boolean eatAll, LanguageLevel level) {
        PsiElement psi;
        PsiElement psiElement = psi = chameleon.getTreeParent() != null ? chameleon.getTreeParent().getPsi() : chameleon.getPsi();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        PsiBuilderFactory factory2 = PsiBuilderFactory.getInstance();
        Lexer lexer = chameleon.getElementType() == JavaDocElementType.DOC_COMMENT ? JavaParserDefinition.createDocLexer(level) : JavaParserDefinition.createLexer(level);
        PsiBuilder builder = factory2.createBuilder(project, chameleon, lexer, chameleon.getElementType().getLanguage(), chameleon.getChars());
        JavaParserUtil.setLanguageLevel(builder, level);
        PsiBuilder.Marker root2 = builder.mark();
        wrapper.parse(builder);
        if (!builder.eof()) {
            if (!eatAll) {
                throw new AssertionError((Object)("Unexpected token: '" + builder.getTokenText() + "'"));
            }
            PsiBuilder.Marker extras = builder.mark();
            while (!builder.eof()) {
                builder.advanceLexer();
            }
            extras.error(JavaErrorMessages.message("unexpected.tokens", new Object[0]));
        }
        root2.done(chameleon.getElementType());
        return builder.getTreeBuilt().getFirstChildNode();
    }

    public static void done(PsiBuilder.Marker marker, IElementType type2) {
        marker.done(type2);
        WhitespacesAndCommentsBinder left = PRECEDING_COMMENT_SET.contains(type2) ? PRECEDING_COMMENT_BINDER : null;
        WhitespacesAndCommentsBinder right = TRAILING_COMMENT_SET.contains(type2) ? TRAILING_COMMENT_BINDER : null;
        marker.setCustomEdgeTokenBinders(left, right);
    }

    @Nullable
    public static IElementType exprType(@Nullable PsiBuilder.Marker marker) {
        return marker != null ? ((LighterASTNode)((Object)marker)).getTokenType() : null;
    }

    public static void error(PsiBuilder builder, @NotNull String message2) {
        if (message2 == null) {
            JavaParserUtil.$$$reportNull$$$0(3);
        }
        builder.mark().error(message2);
    }

    public static void error(PsiBuilder builder, @NotNull String message2, @Nullable PsiBuilder.Marker before) {
        if (message2 == null) {
            JavaParserUtil.$$$reportNull$$$0(4);
        }
        if (before == null) {
            JavaParserUtil.error(builder, message2);
        } else {
            before.precede().errorBefore(message2, before);
        }
    }

    public static boolean expectOrError(PsiBuilder builder, IElementType expected, @PropertyKey(resourceBundle="messages.JavaErrorMessages") String key) {
        if (!PsiBuilderUtil.expect(builder, expected)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message(key, new Object[0]));
            return false;
        }
        return true;
    }

    public static void emptyElement(PsiBuilder builder, IElementType type2) {
        builder.mark().done(type2);
    }

    public static void emptyElement(PsiBuilder.Marker before, IElementType type2) {
        before.precede().doneBefore(type2, before);
    }

    public static void semicolon(PsiBuilder builder) {
        JavaParserUtil.expectOrError(builder, JavaTokenType.SEMICOLON, "expected.semicolon");
    }

    public static PsiBuilder braceMatchingBuilder(PsiBuilder builder) {
        PsiBuilder.Marker pos = builder.mark();
        int braceCount = 1;
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.LBRACE) {
                ++braceCount;
            } else if (tokenType == JavaTokenType.RBRACE) {
                --braceCount;
            }
            if (braceCount == 0) break;
            builder.advanceLexer();
        }
        int stopAt = builder.getCurrentOffset();
        pos.rollbackTo();
        return JavaParserUtil.stoppingBuilder(builder, stopAt);
    }

    public static PsiBuilder stoppingBuilder(PsiBuilder builder, final int stopAt) {
        return new PsiBuilderAdapter(builder){

            @Override
            public IElementType getTokenType() {
                return this.getCurrentOffset() < stopAt ? super.getTokenType() : null;
            }

            @Override
            public boolean eof() {
                return this.getCurrentOffset() >= stopAt || super.eof();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/JavaParserUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/JavaParserUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrailingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private TrailingWhitespacesAndCommentsBinder() {
        }

        @Override
        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter2) {
            if (tokens.size() == 0) {
                return 0;
            }
            int result2 = 0;
            for (int idx = 0; idx < tokens.size(); ++idx) {
                IElementType tokenType = tokens.get(idx);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (!StringUtil.containsLineBreak(getter2.get(idx))) continue;
                    break;
                }
                if (!ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                result2 = idx + 1;
            }
            return result2;
        }
    }

    private static class PrecedingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private final boolean myAfterEmptyImport;

        PrecedingWhitespacesAndCommentsBinder(boolean afterImport) {
            this.myAfterEmptyImport = afterImport;
        }

        @Override
        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter2) {
            if (tokens.size() == 0) {
                return 0;
            }
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                if (tokens.get(idx) != JavaDocElementType.DOC_COMMENT) continue;
                return idx;
            }
            int result2 = tokens.size();
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                IElementType tokenType = tokens.get(idx);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (StringUtil.getLineBreakCount(getter2.get(idx)) <= 1) continue;
                    break;
                }
                if (!ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                if (!atStreamEdge && (idx != 0 || !this.myAfterEmptyImport) && (idx <= 0 || !TokenSet.WHITE_SPACE.contains(tokens.get(idx - 1)) || !StringUtil.containsLineBreak(getter2.get(idx - 1)))) continue;
                result2 = idx;
            }
            return result2;
        }
    }

    @FunctionalInterface
    public static interface ParserWrapper {
        public void parse(PsiBuilder var1);
    }
}

