/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionParameterTypeContext;
import org.eclipse.php.internal.core.codeassist.strategies.KeywordsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.SimpleProposal;
import org.eclipse.php.internal.core.language.keywords.PHPKeywords;

public class FunctionParameterKeywordTypeStrategy
extends KeywordsStrategy {
    public static final String[] KEYWORDS = new String[]{"self", "parent"};

    public FunctionParameterKeywordTypeStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public FunctionParameterKeywordTypeStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        int n;
        FunctionParameterTypeContext context = (FunctionParameterTypeContext)this.getContext();
        String prefix = context.getPrefix();
        String suffix = "";
        ISourceRange replaceRange = this.getReplacementRange(context);
        if (context.getEnclosingType() != null) {
            try {
                int flags = context.getEnclosingType().getFlags();
                if (!PHPFlags.isNamespace(flags)) {
                    String pref = PHPVersion.PHP5_4.isLessThan(context.getPHPVersion()) ? prefix.toLowerCase() : prefix;
                    String[] stringArray = KEYWORDS;
                    int n2 = KEYWORDS.length;
                    n = 0;
                    while (n < n2) {
                        String keyword = stringArray[n];
                        if (keyword.startsWith(pref)) {
                            reporter.reportKeyword(keyword, suffix, replaceRange);
                        }
                        ++n;
                    }
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
        }
        PHPVersion phpVersion = context.getPHPVersion();
        SimpleProposal[] simpleProposalArray = SimpleProposal.BASIC_TYPES;
        n = SimpleProposal.BASIC_TYPES.length;
        int n3 = 0;
        while (n3 < n) {
            SimpleProposal proposal = simpleProposalArray[n3];
            if (proposal.isValidPrefix(prefix, phpVersion)) {
                reporter.reportKeyword(proposal.getProposal(), suffix, replaceRange);
            }
            ++n3;
        }
    }

    @Override
    protected boolean filterKeyword(PHPKeywords.KeywordData keyword) {
        return true;
    }
}

