/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.views;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.profile.ui.ProfilerUIConstants;

public abstract class AbstractTableSorter
extends ViewerSorter {
    private int fColumn = 0;
    private int fOrder = ProfilerUIConstants.SORT_NONE;

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (this.fOrder == ProfilerUIConstants.SORT_ASCENDING) {
            return super.compare(viewer, e1, e2);
        }
        if (this.fOrder == ProfilerUIConstants.SORT_DESCENDING) {
            return super.compare(viewer, e2, e1);
        }
        return 0;
    }

    public int compare(double d1, double d2) {
        if (this.fOrder == ProfilerUIConstants.SORT_ASCENDING) {
            return Double.compare(d1, d2);
        }
        if (this.fOrder == ProfilerUIConstants.SORT_DESCENDING) {
            return Double.compare(d2, d1);
        }
        return 0;
    }

    public void setColumn(int column) {
        if (this.fColumn == column) {
            ++this.fOrder;
            this.fOrder %= 3;
        } else {
            this.fOrder = ProfilerUIConstants.SORT_ASCENDING;
        }
        this.fColumn = column;
    }

    public int getColumn() {
        return this.fColumn;
    }

    public void setOrder(int order) {
        this.fOrder = order;
    }

    public int getOrder() {
        return this.fOrder;
    }
}

