/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.builtin.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.server.core.builtin.IPHPServerWorkingCopy;
import org.eclipse.php.internal.server.core.builtin.PHPServer;
import org.eclipse.php.internal.server.core.builtin.command.SetDocumentRootDirectoryCommand;
import org.eclipse.php.internal.server.core.builtin.command.SetTestEnvironmentCommand;
import org.eclipse.php.internal.server.ui.builtin.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class DocumentRootEditorSection
extends ServerEditorSection {
    protected Section section;
    protected PHPServer phpServer;
    protected Button serverDirMetadata;
    protected Button serverDirCustom;
    protected Text serverDir;
    protected Button serverDirBrowse;
    protected boolean updating;
    protected PropertyChangeListener listener;
    protected IPublishListener publishListener;
    protected IPath workspacePath;
    protected boolean allowRestrictedEditing;
    protected IPath tempDirPath;
    protected IPath installDirPath;
    private static final String METADATADIR = ".metadata";

    protected void addChangeListeners() {
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (DocumentRootEditorSection.this.updating) {
                    return;
                }
                DocumentRootEditorSection.this.updating = true;
                if ("documentRootDir".equals(event.getPropertyName())) {
                    DocumentRootEditorSection.this.updateServerDirButtons();
                    DocumentRootEditorSection.this.updateServerDirFields();
                    DocumentRootEditorSection.this.validate();
                }
                DocumentRootEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
        this.publishListener = new PublishAdapter(){

            public void publishFinished(IServer server2, IStatus status) {
                boolean flag = false;
                if (status.isOK() && server2.getModules().length == 0) {
                    flag = true;
                }
                if (flag != DocumentRootEditorSection.this.allowRestrictedEditing) {
                    DocumentRootEditorSection.this.allowRestrictedEditing = flag;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            boolean customServerDir = false;
                            if (!(this).DocumentRootEditorSection.this.serverDirCustom.isDisposed()) {
                                customServerDir = (this).DocumentRootEditorSection.this.serverDirCustom.getSelection();
                            }
                            if (!(this).DocumentRootEditorSection.this.serverDirMetadata.isDisposed()) {
                                (this).DocumentRootEditorSection.this.serverDirMetadata.setEnabled((this).DocumentRootEditorSection.this.allowRestrictedEditing);
                            }
                            if (!(this).DocumentRootEditorSection.this.serverDirCustom.isDisposed()) {
                                (this).DocumentRootEditorSection.this.serverDirCustom.setEnabled((this).DocumentRootEditorSection.this.allowRestrictedEditing);
                            }
                            if (!(this).DocumentRootEditorSection.this.serverDir.isDisposed()) {
                                (this).DocumentRootEditorSection.this.serverDir.setEnabled((this).DocumentRootEditorSection.this.allowRestrictedEditing && customServerDir);
                            }
                            if (!(this).DocumentRootEditorSection.this.serverDirBrowse.isDisposed()) {
                                (this).DocumentRootEditorSection.this.serverDirBrowse.setEnabled((this).DocumentRootEditorSection.this.allowRestrictedEditing && customServerDir);
                            }
                        }
                    });
                }
            }
        };
        this.server.getOriginal().addPublishListener(this.publishListener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.section = toolkit.createSection(parent, 458);
        this.section.setText(Messages.serverEditorLocationsSection);
        this.section.setDescription(Messages.serverEditorLocationsDescription);
        this.section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        toolkit.paintBordersFor(composite);
        this.section.setClient((Control)composite);
        this.serverDirMetadata = toolkit.createButton(composite, Messages.serverEditorServerDirMetadata, 16);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.serverDirMetadata.setLayoutData((Object)data);
        this.serverDirMetadata.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DocumentRootEditorSection.this.updating || !DocumentRootEditorSection.this.serverDirMetadata.getSelection()) {
                    return;
                }
                DocumentRootEditorSection.this.updating = true;
                DocumentRootEditorSection.this.execute((IUndoableOperation)new SetTestEnvironmentCommand((IPHPServerWorkingCopy)DocumentRootEditorSection.this.phpServer));
                DocumentRootEditorSection.this.updateServerDirFields();
                DocumentRootEditorSection.this.updating = false;
                DocumentRootEditorSection.this.validate();
            }
        });
        this.serverDirCustom = toolkit.createButton(composite, Messages.serverEditorServerDirCustom, 16);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.serverDirCustom.setLayoutData((Object)data);
        this.serverDirCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DocumentRootEditorSection.this.updating || !DocumentRootEditorSection.this.serverDirCustom.getSelection()) {
                    return;
                }
                DocumentRootEditorSection.this.updating = true;
                DocumentRootEditorSection.this.execute((IUndoableOperation)new SetTestEnvironmentCommand((IPHPServerWorkingCopy)DocumentRootEditorSection.this.phpServer));
                DocumentRootEditorSection.this.updateServerDirFields();
                DocumentRootEditorSection.this.updating = false;
                DocumentRootEditorSection.this.validate();
            }
        });
        Label label = this.createLabel(toolkit, composite, Messages.serverEditorServerDir);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.serverDir = toolkit.createText(composite, null, 4);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 75;
        this.serverDir.setLayoutData((Object)data);
        this.serverDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DocumentRootEditorSection.this.updating) {
                    return;
                }
                DocumentRootEditorSection.this.updating = true;
                DocumentRootEditorSection.this.execute((IUndoableOperation)new SetDocumentRootDirectoryCommand((IPHPServerWorkingCopy)DocumentRootEditorSection.this.phpServer, DocumentRootEditorSection.this.getServerDir()));
                DocumentRootEditorSection.this.updating = false;
                DocumentRootEditorSection.this.validate();
            }
        });
        this.serverDirBrowse = toolkit.createButton(composite, Messages.editorBrowse, 8);
        this.serverDirBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(DocumentRootEditorSection.this.serverDir.getShell());
                dialog.setMessage(Messages.serverEditorBrowseDeployMessage);
                dialog.setFilterPath(DocumentRootEditorSection.this.serverDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null && !selectedDirectory.equals(DocumentRootEditorSection.this.serverDir.getText())) {
                    DocumentRootEditorSection.this.updating = true;
                    Path path = new Path(selectedDirectory);
                    if (DocumentRootEditorSection.this.workspacePath.isPrefixOf((IPath)path)) {
                        int cnt = path.matchingFirstSegments(DocumentRootEditorSection.this.workspacePath);
                        path = path.removeFirstSegments(cnt).setDevice(null);
                        selectedDirectory = path.toOSString();
                    }
                    DocumentRootEditorSection.this.execute((IUndoableOperation)new SetDocumentRootDirectoryCommand((IPHPServerWorkingCopy)DocumentRootEditorSection.this.phpServer, selectedDirectory));
                    DocumentRootEditorSection.this.updateServerDirButtons();
                    DocumentRootEditorSection.this.updateServerDirFields();
                    DocumentRootEditorSection.this.updating = false;
                    DocumentRootEditorSection.this.validate();
                }
            }
        });
        this.serverDirBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.initialize();
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
            if (this.server.getOriginal() != null) {
                this.server.getOriginal().removePublishListener(this.publishListener);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.workspacePath = root.getLocation();
        if (this.server != null) {
            this.phpServer = (PHPServer)this.server.loadAdapter(PHPServer.class, null);
            this.addChangeListeners();
        }
        this.initialize();
    }

    protected void initialize() {
        if (this.serverDir == null || this.phpServer == null) {
            return;
        }
        this.updating = true;
        IRuntime runtime = this.server.getRuntime();
        if (runtime != null) {
            this.installDirPath = runtime.getLocation();
        }
        this.allowRestrictedEditing = false;
        IPath basePath = this.phpServer.getRuntimeBaseDirectory();
        if (!this.readOnly && (basePath != null && !basePath.append("conf").toFile().exists() || this.server.getOriginal().getServerPublishState() == 1 && this.server.getOriginal().getModules().length == 0)) {
            this.allowRestrictedEditing = true;
        }
        this.updateServerDirButtons();
        this.updateServerDirFields();
        this.serverDirMetadata.setEnabled(this.allowRestrictedEditing);
        this.serverDirCustom.setEnabled(this.allowRestrictedEditing);
        this.updating = false;
        this.validate();
    }

    protected String getServerDir() {
        String dir = null;
        if (this.serverDir != null) {
            dir = this.serverDir.getText().trim();
            Path path = new Path(dir);
            if (this.tempDirPath != null && this.tempDirPath.equals((Object)path)) {
                dir = null;
            } else if (this.workspacePath.isPrefixOf((IPath)path)) {
                int cnt = path.matchingFirstSegments(this.workspacePath);
                path = path.removeFirstSegments(cnt).setDevice(null);
                dir = path.toOSString();
            }
        }
        return dir;
    }

    protected void updateServerDirButtons() {
        if (this.phpServer.getDocumentRootDirectory() == null) {
            IPath path = this.phpServer.getRuntimeBaseDirectory();
            if (path != null && path.equals((Object)this.installDirPath)) {
                this.serverDirMetadata.setSelection(false);
                this.serverDirCustom.setSelection(false);
            } else {
                this.serverDirMetadata.setSelection(true);
                this.serverDirCustom.setSelection(false);
            }
        } else {
            this.serverDirCustom.setSelection(true);
            this.serverDirMetadata.setSelection(false);
        }
    }

    protected void updateServerDirFields() {
        this.updateServerDir();
        boolean customServerDir = this.serverDirCustom.getSelection();
        this.serverDir.setEnabled(this.allowRestrictedEditing && customServerDir);
        this.serverDirBrowse.setEnabled(this.allowRestrictedEditing && customServerDir);
    }

    protected void updateServerDir() {
        IPath path = this.phpServer.getRuntimeBaseDirectory();
        if (path == null) {
            this.serverDir.setText("");
        } else if (this.workspacePath.isPrefixOf(path)) {
            int cnt = path.matchingFirstSegments(this.workspacePath);
            path = path.removeFirstSegments(cnt).setDevice(null);
            this.serverDir.setText(path.toOSString());
            if (this.tempDirPath == null && this.phpServer.getDocumentRootDirectory() == null) {
                this.tempDirPath = path;
            }
        } else {
            this.serverDir.setText(path.toOSString());
        }
    }

    public IStatus[] getSaveStatus() {
        if (this.phpServer != null) {
            String dir = this.phpServer.getDocumentRootDirectory();
            if (dir != null) {
                Path path = new Path(dir);
                if (dir.length() == 0 || this.workspacePath.equals((Object)path)) {
                    return new IStatus[]{new Status(4, "org.eclipse.php.builtin.server.ui", Messages.errorServerDirIsRoot)};
                }
                if (this.workspacePath.isPrefixOf((IPath)path) || !path.isAbsolute() && METADATADIR.equals(path.segment(0))) {
                    int cnt = path.matchingFirstSegments(this.workspacePath);
                    if (METADATADIR.equals(path.segment(cnt))) {
                        return new IStatus[]{new Status(4, "org.eclipse.php.builtin.server.ui", NLS.bind((String)Messages.errorServerDirUnderRoot, (Object)METADATADIR))};
                    }
                } else if (path.equals((Object)this.installDirPath)) {
                    return new IStatus[]{new Status(4, "org.eclipse.php.builtin.server.ui", NLS.bind((String)Messages.errorServerDirCustomNotInstall, (Object)NLS.bind((String)Messages.serverEditorServerDirInstall, (Object)"").trim()))};
                }
            } else {
                IPath path = this.phpServer.getRuntimeBaseDirectory();
                if (!path.equals((Object)this.installDirPath) && !this.serverDirMetadata.getSelection()) {
                    return new IStatus[]{new Status(4, "org.eclipse.php.builtin.server.ui", NLS.bind((String)Messages.errorServerDirCustomNotMetadata, (Object)NLS.bind((String)Messages.serverEditorServerDirMetadata, (Object)"").trim()))};
                }
            }
        }
        return super.getSaveStatus();
    }

    protected void validate() {
        if (this.phpServer != null) {
            String dir = this.phpServer.getDocumentRootDirectory();
            if (dir != null) {
                Path path = new Path(dir);
                if (dir.length() == 0 || this.workspacePath.equals((Object)path)) {
                    this.setErrorMessage(Messages.errorServerDirIsRoot);
                    return;
                }
                if (this.workspacePath.isPrefixOf((IPath)path) || !path.isAbsolute() && METADATADIR.equals(path.segment(0))) {
                    int cnt = path.matchingFirstSegments(this.workspacePath);
                    if (METADATADIR.equals(path.segment(cnt))) {
                        this.setErrorMessage(NLS.bind((String)Messages.errorServerDirUnderRoot, (Object)METADATADIR));
                        return;
                    }
                } else if (path.equals((Object)this.installDirPath)) {
                    this.setErrorMessage(NLS.bind((String)Messages.errorServerDirCustomNotInstall, (Object)NLS.bind((String)Messages.serverEditorServerDirInstall, (Object)"").trim()));
                    return;
                }
            } else {
                IPath path = this.phpServer.getRuntimeBaseDirectory();
                if (path != null && !path.equals((Object)this.installDirPath) && !this.serverDirMetadata.getSelection()) {
                    this.setErrorMessage(NLS.bind((String)Messages.errorServerDirCustomNotMetadata, (Object)NLS.bind((String)Messages.serverEditorServerDirMetadata, (Object)"").trim()));
                }
            }
        }
        this.setErrorMessage(null);
    }
}

