/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.NotFinishedStagingException;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;

public abstract class CFOperation
implements ICloudFoundryOperation {
    private final CloudFoundryServerBehaviour behaviour;

    public CFOperation(CloudFoundryServerBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public abstract String getOperationName();

    public CloudFoundryServerBehaviour getBehaviour() {
        return this.behaviour;
    }

    protected CloudFoundryApplicationModule getCloudModule(IModule module) {
        try {
            return CloudServerUtil.getCloudModule(module, this.behaviour.getCloudFoundryServer().getServer());
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
            return null;
        }
    }

    protected void logNonModuleError(CoreException e) {
        CloudFoundryException cfe;
        IStatus status = Status.OK_STATUS;
        CloudFoundryException cloudFoundryException = cfe = e.getCause() instanceof CloudFoundryException ? (CloudFoundryException)e.getCause() : null;
        if (cfe instanceof NotFinishedStagingException) {
            status = CloudFoundryPlugin.getStatus(Messages.CFOperation_WARNING_RESTART_APP, 2);
        } else if (this.shouldLogException(e)) {
            status = e.getStatus();
        }
        if (!status.isOK()) {
            CloudFoundryPlugin.log(status);
        }
    }

    protected boolean shouldLogException(CoreException e) {
        return true;
    }
}

