/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.transformer;

import org.eclipse.jpt.common.utility.transformer.InterruptibleTransformer;

public class ThreadLocalInterruptibleTransformer<I, O>
implements InterruptibleTransformer<I, O> {
    private final ThreadLocal<InterruptibleTransformer<? super I, ? extends O>> threadLocal;
    private final InterruptibleTransformer<? super I, ? extends O> defaultInterruptibleTransformer;

    public ThreadLocalInterruptibleTransformer(InterruptibleTransformer<? super I, ? extends O> defaultInterruptibleTransformer) {
        if (defaultInterruptibleTransformer == null) {
            throw new NullPointerException();
        }
        this.defaultInterruptibleTransformer = defaultInterruptibleTransformer;
        this.threadLocal = this.buildThreadLocal();
    }

    private ThreadLocal<InterruptibleTransformer<? super I, ? extends O>> buildThreadLocal() {
        return new ThreadLocal<InterruptibleTransformer<? super I, ? extends O>>();
    }

    @Override
    public O transform(I input) throws InterruptedException {
        return this.get().transform(input);
    }

    private InterruptibleTransformer<? super I, ? extends O> get() {
        InterruptibleTransformer<? super I, ? extends O> transformer = this.threadLocal.get();
        if (transformer != null) {
            return transformer;
        }
        return this.defaultInterruptibleTransformer;
    }

    public void set(InterruptibleTransformer<? super I, ? extends O> transformer) {
        this.threadLocal.set(transformer);
    }

    public String toString() {
        return this.get().toString();
    }
}

