/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinerProvider;
import org.eclipse.cdt.internal.ui.editor.LexicalSortingAction;
import org.eclipse.cdt.internal.ui.text.AbstractInformationControl;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.DecoratingCLabelProvider;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class COutlineInformationControl
extends AbstractInformationControl {
    private static final long TEXT_FLAGS = 1073742345L;
    private static final int IMAGE_FLAGS = 1;
    private ICElement fInput = null;
    private IContentProvider fOutlineContentProvider;
    private LexicalSortingAction fSortingAction;

    public COutlineInformationControl(Shell parent, int shellStyle, int treeStyle) {
        super(parent, shellStyle, treeStyle, null, false);
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int treeStyle) {
        ProblemTreeViewer treeViewer = new ProblemTreeViewer(parent, treeStyle);
        Tree tree = treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        this.fOutlineContentProvider = new CContentOutlinerProvider(treeViewer);
        treeViewer.setContentProvider(this.fOutlineContentProvider);
        this.fSortingAction = new LexicalSortingAction(treeViewer, ".isChecked");
        treeViewer.addFilter(new AbstractInformationControl.NamePatternFilter());
        long textFlags = 1073742345L;
        if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.outline.groupmembers")) {
            textFlags = textFlags | 2L | 0x100L;
        }
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingCLabelProvider(new AppearanceAwareLabelProvider(textFlags, 1), true));
        treeViewer.setAutoExpandLevel(-1);
        return treeViewer;
    }

    @Override
    protected String getId() {
        return "org.eclipse.cdt.internal.ui.text.QuickOutline";
    }

    @Override
    public void setInput(Object information) {
        if (information == null || information instanceof String) {
            this.inputChanged(null, null);
            return;
        }
        ICElement ce = (ICElement)information;
        ITranslationUnit tu = (ITranslationUnit)ce.getAncestor(60);
        if (tu != null) {
            this.fInput = tu;
        }
        this.inputChanged(this.fInput, information);
    }

    @Override
    protected void fillViewMenu(IMenuManager viewMenu) {
        super.fillViewMenu(viewMenu);
        viewMenu.add((IContributionItem)new Separator("Sorters"));
        viewMenu.add((IAction)this.fSortingAction);
    }
}

