/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocIdGenerationStrategy;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.LanguageSupport;
import org.eclipse.mylyn.wikitext.parser.markup.ContentState;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;

public class AsciiDocContentState
extends ContentState {
    public static final String ATTRIBUTE_IDPREFIX = "idprefix";
    public static final String IDPREFIX_DEFAULT_VALUE = "_";
    public static final String ATTRIBUTE_IDSEPARATOR = "idseparator";
    public static final String IDSEPARATOR_DEFAULT_VALUE = "_";
    public static final String ATTRIBUTE_IMAGESDIR = "imagesdir";
    public static final String ATTRIBUTE_LEVELOFFSET = "leveloffset";
    private String lastTitle;
    private String lastPropertiesText;
    private boolean heading1Present;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public void setLastTitle(String text) {
        this.lastTitle = text;
    }

    public String getLastTitle() {
        return this.lastTitle;
    }

    public void setLastPropertiesText(String text) {
        this.lastPropertiesText = text;
    }

    public Map<String, String> getLastProperties(List<String> positionalParameters) {
        return LanguageSupport.parseFormattingProperties(this.lastPropertiesText, positionalParameters);
    }

    public boolean isAttributeDefined(String attrName) {
        return this.attributes.containsKey(attrName);
    }

    public String getAttribute(String attrName) {
        return this.attributes.get(attrName);
    }

    public String getAttributeOrValue(String attrName, String valueIfNull) {
        String value = this.getAttribute(attrName);
        if (value != null) {
            return value;
        }
        return valueIfNull;
    }

    public void putAttribute(String attrName, String value) {
        this.attributes.put(attrName, value);
        IdGenerationStrategy generationStrategy = this.getIdGenerator().getGenerationStrategy();
        if (generationStrategy instanceof AsciiDocIdGenerationStrategy) {
            if (ATTRIBUTE_IDPREFIX.equals(attrName)) {
                ((AsciiDocIdGenerationStrategy)generationStrategy).setIdPrefix(value);
            } else if (ATTRIBUTE_IDSEPARATOR.equals(attrName)) {
                ((AsciiDocIdGenerationStrategy)generationStrategy).setIdSeparator(value);
            }
        }
    }

    public void removeAttribute(String attrName) {
        this.attributes.remove(attrName);
        IdGenerationStrategy generationStrategy = this.getIdGenerator().getGenerationStrategy();
        if (generationStrategy instanceof AsciiDocIdGenerationStrategy) {
            if (ATTRIBUTE_IDPREFIX.equals(attrName)) {
                ((AsciiDocIdGenerationStrategy)generationStrategy).setIdPrefix("_");
            } else if (ATTRIBUTE_IDSEPARATOR.equals(attrName)) {
                ((AsciiDocIdGenerationStrategy)generationStrategy).setIdSeparator("_");
            }
        }
    }

    public boolean isHeading1Present() {
        return this.heading1Present;
    }

    public void setHeading1Present(boolean heading1Present) {
        this.heading1Present = heading1Present;
    }
}

