/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class SQLTableManager<OBJECT_TYPE extends DBSEntity, CONTAINER_TYPE extends DBSObjectContainer>
extends SQLStructEditor<OBJECT_TYPE, CONTAINER_TYPE> {
    protected static final String BASE_TABLE_NAME = "NewTable";
    protected static final String BASE_VIEW_NAME = "NewView";

    @Override
    public long getMakerOptions(DBPDataSource dataSource) {
        long options = 4L;
        if (dataSource instanceof SQLDataSource && ((SQLDataSource)dataSource).getSQLDialect().supportsTableDropCascade()) {
            options |= 8L;
        }
        return options;
    }

    @Override
    protected final void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand objectChangeCommand, Map<String, Object> options) {
        throw new IllegalStateException("addObjectCreateActions should never be called in struct editor");
    }

    protected String beginCreateTableStatement(OBJECT_TYPE table, String tableName) {
        return "CREATE " + this.getCreateTableType(table) + " " + tableName + " (" + GeneralUtils.getDefaultLineSeparator();
    }

    protected boolean hasAttrDeclarations() {
        return true;
    }

    @Override
    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        DBSEntity table = (DBSEntity)command.getObject();
        SQLObjectEditor.NestedObjectCommand tableProps = command.getObjectCommands().get(table);
        if (tableProps == null) {
            log.warn("Object change command not found");
            return;
        }
        String tableName = CommonUtils.getOption(options, (String)"useFQN", (boolean)true) ? DBUtils.getObjectFullName(table, DBPEvaluationContext.DDL) : DBUtils.getQuotedIdentifier(table);
        String slComment = SQLUtils.getDialectFromObject(table).getSingleLineComments()[0];
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder createQuery = new StringBuilder(100);
        createQuery.append(this.beginCreateTableStatement(table, tableName));
        boolean hasNestedDeclarations = false;
        Collection<SQLObjectEditor.NestedObjectCommand> orderedCommands = this.getNestedOrderedCommands(command);
        for (SQLObjectEditor.NestedObjectCommand nestedCommand : orderedCommands) {
            if (nestedCommand.getObject() == table || this.excludeFromDDL(nestedCommand, orderedCommands)) continue;
            String nestedDeclaration = nestedCommand.getNestedDeclaration(monitor, table, options);
            if (!CommonUtils.isEmpty((String)nestedDeclaration)) {
                if (hasNestedDeclarations) {
                    int lastLFPos = createQuery.lastIndexOf(lineSeparator);
                    int lastCommentPos = createQuery.lastIndexOf(slComment);
                    if (lastCommentPos != -1) {
                        while (lastCommentPos > 0 && Character.isWhitespace(createQuery.charAt(lastCommentPos - 1))) {
                            --lastCommentPos;
                        }
                    }
                    if (lastCommentPos < 0 || lastCommentPos < lastLFPos) {
                        createQuery.append(",");
                    } else {
                        createQuery.insert(lastCommentPos, ",");
                    }
                    createQuery.append(lineSeparator);
                }
                if (!hasNestedDeclarations && !this.hasAttrDeclarations()) {
                    createQuery.append("(\n\t").append(nestedDeclaration);
                } else {
                    createQuery.append("\t").append(nestedDeclaration);
                }
                hasNestedDeclarations = true;
                continue;
            }
            DBEPersistAction[] nestedActions = nestedCommand.getPersistActions(monitor, options);
            if (nestedActions == null) continue;
            Collections.addAll(actions, nestedActions);
        }
        createQuery.append(lineSeparator);
        if (this.hasAttrDeclarations() || hasNestedDeclarations) {
            createQuery.append(")");
        }
        this.appendTableModifiers(monitor, table, tableProps, createQuery, false);
        actions.add(0, new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table, createQuery.toString()));
    }

    protected String getCreateTableType(OBJECT_TYPE table) {
        return DBUtils.isView(table) ? "VIEW" : "TABLE";
    }

    protected boolean excludeFromDDL(SQLObjectEditor.NestedObjectCommand command, Collection<SQLObjectEditor.NestedObjectCommand> orderedCommands) {
        return false;
    }

    @Override
    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        DBSEntity object = (DBSEntity)command.getObject();
        String tableName = CommonUtils.getOption(options, (String)"useFQN", (boolean)true) ? DBUtils.getObjectFullName(object, DBPEvaluationContext.DDL) : DBUtils.getQuotedIdentifier(object);
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + this.getCreateTableType(object) + " " + tableName + (!DBUtils.isView(object) && CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "")));
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, OBJECT_TYPE table, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
    }

    protected void setTableName(DBRProgressMonitor monitor, CONTAINER_TYPE container, OBJECT_TYPE table) throws DBException {
        if (table instanceof DBPNamedObject2) {
            ((DBPNamedObject2)table).setName(this.getNewChildName(monitor, container));
        }
    }

    protected String getNewChildName(DBRProgressMonitor monitor, CONTAINER_TYPE container) throws DBException {
        return this.getNewChildName(monitor, container, BASE_TABLE_NAME);
    }

    protected String getNewChildName(DBRProgressMonitor monitor, CONTAINER_TYPE container, String baseName) throws DBException {
        int i = 0;
        String tableName;
        DBSObject child;
        while ((child = container.getChild(monitor, tableName = DBObjectNameCaseTransformer.transformName(container.getDataSource(), i == 0 ? baseName : String.valueOf(baseName) + "_" + i))) != null) {
            ++i;
        }
        return tableName;
    }

    public DBEPersistAction[] getTableDDL(DBRProgressMonitor monitor, OBJECT_TYPE table, Map<String, Object> options) throws DBException {
        ArrayList<SQLDatabasePersistActionComment> actions = new ArrayList<SQLDatabasePersistActionComment>();
        DBERegistry editorsRegistry = table.getDataSource().getContainer().getPlatform().getEditorsRegistry();
        SQLObjectEditor<DBSEntityAttribute, DBSEntityAttribute> tcm = this.getObjectEditor(editorsRegistry, DBSEntityAttribute.class);
        SQLObjectEditor<DBSEntityConstraint, DBSEntityConstraint> pkm = this.getObjectEditor(editorsRegistry, DBSEntityConstraint.class);
        SQLObjectEditor<DBSTableForeignKey, DBSTableForeignKey> fkm = this.getObjectEditor(editorsRegistry, DBSTableForeignKey.class);
        SQLObjectEditor<DBSTableIndex, DBSTableIndex> im = this.getObjectEditor(editorsRegistry, DBSTableIndex.class);
        if (CommonUtils.getOption(options, (String)"ddl.onlyForeignKeys")) {
            if (fkm != null) {
                try {
                    for (DBSEntityAssociation foreignKey : CommonUtils.safeCollection(table.getAssociations(monitor))) {
                        DBEPersistAction[] cmdActions;
                        if (!(foreignKey instanceof DBSTableForeignKey) || DBUtils.isHiddenObject(foreignKey) || DBUtils.isInheritedObject(foreignKey) || (cmdActions = fkm.makeCreateCommand((DBSTableForeignKey)foreignKey, options).getPersistActions(monitor, options)) == null) continue;
                        Collections.addAll(actions, cmdActions);
                    }
                }
                catch (DBException e) {
                    log.debug(e);
                }
            }
            return actions.toArray(new DBEPersistAction[0]);
        }
        if (this.isIncludeDropInDDL()) {
            actions.add(new SQLDatabasePersistActionComment(table.getDataSource(), "Drop table"));
            DBEPersistAction[] dBEPersistActionArray = new SQLObjectEditor.ObjectDeleteCommand((SQLObjectEditor)this, table, ModelMessages.model_jdbc_delete_object).getPersistActions(monitor, options);
            int n = dBEPersistActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                String delimiter;
                DBEPersistAction delAction = dBEPersistActionArray[n2];
                String script = delAction.getScript();
                if (!script.endsWith(delimiter = SQLUtils.getScriptLineDelimiter(SQLUtils.getDialectFromObject(table)))) {
                    script = String.valueOf(script) + delimiter;
                }
                actions.add(new SQLDatabasePersistActionComment(table.getDataSource(), script));
                ++n2;
            }
        }
        SQLObjectEditor.ObjectCreateCommand command = this.makeCreateCommand((DBSObject)table, (Map)options);
        if (tcm != null) {
            for (DBSEntityAttribute column : CommonUtils.safeCollection(table.getAttributes(monitor))) {
                if (DBUtils.isHiddenObject(column) || DBUtils.isInheritedObject(column)) continue;
                ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(tcm.makeCreateCommand(column, options));
            }
        }
        if (pkm != null) {
            try {
                for (DBSEntityConstraint constraint : CommonUtils.safeCollection(table.getConstraints(monitor))) {
                    if (DBUtils.isHiddenObject(constraint) || DBUtils.isInheritedObject(constraint)) continue;
                    ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(pkm.makeCreateCommand(constraint, options));
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        if (fkm != null && !CommonUtils.getOption(options, (String)"ddl.skipForeignKeys")) {
            try {
                for (DBSEntityAssociation foreignKey : CommonUtils.safeCollection(table.getAssociations(monitor))) {
                    if (!(foreignKey instanceof DBSTableForeignKey) || DBUtils.isHiddenObject(foreignKey) || DBUtils.isInheritedObject(foreignKey)) continue;
                    ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(fkm.makeCreateCommand((DBSTableForeignKey)foreignKey, options));
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        if (im != null && table instanceof DBSTable) {
            try {
                for (DBSTableIndex index : CommonUtils.safeCollection(((DBSTable)table).getIndexes(monitor))) {
                    if (!this.isIncludeIndexInDDL(index)) continue;
                    ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(im.makeCreateCommand(index, options));
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        this.addExtraDDLCommands(monitor, table, options, (SQLStructEditor.StructCreateCommand)command);
        Collections.addAll(actions, ((SQLStructEditor.StructCreateCommand)command).getPersistActions(monitor, options));
        return actions.toArray(new DBEPersistAction[0]);
    }

    protected void addExtraDDLCommands(DBRProgressMonitor monitor, OBJECT_TYPE table, Map<String, Object> options, SQLStructEditor.StructCreateCommand createCommand) {
    }

    protected boolean isIncludeIndexInDDL(DBSTableIndex index) {
        return !DBUtils.isHiddenObject(index) && !DBUtils.isInheritedObject(index);
    }

    protected boolean isIncludeDropInDDL() {
        return true;
    }
}

