"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BranchView extends _react["default"].Component {
  render() {
    const classNames = (0, _classnames["default"])('github-branch', 'inline-block', {
      'github-branch-detached': this.props.currentBranch.isDetached()
    });
    return _react["default"].createElement("div", {
      className: classNames,
      ref: this.props.refRoot
    }, _react["default"].createElement("span", {
      className: "icon icon-git-branch"
    }), _react["default"].createElement("span", {
      className: "branch-label"
    }, this.props.currentBranch.getName()));
  }

}

exports["default"] = BranchView;

_defineProperty(BranchView, "propTypes", {
  currentBranch: _propTypes2.BranchPropType.isRequired,
  refRoot: _propTypes["default"].func
});

_defineProperty(BranchView, "defaultProps", {
  refRoot: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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