/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.fs.AbstractFileTypeDetector;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

public class GnomeFileTypeDetector
extends AbstractFileTypeDetector {
    private static final String GNOME_VFS_MIME_TYPE_UNKNOWN = "application/octet-stream";
    private final boolean gioAvailable = GnomeFileTypeDetector.initializeGio();
    private final boolean gnomeVfsAvailable = this.gioAvailable ? false : GnomeFileTypeDetector.initializeGnomeVfs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String implProbeContentType(Path path) throws IOException {
        if (!this.gioAvailable && !this.gnomeVfsAvailable) {
            return null;
        }
        if (!(path instanceof UnixPath)) {
            return null;
        }
        UnixPath unixPath = (UnixPath)path;
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(unixPath.getByteArrayForSysCalls());
        try {
            if (this.gioAvailable) {
                unixPath.checkRead();
                byte[] byArray = GnomeFileTypeDetector.probeUsingGio(nativeBuffer.address());
                String string = byArray == null ? null : Util.toString(byArray);
                return string;
            }
            byte[] byArray = GnomeFileTypeDetector.probeUsingGnomeVfs(nativeBuffer.address());
            if (byArray == null) {
                String string = null;
                return string;
            }
            String string = Util.toString(byArray);
            String string2 = string.equals(GNOME_VFS_MIME_TYPE_UNKNOWN) ? null : string;
            return string2;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native boolean initializeGio();

    private static synchronized native byte[] probeUsingGio(long var0);

    private static native boolean initializeGnomeVfs();

    private static native byte[] probeUsingGnomeVfs(long var0);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
    }
}

