"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var config_1 = require("../settings/config");
var ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
var SettingsType_1 = require("../settings/SettingsType");
var BackendTypeLabel;
(function (BackendTypeLabel) {
    BackendTypeLabel["DEVELOPMENT"] = "Development";
    BackendTypeLabel["EDGE"] = "Edge";
    BackendTypeLabel["INTERNAL"] = "Internal";
    BackendTypeLabel["LOCALHOST"] = "Localhost";
    BackendTypeLabel["PRODUCTION"] = "Production";
    BackendTypeLabel["RC"] = "RC";
})(BackendTypeLabel = exports.BackendTypeLabel || (exports.BackendTypeLabel = {}));
var currentEnvironment;
var URL_ADMIN = {
    PRODUCTION: config_1.config.adminUrl,
    STAGING: 'https://wire-admin-staging.zinfra.io',
};
var URL_WEBSITE = {
    PRODUCTION: config_1.config.websiteUrl,
    STAGING: 'https://wire-website-staging.zinfra.io',
};
exports.URL_WEBAPP = {
    DEVELOPMENT: 'https://wire-webapp-dev.zinfra.io',
    EDGE: 'https://wire-webapp-edge.zinfra.io',
    INTERNAL: 'https://wire-webapp-staging.wire.com/',
    LOCALHOST: 'http://localhost:8081',
    PRODUCTION: config_1.config.appBase,
    RC: 'https://wire-webapp-rc.zinfra.io',
};
exports.app = {
    ENV: config_1.config.environment,
    IS_DEVELOPMENT: config_1.config.environment !== 'production',
    IS_PRODUCTION: config_1.config.environment === 'production',
    UPDATE_URL_WIN: config_1.config.updateUrl,
};
exports.getEnvironment = function () {
    return (currentEnvironment ? currentEnvironment : restoreEnvironment()).toUpperCase();
};
var isProdEnvironment = function () {
    return [BackendTypeLabel.INTERNAL.toUpperCase(), BackendTypeLabel.PRODUCTION.toUpperCase()].includes(exports.getEnvironment());
};
var isEnvVar = function (envVar, value, caseSensitive) {
    if (caseSensitive === void 0) { caseSensitive = false; }
    var envVarContent = process.env[envVar] || '';
    if (!caseSensitive) {
        envVar = envVar.toLowerCase();
        envVarContent = envVarContent.toLowerCase();
    }
    return envVarContent.includes(value);
};
exports.platform = {
    IS_LINUX: process.platform === 'linux',
    IS_MAC_OS: process.platform === 'darwin',
    IS_WINDOWS: process.platform === 'win32',
};
exports.linuxDesktop = {
    isGnomeX11: isEnvVar('XDG_CURRENT_DESKTOP', 'gnome') && isEnvVar('XDG_SESSION_TYPE', 'x11'),
    isPopOS: isEnvVar('XDG_CURRENT_DESKTOP', 'pop'),
    isUbuntuUnity: isEnvVar('XDG_CURRENT_DESKTOP', 'Unity'),
};
var restoreEnvironment = function () {
    return ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.ENV, BackendTypeLabel.INTERNAL.toUpperCase());
};
exports.setEnvironment = function (env) {
    currentEnvironment = env ? env : restoreEnvironment();
    ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.ENV, currentEnvironment.toUpperCase());
};
exports.web = {
    getAdminUrl: function (path) {
        var baseUrl = isProdEnvironment() ? URL_ADMIN.PRODUCTION : URL_ADMIN.STAGING;
        return "" + baseUrl + (path ? path : '');
    },
    getWebappUrl: function (env) {
        if (env) {
            return env;
        }
        if (exports.app.IS_DEVELOPMENT) {
            var currentEnvironment_1 = exports.getEnvironment();
            if (currentEnvironment_1) {
                return exports.URL_WEBAPP[currentEnvironment_1.toUpperCase()];
            }
        }
        return exports.URL_WEBAPP.PRODUCTION;
    },
    getWebsiteUrl: function (path) {
        var baseUrl = isProdEnvironment() ? URL_WEBSITE.PRODUCTION : URL_WEBSITE.STAGING;
        return "" + baseUrl + (path ? path : '');
    },
};
//# sourceMappingURL=EnvironmentUtil.js.map