"use strict";
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
Object.defineProperty(exports, "__esModule", { value: true });
var autoLaunch = require("auto-launch");
var electron_1 = require("electron");
var eventType_1 = require("../lib/eventType");
var webViewFocus_1 = require("../lib/webViewFocus");
var locale = require("../locale/locale");
var lifecycle = require("../runtime/lifecycle");
var config_1 = require("../settings/config");
var ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
var SettingsType_1 = require("../settings/SettingsType");
var WindowManager_1 = require("../window/WindowManager");
var EnvironmentUtil = require("../runtime/EnvironmentUtil");
var launchCmd = process.env.APPIMAGE || process.execPath;
var menu;
var launcher = new autoLaunch({
    isHidden: true,
    name: config_1.config.name,
    path: launchCmd,
});
var separatorTemplate = {
    type: 'separator',
};
var createLanguageTemplate = function (languageCode) {
    return {
        click: function () { return changeLocale(languageCode); },
        label: locale.SUPPORTED_LANGUAGES[languageCode],
        type: 'radio',
    };
};
var createLanguageSubmenu = function () {
    return Object.keys(locale.SUPPORTED_LANGUAGES).map(function (supportedLanguage) {
        return createLanguageTemplate(supportedLanguage);
    });
};
var localeTemplate = {
    label: locale.getText('menuLocale'),
    submenu: createLanguageSubmenu(),
};
var aboutTemplate = {
    click: function () { return electron_1.ipcMain.emit(eventType_1.EVENT_TYPE.ABOUT.SHOW); },
    label: locale.getText('menuAbout'),
};
var signOutTemplate = {
    click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.ACTION.SIGN_OUT); },
    label: locale.getText('menuSignOut'),
};
var conversationTemplate = {
    label: "&" + locale.getText('menuConversation'),
    submenu: [
        {
            accelerator: 'CmdOrCtrl+N',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.START); },
            label: locale.getText('menuStart'),
        },
        separatorTemplate,
        {
            accelerator: 'CmdOrCtrl+K',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.PING); },
            label: locale.getText('menuPing'),
        },
        {
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.CALL); },
            label: locale.getText('menuCall'),
        },
        {
            click: function () {
                return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.VIDEO_CALL);
            },
            label: locale.getText('menuVideoCall'),
        },
        separatorTemplate,
        {
            accelerator: 'CmdOrCtrl+I',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.PEOPLE); },
            label: locale.getText('menuPeople'),
        },
        {
            accelerator: 'Shift+CmdOrCtrl+K',
            click: function () {
                return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.ADD_PEOPLE);
            },
            label: locale.getText('menuAddPeople'),
        },
        separatorTemplate,
        {
            accelerator: 'CmdOrCtrl+D',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.ARCHIVE); },
            label: locale.getText('menuArchive'),
        },
        {
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.DELETE); },
            label: locale.getText('menuDelete'),
        },
    ],
};
var showWireTemplate = {
    accelerator: 'CmdOrCtrl+0',
    click: function () { return WindowManager_1.WindowManager.getPrimaryWindow().show(); },
    label: "&" + config_1.config.name,
};
var toggleMenuTemplate = {
    checked: ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.SHOW_MENU_BAR, true),
    click: function () {
        var mainBrowserWindow = WindowManager_1.WindowManager.getPrimaryWindow();
        var showMenu = mainBrowserWindow.isMenuBarAutoHide();
        mainBrowserWindow.setAutoHideMenuBar(!showMenu);
        if (!showMenu) {
            mainBrowserWindow.setMenuBarVisibility(showMenu);
        }
        ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.SHOW_MENU_BAR, showMenu);
    },
    label: locale.getText('menuShowHide'),
    type: 'checkbox',
};
var toggleFullScreenTemplate = {
    accelerator: EnvironmentUtil.platform.IS_MAC_OS ? 'Alt+Command+F' : 'F11',
    click: function () {
        var mainBrowserWindow = WindowManager_1.WindowManager.getPrimaryWindow();
        mainBrowserWindow.setFullScreen(!mainBrowserWindow.isFullScreen());
    },
    label: locale.getText('menuFullScreen'),
    type: 'checkbox',
};
var toggleAutoLaunchTemplate = {
    checked: ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.AUTO_LAUNCH, false),
    click: function () {
        var shouldAutoLaunch = !ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.AUTO_LAUNCH);
        ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.AUTO_LAUNCH, shouldAutoLaunch);
        return shouldAutoLaunch ? launcher.enable() : launcher.disable();
    },
    label: locale.getText('menuStartup'),
    type: 'checkbox',
};
var editTemplate = {
    label: "&" + locale.getText('menuEdit'),
    submenu: [
        {
            accelerator: 'CmdOrCtrl+Z',
            click: function (menuItem, focusedWin) {
                var focusedWebContents = webViewFocus_1.WebViewFocus.getFocusedWebContents();
                if (focusedWebContents) {
                    focusedWebContents.undo();
                }
            },
            label: locale.getText('menuUndo'),
        },
        {
            accelerator: 'Shift+CmdOrCtrl+Z',
            click: function (menuItem, focusedWin) {
                var focusedWebContents = webViewFocus_1.WebViewFocus.getFocusedWebContents();
                if (focusedWebContents) {
                    focusedWebContents.redo();
                }
            },
            label: locale.getText('menuRedo'),
        },
        separatorTemplate,
        {
            label: locale.getText('menuCut'),
            role: 'cut',
        },
        {
            label: locale.getText('menuCopy'),
            role: 'copy',
        },
        {
            label: locale.getText('menuPaste'),
            role: 'paste',
        },
        separatorTemplate,
        {
            label: locale.getText('menuSelectAll'),
            role: 'selectall',
        },
    ],
};
var windowTemplate = {
    label: "&" + locale.getText('menuWindow'),
    role: 'window',
    submenu: [
        {
            label: locale.getText('menuMinimize'),
            role: 'minimize',
        },
        {
            label: locale.getText('menuClose'),
            role: 'close',
        },
        separatorTemplate,
        {
            accelerator: EnvironmentUtil.platform.IS_MAC_OS ? 'Alt+Cmd+Up' : 'Alt+Shift+Up',
            click: function () {
                return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.SHOW_NEXT);
            },
            label: locale.getText('menuNextConversation'),
        },
        {
            accelerator: EnvironmentUtil.platform.IS_MAC_OS ? 'Alt+Cmd+Down' : 'Alt+Shift+Down',
            click: function () {
                return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.SHOW_PREVIOUS);
            },
            label: locale.getText('menuPreviousConversation'),
        },
    ],
};
var helpTemplate = {
    label: "&" + locale.getText('menuHelp'),
    role: 'help',
    submenu: [
        {
            click: function () { return electron_1.shell.openExternal(config_1.config.legalUrl); },
            label: locale.getText('menuLegal'),
        },
        {
            click: function () { return electron_1.shell.openExternal(config_1.config.privacyUrl); },
            label: locale.getText('menuPrivacy'),
        },
        {
            click: function () { return electron_1.shell.openExternal(config_1.config.licensesUrl); },
            label: locale.getText('menuLicense'),
        },
        {
            click: function () { return electron_1.shell.openExternal(config_1.config.supportUrl); },
            label: locale.getText('menuSupport'),
        },
        {
            click: function () { return electron_1.shell.openExternal(EnvironmentUtil.web.getWebsiteUrl()); },
            label: locale.getText('menuAppURL'),
        },
    ],
};
var darwinTemplate = {
    label: "&" + config_1.config.name,
    submenu: [
        aboutTemplate,
        separatorTemplate,
        {
            accelerator: 'Command+,',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.PREFERENCES.SHOW); },
            label: locale.getText('menuPreferences'),
        },
        separatorTemplate,
        localeTemplate,
        {
            label: locale.getText('menuServices'),
            role: 'services',
            submenu: [],
        },
        separatorTemplate,
        {
            label: locale.getText('menuHideApp'),
            role: 'hide',
        },
        {
            label: locale.getText('menuHideOthers'),
            role: 'hideothers',
        },
        {
            label: locale.getText('menuShowAll'),
            role: 'unhide',
        },
        separatorTemplate,
        signOutTemplate,
        {
            accelerator: 'Command+Q',
            click: function () { return lifecycle.quit(); },
            label: locale.getText('menuQuit'),
        },
    ],
};
var win32Template = {
    label: "&" + config_1.config.name,
    submenu: [
        {
            accelerator: 'Ctrl+,',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.PREFERENCES.SHOW); },
            label: locale.getText('menuSettings'),
        },
        localeTemplate,
        toggleAutoLaunchTemplate,
        separatorTemplate,
        signOutTemplate,
        {
            accelerator: 'Alt+F4',
            click: function () { return lifecycle.quit(); },
            label: locale.getText('menuQuit'),
        },
    ],
};
var linuxTemplate = {
    label: "&" + config_1.config.name,
    submenu: [
        toggleAutoLaunchTemplate,
        separatorTemplate,
        localeTemplate,
        separatorTemplate,
        signOutTemplate,
        {
            accelerator: 'Ctrl+Q',
            click: function () { return lifecycle.quit(); },
            label: locale.getText('menuQuit'),
        },
    ],
};
var menuTemplate = [conversationTemplate, editTemplate, windowTemplate, helpTemplate];
var processMenu = function (template, language) {
    var e_1, _a;
    try {
        for (var template_1 = __values(template), template_1_1 = template_1.next(); !template_1_1.done; template_1_1 = template_1.next()) {
            var item = template_1_1.value;
            if (item.submenu) {
                processMenu(item.submenu, language);
            }
            if (locale.SUPPORTED_LANGUAGES[language] === item.label) {
                item.checked = true;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (template_1_1 && !template_1_1.done && (_a = template_1.return)) _a.call(template_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
};
var changeLocale = function (language) {
    locale.setLocale(language);
    electron_1.dialog.showMessageBox({
        buttons: [
            locale.getText('restartLater'),
            EnvironmentUtil.platform.IS_MAC_OS ? locale.getText('menuQuit') : locale.getText('restartNow'),
        ],
        message: locale.getText('restartLocale'),
        title: locale.getText('restartNeeded'),
        type: 'info',
    }, function (response) {
        if (response === 1) {
            return EnvironmentUtil.platform.IS_MAC_OS ? lifecycle.quit() : lifecycle.relaunch();
        }
    });
};
exports.createMenu = function (isFullScreen) {
    if (!windowTemplate.submenu) {
        windowTemplate.submenu = [];
    }
    if (!editTemplate.submenu) {
        editTemplate.submenu = [];
    }
    if (!helpTemplate.submenu) {
        helpTemplate.submenu = [];
    }
    if (EnvironmentUtil.platform.IS_MAC_OS) {
        menuTemplate.unshift(darwinTemplate);
        if (Array.isArray(windowTemplate.submenu)) {
            windowTemplate.submenu.push(separatorTemplate, showWireTemplate, separatorTemplate, toggleFullScreenTemplate);
        }
        toggleFullScreenTemplate.checked = isFullScreen;
    }
    if (EnvironmentUtil.platform.IS_WINDOWS) {
        menuTemplate.unshift(win32Template);
        windowTemplate.label = locale.getText('menuView');
        if (Array.isArray(windowTemplate.submenu)) {
            windowTemplate.submenu.unshift(toggleMenuTemplate, separatorTemplate);
        }
    }
    if (EnvironmentUtil.platform.IS_LINUX) {
        menuTemplate.unshift(linuxTemplate);
        if (Array.isArray(editTemplate.submenu)) {
            editTemplate.submenu.push(separatorTemplate, {
                accelerator: 'Ctrl+,',
                click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.PREFERENCES.SHOW); },
                label: locale.getText('menuPreferences'),
            });
        }
        if (Array.isArray(windowTemplate.submenu)) {
            windowTemplate.submenu.push(separatorTemplate, toggleMenuTemplate, separatorTemplate, toggleFullScreenTemplate);
        }
        toggleFullScreenTemplate.checked = isFullScreen;
    }
    if (!EnvironmentUtil.platform.IS_MAC_OS) {
        if (Array.isArray(helpTemplate.submenu)) {
            helpTemplate.submenu.push(separatorTemplate, aboutTemplate);
        }
    }
    processMenu(menuTemplate, locale.getCurrent());
    menu = electron_1.Menu.buildFromTemplate(menuTemplate);
    return menu;
};
exports.registerShortcuts = function () {
    var e_2, _a;
    electron_1.globalShortcut.register('CmdOrCtrl+Alt+M', function () {
        return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.TOGGLE_MUTE);
    });
    var switchAccountShortcut = ['CmdOrCtrl', 'Super'];
    var accountLimit = config_1.config.maximumAccounts;
    try {
        for (var switchAccountShortcut_1 = __values(switchAccountShortcut), switchAccountShortcut_1_1 = switchAccountShortcut_1.next(); !switchAccountShortcut_1_1.done; switchAccountShortcut_1_1 = switchAccountShortcut_1.next()) {
            var shortcut = switchAccountShortcut_1_1.value;
            var _loop_1 = function (accountId) {
                electron_1.globalShortcut.register(shortcut + "+" + (accountId + 1), function () {
                    return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.ACTION.SWITCH_ACCOUNT, accountId);
                });
            };
            for (var accountId = 0; accountId < accountLimit; accountId++) {
                _loop_1(accountId);
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (switchAccountShortcut_1_1 && !switchAccountShortcut_1_1.done && (_a = switchAccountShortcut_1.return)) _a.call(switchAccountShortcut_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
};
exports.toggleMenuBar = function () {
    var mainBrowserWindow = WindowManager_1.WindowManager.getPrimaryWindow();
    var isVisible = mainBrowserWindow.isMenuBarVisible();
    var autoHide = mainBrowserWindow.isMenuBarAutoHide();
    if (autoHide) {
        mainBrowserWindow.setMenuBarVisibility(!isVisible);
    }
};
exports.unregisterShortcuts = function () {
    electron_1.globalShortcut.unregisterAll();
};
//# sourceMappingURL=system.js.map