/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_6_0;

import java.util.List;
import org.virtualbox_6_0.BitmapFormat;
import org.virtualbox_6_0.Helper;
import org.virtualbox_6_0.IFramebufferOverlay;
import org.virtualbox_6_0.IUnknown;
import org.virtualbox_6_0.ObjectRefManager;
import org.virtualbox_6_0.VBoxException;
import org.virtualbox_6_0.jaxws.FramebufferCapabilities;
import org.virtualbox_6_0.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_6_0.jaxws.RuntimeFaultMsg;
import org.virtualbox_6_0.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IFramebuffer
extends IUnknown {
    public IFramebuffer(String string, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        super(string, objectRefManager, vboxPortType);
    }

    public Long getWidth() {
        try {
            Long l = this.port.iFramebufferGetWidth(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getHeight() {
        try {
            Long l = this.port.iFramebufferGetHeight(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getBitsPerPixel() {
        try {
            Long l = this.port.iFramebufferGetBitsPerPixel(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getBytesPerLine() {
        try {
            Long l = this.port.iFramebufferGetBytesPerLine(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public BitmapFormat getPixelFormat() {
        try {
            org.virtualbox_6_0.jaxws.BitmapFormat bitmapFormat = this.port.iFramebufferGetPixelFormat(this.obj);
            return BitmapFormat.fromValue(bitmapFormat.value());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getHeightReduction() {
        try {
            Long l = this.port.iFramebufferGetHeightReduction(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IFramebufferOverlay getOverlay() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iFramebufferGetOverlay(this.obj);
            IFramebufferOverlay iFramebufferOverlay = string.length() > 0 ? new IFramebufferOverlay(string, this.getObjMgr(), this.port) : null;
            return iFramebufferOverlay;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<org.virtualbox_6_0.FramebufferCapabilities> getCapabilities() {
        try {
            List<FramebufferCapabilities> list = this.port.iFramebufferGetCapabilities(this.obj);
            return Helper.convertEnums(FramebufferCapabilities.class, org.virtualbox_6_0.FramebufferCapabilities.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public static IFramebuffer queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IFramebuffer(iUnknown.getWrapped(), iUnknown.getObjMgr(), iUnknown.getRemoteWSPort());
    }

    public void notifyUpdate(Long l, Long l2, Long l3, Long l4) {
        try {
            this.port.iFramebufferNotifyUpdate(this.obj, l, l2, l3, l4);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void notifyUpdateImage(Long l, Long l2, Long l3, Long l4, byte[] byArray) {
        try {
            this.port.iFramebufferNotifyUpdateImage(this.obj, l, l2, l3, l4, Helper.encodeBase64(byArray));
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void notifyChange(Long l, Long l2, Long l3, Long l4, Long l5) {
        try {
            this.port.iFramebufferNotifyChange(this.obj, l, l2, l3, l4, l5);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Boolean videoModeSupported(Long l, Long l2, Long l3) {
        try {
            Boolean bl = this.port.iFramebufferVideoModeSupported(this.obj, l, l2, l3);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void notify3DEvent(Long l, byte[] byArray) {
        try {
            this.port.iFramebufferNotify3DEvent(this.obj, l, Helper.encodeBase64(byArray));
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }
}

