/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.rdr.InStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public abstract class OutStream {
    protected byte[] b;
    protected int ptr;
    protected int end;

    public final int check(int n, int n2) {
        if (this.ptr + n * n2 > this.end) {
            if (this.ptr + n > this.end) {
                return this.overrun(n, n2);
            }
            n2 = (this.end - this.ptr) / n;
        }
        return n2;
    }

    public final void check(int n) {
        if (this.ptr + n > this.end) {
            this.overrun(n, 1);
        }
    }

    public final void writeU8(int n) {
        this.check(1);
        this.b[this.ptr++] = (byte)n;
    }

    public final void writeU16(int n) {
        this.check(2);
        this.b[this.ptr++] = (byte)(n >> 8);
        this.b[this.ptr++] = (byte)n;
    }

    public final void writeU32(int n) {
        this.check(4);
        this.b[this.ptr++] = (byte)(n >> 24);
        this.b[this.ptr++] = (byte)(n >> 16);
        this.b[this.ptr++] = (byte)(n >> 8);
        this.b[this.ptr++] = (byte)n;
    }

    public final void writeS8(int n) {
        this.writeU8(n);
    }

    public final void writeS16(int n) {
        this.writeU16(n);
    }

    public final void writeS32(int n) {
        this.writeU32(n);
    }

    public final void writeCompactLength(int n) {
        byte by = (byte)(n & 0x7F);
        if (n <= 127) {
            this.writeU8(by);
        } else {
            this.writeU8(by | 0x80);
            by = (byte)(n >> 7 & 0x7F);
            if (n <= 16383) {
                this.writeU8(by);
            } else {
                this.writeU8(by | 0x80);
                this.writeU8(n >> 14 & 0xFF);
            }
        }
    }

    public final void writeString(String string) {
        int n = string.length();
        this.writeU32(n);
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.writeBytes(byArray, 0, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public final void pad(int n) {
        while (n-- > 0) {
            this.writeU8(0);
        }
    }

    public final void skip(int n) {
        while (n > 0) {
            int n2 = this.check(1, n);
            this.ptr += n2;
            n -= n2;
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            int n4 = this.check(1, n3 - n);
            System.arraycopy(byArray, n, this.b, this.ptr, n4);
            this.ptr += n4;
            n += n4;
        }
    }

    public void writeBytes(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = byteBuffer;
        int n2 = byteBuffer2.position() + n;
        while (byteBuffer2.position() < n2) {
            int n3 = this.check(1, n2 - byteBuffer2.position());
            byteBuffer2.get(this.b, this.ptr, n3);
            this.ptr += n3;
        }
    }

    public void copyBytes(InStream inStream, int n) {
        while (n > 0) {
            int n2 = this.check(1, n);
            inStream.readBytes(ByteBuffer.wrap(this.b, this.ptr, n2), n2);
            this.ptr += n2;
            n -= n2;
        }
    }

    public final void writeOpaque8(int n) {
        this.writeU8(n);
    }

    public final void writeOpaque16(int n) {
        this.writeU16(n);
    }

    public final void writeOpaque32(int n) {
        this.writeU32(n);
    }

    public final void writeOpaque24A(int n) {
        this.check(3);
        this.b[this.ptr++] = (byte)(n >> 24);
        this.b[this.ptr++] = (byte)(n >> 16);
        this.b[this.ptr++] = (byte)(n >> 8);
    }

    public final void writeOpaque24B(int n) {
        this.check(3);
        this.b[this.ptr++] = (byte)(n >> 16);
        this.b[this.ptr++] = (byte)(n >> 8);
        this.b[this.ptr++] = (byte)n;
    }

    public abstract int length();

    public void flush() {
    }

    public final byte[] getbuf() {
        return this.b;
    }

    public final int getptr() {
        return this.ptr;
    }

    public final int getend() {
        return this.end;
    }

    public final void setptr(int n) {
        this.ptr = n;
    }

    protected abstract int overrun(int var1, int var2);

    protected OutStream() {
    }
}

