#pragma once

#include <ATen/ATen.h>

// @generated by aten/src/ATen/gen.py

namespace at {

struct CAFFE2_API TypeDefault {
  static Tensor _cast_Byte(const Tensor & self, bool non_blocking);
  static Tensor _cast_Char(const Tensor & self, bool non_blocking);
  static Tensor _cast_Double(const Tensor & self, bool non_blocking);
  static Tensor _cast_Float(const Tensor & self, bool non_blocking);
  static Tensor _cast_Int(const Tensor & self, bool non_blocking);
  static Tensor _cast_Long(const Tensor & self, bool non_blocking);
  static Tensor _cast_Short(const Tensor & self, bool non_blocking);
  static Tensor _cast_Half(const Tensor & self, bool non_blocking);
  static void backward(const Tensor & self, const Tensor & gradient, bool keep_graph, bool create_graph);
  static void set_data(const Tensor & self, const Tensor & new_data);
  #ifdef BUILD_NAMEDTENSOR
  static Tensor & set_names_(Tensor & self, c10::optional<DimnameList> names);
  #endif
  static int64_t _debug_has_internal_overlap(const Tensor & self);
  static std::tuple<Tensor,Tensor> _sobol_engine_draw(const Tensor & quasi, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated, c10::optional<ScalarType> dtype);
  static Tensor & _sobol_engine_ff_(Tensor & self, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated);
  static Tensor & _sobol_engine_scramble_(Tensor & self, const Tensor & ltm, int64_t dimension);
  static Tensor & _sobol_engine_initialize_state_(Tensor & self, int64_t dimension);
  static Tensor _reshape_from_tensor(const Tensor & self, const Tensor & shape);
  static Tensor _shape_as_tensor(const Tensor & self);
  static Tensor dropout(const Tensor & input, double p, bool train);
  static Tensor & dropout_(Tensor & self, double p, bool train);
  static Tensor feature_dropout(const Tensor & input, double p, bool train);
  static Tensor & feature_dropout_(Tensor & self, double p, bool train);
  static Tensor alpha_dropout(const Tensor & input, double p, bool train);
  static Tensor & alpha_dropout_(Tensor & self, double p, bool train);
  static Tensor feature_alpha_dropout(const Tensor & input, double p, bool train);
  static Tensor & feature_alpha_dropout_(Tensor & self, double p, bool train);
  static Tensor abs(const Tensor & self);
  static Tensor acos(const Tensor & self);
  static Tensor avg_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad);
  static Tensor adaptive_avg_pool1d(const Tensor & self, IntArrayRef output_size);
  static std::tuple<Tensor,Tensor> adaptive_max_pool1d(const Tensor & self, IntArrayRef output_size);
  static Tensor add(const Tensor & self, Scalar other, Scalar alpha);
  static Tensor & add_(Tensor & self, Scalar other, Scalar alpha);
  static Tensor addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha);
  static Tensor & addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha);
  static Tensor & addr_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha);
  static Tensor affine_grid_generator(const Tensor & theta, IntArrayRef size);
  static Tensor affine_grid_generator_backward(const Tensor & grad, IntArrayRef size);
  static Tensor all(const Tensor & self, int64_t dim, bool keepdim);
  static Tensor & all_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim);
  static bool allclose(const Tensor & self, const Tensor & other, double rtol, double atol, bool equal_nan);
  static Tensor any(const Tensor & self, int64_t dim, bool keepdim);
  static Tensor & any_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim);
  static Tensor arange(Scalar end, const TensorOptions & options);
  static Tensor arange(Scalar start, Scalar end, const TensorOptions & options);
  static Tensor arange(Scalar start, Scalar end, Scalar step, const TensorOptions & options);
  static Tensor & arange_out(Tensor & out, Scalar end);
  static Tensor _dim_arange(const Tensor & like, int64_t dim);
  static Tensor argmax(const Tensor & self, c10::optional<int64_t> dim, bool keepdim);
  static Tensor argmin(const Tensor & self, c10::optional<int64_t> dim, bool keepdim);
  static Tensor & as_strided_(Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset);
  static Tensor asin(const Tensor & self);
  static Tensor atan(const Tensor & self);
  static Tensor & _baddbmm_mkl_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha);
  static Tensor bartlett_window(int64_t window_length, const TensorOptions & options);
  static Tensor bartlett_window(int64_t window_length, bool periodic, const TensorOptions & options);
  static Tensor batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled);
  static std::tuple<Tensor,Tensor,Tensor,int64_t> _batch_norm_impl_index(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled);
  static std::tuple<Tensor,Tensor,Tensor> _batch_norm_impl_index_backward(int64_t impl_index, const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var_transform, bool train, double eps, std::array<bool,3> output_mask);
  static Tensor bernoulli(const Tensor & self, Generator * generator);
  static Tensor & bernoulli_out(Tensor & out, const Tensor & self, Generator * generator);
  static Tensor bernoulli(const Tensor & self, double p, Generator * generator);
  static Tensor bilinear(const Tensor & input1, const Tensor & input2, const Tensor & weight, const Tensor & bias);
  static Tensor binary_cross_entropy_with_logits(const Tensor & self, const Tensor & target, const Tensor & weight, const Tensor & pos_weight, int64_t reduction);
  static Tensor binary_cross_entropy_with_logits_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, const Tensor & pos_weight, int64_t reduction);
  static Tensor bitwise_not(const Tensor & self);
  static Tensor & bitwise_not_(Tensor & self);
  static Tensor blackman_window(int64_t window_length, const TensorOptions & options);
  static Tensor blackman_window(int64_t window_length, bool periodic, const TensorOptions & options);
  static std::vector<Tensor> broadcast_tensors(TensorList tensors);
  static Tensor cat(TensorList tensors, int64_t dim);
  static Tensor & cat_out(Tensor & out, TensorList tensors, int64_t dim);
  static Tensor ceil(const Tensor & self);
  static Tensor chain_matmul(TensorList matrices);
  static std::vector<Tensor> chunk(const Tensor & self, int64_t chunks, int64_t dim);
  static Tensor clamp(const Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max);
  static Tensor clamp_max(const Tensor & self, Scalar max);
  static Tensor clamp_min(const Tensor & self, Scalar min);
  static bool cudnn_is_acceptable(const Tensor & self);
  static Tensor constant_pad_nd(const Tensor & self, IntArrayRef pad, Scalar value);
  static Tensor contiguous(const Tensor & self, MemoryFormat memory_format);
  static Tensor convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups);
  static Tensor _convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled);
  static Tensor _convolution_nogroup(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding);
  static std::tuple<Tensor,Tensor,Tensor> _convolution_double_backward(const Tensor & ggI, const Tensor & ggW, const Tensor & ggb, const Tensor & gO, const Tensor & weight, const Tensor & self, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, std::array<bool,3> output_mask);
  static Tensor conv1d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups);
  static Tensor conv2d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups);
  static Tensor conv3d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups);
  static Tensor conv_tbc(const Tensor & self, const Tensor & weight, const Tensor & bias, int64_t pad);
  static std::tuple<Tensor,Tensor,Tensor> conv_tbc_backward(const Tensor & self, const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t pad);
  static Tensor conv_transpose1d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation);
  static Tensor conv_transpose2d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation);
  static Tensor conv_transpose3d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation);
  static Tensor & copy_(Tensor & self, const Tensor & src, bool non_blocking);
  static Tensor cos(const Tensor & self);
  static Tensor cosh(const Tensor & self);
  static Tensor cosine_embedding_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin, int64_t reduction);
  static Tensor cumsum(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  static Tensor & cumsum_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  static Tensor cumprod(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  static Tensor & cumprod_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  static Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, int64_t reduction, bool zero_infinity);
  static Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, const Tensor & input_lengths, const Tensor & target_lengths, int64_t blank, int64_t reduction, bool zero_infinity);
  static Tensor det(const Tensor & self);
  static Tensor diag_embed(const Tensor & self, int64_t offset, int64_t dim1, int64_t dim2);
  static Tensor diagflat(const Tensor & self, int64_t offset);
  static Tensor diagonal(const Tensor & self, int64_t offset, int64_t dim1, int64_t dim2);
  static Tensor & fill_diagonal_(Tensor & self, Scalar fill_value, bool wrap);
  static Tensor div(const Tensor & self, const Tensor & other);
  static Tensor & div_(Tensor & self, const Tensor & other);
  static Tensor & div_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor div(const Tensor & self, Scalar other);
  static Tensor & div_(Tensor & self, Scalar other);
  static Tensor & dot_out(Tensor & out, const Tensor & self, const Tensor & tensor);
  static Tensor einsum(std::string equation, TensorList tensors);
  static Tensor embedding(const Tensor & weight, const Tensor & indices, int64_t padding_idx, bool scale_grad_by_freq, bool sparse);
  static Tensor embedding_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq, bool sparse);
  static Tensor embedding_sparse_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
  static std::tuple<Tensor,Tensor,Tensor,Tensor> embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights);
  static Tensor _embedding_bag_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights);
  static Tensor _embedding_bag_sparse_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights);
  #ifdef BUILD_NAMEDTENSOR
  static Tensor empty(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options);
  #endif
  static Tensor & empty_out(Tensor & out, IntArrayRef size, c10::optional<MemoryFormat> memory_format);
  static Tensor empty_like(const Tensor & self);
  static Tensor empty_like(const Tensor & self, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  static Tensor erf(const Tensor & self);
  static Tensor erfc(const Tensor & self);
  static Tensor exp(const Tensor & self);
  static Tensor expm1(const Tensor & self);
  static Tensor expand(const Tensor & self, IntArrayRef size, bool implicit);
  static Tensor expand_as(const Tensor & self, const Tensor & other);
  static Tensor eye(int64_t n, const TensorOptions & options);
  static Tensor eye(int64_t n, int64_t m, const TensorOptions & options);
  static Tensor flatten(const Tensor & self, int64_t start_dim, int64_t end_dim);
  static Tensor & fill_(Tensor & self, Scalar value);
  static Tensor & fill_(Tensor & self, const Tensor & value);
  static Tensor floor(const Tensor & self);
  static Tensor frac(const Tensor & self);
  static Tensor full(IntArrayRef size, Scalar fill_value, const TensorOptions & options);
  static Tensor & full_out(Tensor & out, IntArrayRef size, Scalar fill_value);
  static Tensor full_like(const Tensor & self, Scalar fill_value);
  static Tensor full_like(const Tensor & self, Scalar fill_value, const TensorOptions & options);
  static Tensor grid_sampler(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode);
  static Tensor hann_window(int64_t window_length, const TensorOptions & options);
  static Tensor hann_window(int64_t window_length, bool periodic, const TensorOptions & options);
  static Tensor hamming_window(int64_t window_length, const TensorOptions & options);
  static Tensor hamming_window(int64_t window_length, bool periodic, const TensorOptions & options);
  static Tensor hamming_window(int64_t window_length, bool periodic, double alpha, const TensorOptions & options);
  static Tensor hamming_window(int64_t window_length, bool periodic, double alpha, double beta, const TensorOptions & options);
  static Tensor hinge_embedding_loss(const Tensor & self, const Tensor & target, double margin, int64_t reduction);
  static Tensor group_norm(const Tensor & input, int64_t num_groups, const Tensor & weight, const Tensor & bias, double eps, bool cudnn_enabled);
  static Tensor fft(const Tensor & self, int64_t signal_ndim, bool normalized);
  static Tensor ifft(const Tensor & self, int64_t signal_ndim, bool normalized);
  static Tensor rfft(const Tensor & self, int64_t signal_ndim, bool normalized, bool onesided);
  static Tensor irfft(const Tensor & self, int64_t signal_ndim, bool normalized, bool onesided, IntArrayRef signal_sizes);
  static int64_t _cufft_get_plan_cache_size(int64_t device_index);
  static int64_t _cufft_get_plan_cache_max_size(int64_t device_index);
  static void _cufft_set_plan_cache_max_size(int64_t device_index, int64_t max_size);
  static void _cufft_clear_plan_cache(int64_t device_index);
  static Tensor index(const Tensor & self, TensorList indices);
  static Tensor & index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
  static Tensor index_copy(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
  static Tensor & index_put_(Tensor & self, TensorList indices, const Tensor & values, bool accumulate);
  static Tensor index_put(const Tensor & self, TensorList indices, const Tensor & values, bool accumulate);
  static Tensor & _index_put_impl_(Tensor & self, TensorList indices, const Tensor & values, bool accumulate, bool unsafe);
  static Tensor instance_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool use_input_stats, double momentum, double eps, bool cudnn_enabled);
  static Tensor inverse(const Tensor & self);
  static Tensor & inverse_out(Tensor & out, const Tensor & self);
  static Tensor isclose(const Tensor & self, const Tensor & other, double rtol, double atol, bool equal_nan);
  static Tensor isnan(const Tensor & self);
  static bool is_distributed(const Tensor & self);
  static bool is_floating_point(const Tensor & self);
  static bool is_complex(const Tensor & self);
  static bool is_nonzero(const Tensor & self);
  static bool is_same_size(const Tensor & self, const Tensor & other);
  static bool is_signed(const Tensor & self);
  static Tensor kl_div(const Tensor & self, const Tensor & target, int64_t reduction);
  static std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, int64_t dim, bool keepdim);
  static Tensor layer_norm(const Tensor & input, IntArrayRef normalized_shape, const Tensor & weight, const Tensor & bias, double eps, bool cudnn_enable);
  static Tensor linear(const Tensor & input, const Tensor & weight, const Tensor & bias);
  static Tensor fbgemm_linear_int8_weight(const Tensor & input, const Tensor & weight, const Tensor & packed, const Tensor & col_offsets, Scalar weight_scale, Scalar weight_zero_point, const Tensor & bias);
  static std::tuple<Tensor,Tensor,double,int64_t> fbgemm_linear_quantize_weight(const Tensor & input);
  static Tensor fbgemm_pack_gemm_matrix_fp16(const Tensor & input);
  static Tensor fbgemm_linear_fp16_weight(const Tensor & input, const Tensor & packed_weight, const Tensor & bias);
  static Tensor fbgemm_pack_quantized_matrix(const Tensor & input, int64_t K, int64_t N);
  static bool fbgemm_is_cpu_supported();
  static Tensor linspace(Scalar start, Scalar end, int64_t steps, const TensorOptions & options);
  static Tensor log(const Tensor & self);
  static Tensor log10(const Tensor & self);
  static Tensor log1p(const Tensor & self);
  static Tensor log2(const Tensor & self);
  static Tensor logdet(const Tensor & self);
  static Tensor logspace(Scalar start, Scalar end, int64_t steps, double base, const TensorOptions & options);
  static Tensor log_softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  static Tensor logsumexp(const Tensor & self, IntArrayRef dim, bool keepdim);
  static Tensor & logsumexp_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim);
  static Tensor margin_ranking_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin, int64_t reduction);
  static Tensor matmul(const Tensor & self, const Tensor & other);
  static Tensor & matmul_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor matrix_rank(const Tensor & self, double tol, bool symmetric);
  static Tensor matrix_rank(const Tensor & self, bool symmetric);
  static Tensor matrix_power(const Tensor & self, int64_t n);
  static std::tuple<Tensor,Tensor> max(const Tensor & self, int64_t dim, bool keepdim);
  static std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_values, const Tensor & self, int64_t dim, bool keepdim);
  static Tensor max_values(const Tensor & self, IntArrayRef dim, bool keepdim);
  static std::tuple<Tensor,Tensor> max_pool1d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  static Tensor max_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  static Tensor max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  static Tensor max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  static Tensor mean(const Tensor & self, c10::optional<ScalarType> dtype);
  static Tensor mean(const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype);
  static Tensor & mean_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype);
  static std::tuple<Tensor,Tensor> median(const Tensor & self, int64_t dim, bool keepdim);
  static std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim);
  static std::tuple<Tensor,Tensor> min(const Tensor & self, int64_t dim, bool keepdim);
  static std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim);
  static Tensor min_values(const Tensor & self, IntArrayRef dim, bool keepdim);
  static Tensor mkldnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups);
  static Tensor mkldnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined);
  static std::tuple<Tensor,Tensor> mkldnn_convolution_backward_weights(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined);
  static std::tuple<Tensor,Tensor,Tensor> mkldnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, std::array<bool,3> output_mask);
  static Tensor _sparse_mm(const Tensor & sparse, const Tensor & dense);
  static std::tuple<Tensor,Tensor> mode(const Tensor & self, int64_t dim, bool keepdim);
  static std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim);
  static Tensor mul(const Tensor & self, Scalar other);
  static Tensor & mul_(Tensor & self, Scalar other);
  static Tensor mvlgamma(const Tensor & self, int64_t p);
  static Tensor & mvlgamma_(Tensor & self, int64_t p);
  static Tensor narrow(const Tensor & self, int64_t dim, int64_t start, int64_t length);
  static bool _nnpack_available();
  static Tensor _nnpack_spatial_convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef padding);
  static std::tuple<Tensor,Tensor,Tensor> _nnpack_spatial_convolution_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, std::array<bool,3> output_mask);
  static Tensor _nnpack_spatial_convolution_backward_input(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding);
  static Tensor _nnpack_spatial_convolution_backward_weight(const Tensor & input, IntArrayRef weightsize, const Tensor & grad_output, IntArrayRef padding);
  static Tensor ones(IntArrayRef size, const TensorOptions & options);
  static Tensor & ones_out(Tensor & out, IntArrayRef size);
  static Tensor ones_like(const Tensor & self);
  static Tensor ones_like(const Tensor & self, const TensorOptions & options);
  static Tensor pairwise_distance(const Tensor & x1, const Tensor & x2, double p, double eps, bool keepdim);
  static Tensor cdist(const Tensor & x1, const Tensor & x2, double p);
  static Tensor _cdist_backward(const Tensor & grad, const Tensor & x1, const Tensor & x2, double p, const Tensor & cdist);
  static Tensor pdist(const Tensor & self, double p);
  static Tensor _pdist_forward(const Tensor & self, double p);
  static Tensor _pdist_backward(const Tensor & grad, const Tensor & self, double p, const Tensor & pdist);
  static Tensor cosine_similarity(const Tensor & x1, const Tensor & x2, int64_t dim, double eps);
  static Tensor permute(const Tensor & self, IntArrayRef dims);
  static Tensor numpy_T(const Tensor & self);
  static Tensor pixel_shuffle(const Tensor & self, int64_t upscale_factor);
  static Tensor pin_memory(const Tensor & self);
  static Tensor pinverse(const Tensor & self, double rcond);
  static Tensor poisson_nll_loss(const Tensor & input, const Tensor & target, bool log_input, bool full, double eps, int64_t reduction);
  static Tensor scalar_tensor(Scalar s, const TensorOptions & options);
  static Tensor rand(IntArrayRef size, const TensorOptions & options);
  static Tensor rand(IntArrayRef size, Generator * generator, const TensorOptions & options);
  static Tensor & rand_out(Tensor & out, IntArrayRef size);
  static Tensor & rand_out(Tensor & out, IntArrayRef size, Generator * generator);
  static Tensor rand_like(const Tensor & self);
  static Tensor rand_like(const Tensor & self, const TensorOptions & options);
  static Tensor randint(int64_t high, IntArrayRef size, const TensorOptions & options);
  static Tensor randint(int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options);
  static Tensor randint(int64_t low, int64_t high, IntArrayRef size, const TensorOptions & options);
  static Tensor randint(int64_t low, int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options);
  static Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size);
  static Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size, Generator * generator);
  static Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size);
  static Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size, Generator * generator);
  static Tensor randint_like(const Tensor & self, int64_t high);
  static Tensor randint_like(const Tensor & self, int64_t low, int64_t high);
  static Tensor randint_like(const Tensor & self, int64_t high, const TensorOptions & options);
  static Tensor randint_like(const Tensor & self, int64_t low, int64_t high, const TensorOptions & options);
  static Tensor randn(IntArrayRef size, const TensorOptions & options);
  static Tensor randn(IntArrayRef size, Generator * generator, const TensorOptions & options);
  static Tensor & randn_out(Tensor & out, IntArrayRef size);
  static Tensor & randn_out(Tensor & out, IntArrayRef size, Generator * generator);
  static Tensor randn_like(const Tensor & self);
  static Tensor randn_like(const Tensor & self, const TensorOptions & options);
  static Tensor randperm(int64_t n, const TensorOptions & options);
  static Tensor randperm(int64_t n, Generator * generator, const TensorOptions & options);
  static Tensor & randperm_out(Tensor & out, int64_t n);
  static Tensor range(Scalar start, Scalar end, Scalar step, const TensorOptions & options);
  static Tensor range(Scalar start, Scalar end, const TensorOptions & options);
  static Tensor reciprocal(const Tensor & self);
  static Tensor neg(const Tensor & self);
  static Tensor repeat(const Tensor & self, IntArrayRef repeats);
  static Tensor repeat_interleave(const Tensor & self, const Tensor & repeats, c10::optional<int64_t> dim);
  static Tensor repeat_interleave(const Tensor & self, int64_t repeats, c10::optional<int64_t> dim);
  static Tensor reshape(const Tensor & self, IntArrayRef shape);
  static Tensor reshape_as(const Tensor & self, const Tensor & other);
  static Tensor round(const Tensor & self);
  static Tensor rrelu(const Tensor & self, Scalar lower, Scalar upper, bool training, Generator * generator);
  static Tensor & rrelu_(Tensor & self, Scalar lower, Scalar upper, bool training, Generator * generator);
  static Tensor rsqrt(const Tensor & self);
  #ifdef BUILD_NAMEDTENSOR
  static Tensor select(const Tensor & self, Dimname dim, int64_t index);
  #endif
  static Tensor select(const Tensor & self, int64_t dim, int64_t index);
  static Tensor selu(const Tensor & self);
  static Tensor & selu_(Tensor & self);
  static Tensor celu(const Tensor & self, Scalar alpha);
  static Tensor & celu_(Tensor & self, Scalar alpha);
  static Tensor sin(const Tensor & self);
  static Tensor sinh(const Tensor & self);
  static Tensor detach(const Tensor & self);
  static Tensor & detach_(Tensor & self);
  static int64_t size(const Tensor & self, int64_t dim);
  #ifdef BUILD_NAMEDTENSOR
  static int64_t size(const Tensor & self, Dimname dim);
  #endif
  static Tensor slice(const Tensor & self, int64_t dim, int64_t start, int64_t end, int64_t step);
  static std::tuple<Tensor,Tensor> slogdet(const Tensor & self);
  static Tensor smm(const Tensor & self, const Tensor & mat2);
  static Tensor softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  static std::vector<Tensor> split(const Tensor & self, int64_t split_size, int64_t dim);
  static std::vector<Tensor> split_with_sizes(const Tensor & self, IntArrayRef split_sizes, int64_t dim);
  static Tensor squeeze(const Tensor & self);
  static Tensor squeeze(const Tensor & self, int64_t dim);
  static Tensor & squeeze_(Tensor & self);
  static Tensor & squeeze_(Tensor & self, int64_t dim);
  static Tensor sspaddmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  static Tensor stack(TensorList tensors, int64_t dim);
  static Tensor & stack_out(Tensor & out, TensorList tensors, int64_t dim);
  static Tensor stft(const Tensor & self, int64_t n_fft, c10::optional<int64_t> hop_length, c10::optional<int64_t> win_length, const Tensor & window, bool normalized, bool onesided);
  static int64_t stride(const Tensor & self, int64_t dim);
  #ifdef BUILD_NAMEDTENSOR
  static int64_t stride(const Tensor & self, Dimname dim);
  #endif
  static Tensor sum(const Tensor & self, c10::optional<ScalarType> dtype);
  static Tensor sum(const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype);
  #ifdef BUILD_NAMEDTENSOR
  static Tensor sum(const Tensor & self, DimnameList dim, bool keepdim, c10::optional<ScalarType> dtype);
  #endif
  static Tensor & sum_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype);
  #ifdef BUILD_NAMEDTENSOR
  static Tensor & sum_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim, c10::optional<ScalarType> dtype);
  #endif
  static Tensor sum_to_size(const Tensor & self, IntArrayRef size);
  static Tensor sqrt(const Tensor & self);
  static Tensor std(const Tensor & self, bool unbiased);
  static Tensor std(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  static std::tuple<Tensor,Tensor> std_mean(const Tensor & self, bool unbiased);
  static std::tuple<Tensor,Tensor> std_mean(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  static Tensor & std_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  static Tensor prod(const Tensor & self, c10::optional<ScalarType> dtype);
  static Tensor prod(const Tensor & self, int64_t dim, bool keepdim, c10::optional<ScalarType> dtype);
  static Tensor & prod_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim, c10::optional<ScalarType> dtype);
  #ifdef BUILD_NAMEDTENSOR
  static Tensor prod(const Tensor & self, Dimname dim, bool keepdim, c10::optional<ScalarType> dtype);
  #endif
  #ifdef BUILD_NAMEDTENSOR
  static Tensor & prod_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim, c10::optional<ScalarType> dtype);
  #endif
  static Tensor t(const Tensor & self);
  static Tensor & t_(Tensor & self);
  static Tensor tan(const Tensor & self);
  static Tensor tanh(const Tensor & self);
  static Tensor tensordot(const Tensor & self, const Tensor & other, IntArrayRef dims_self, IntArrayRef dims_other);
  static Tensor threshold(const Tensor & self, Scalar threshold, Scalar value);
  static Tensor & threshold_(Tensor & self, Scalar threshold, Scalar value);
  static Tensor & threshold_out(Tensor & out, const Tensor & self, Scalar threshold, Scalar value);
  static Tensor threshold_backward(const Tensor & grad_output, const Tensor & self, Scalar threshold);
  static Tensor transpose(const Tensor & self, int64_t dim0, int64_t dim1);
  static Tensor & transpose_(Tensor & self, int64_t dim0, int64_t dim1);
  static Tensor one_hot(const Tensor & self, int64_t num_classes);
  static Tensor rot90(const Tensor & self, int64_t k, IntArrayRef dims);
  static Tensor trapz(const Tensor & y, const Tensor & x, int64_t dim);
  static Tensor trapz(const Tensor & y, double dx, int64_t dim);
  static Tensor _trilinear(const Tensor & i1, const Tensor & i2, const Tensor & i3, IntArrayRef expand1, IntArrayRef expand2, IntArrayRef expand3, IntArrayRef sumdim, int64_t unroll_dim);
  static Tensor triplet_margin_loss(const Tensor & anchor, const Tensor & positive, const Tensor & negative, double margin, double p, double eps, bool swap, int64_t reduction);
  static Tensor trunc(const Tensor & self);
  static Tensor type_as(const Tensor & self, const Tensor & other);
  static bool _has_compatible_shallow_copy_type(const Tensor & self, const Tensor & from);
  static Tensor _unsafe_view(const Tensor & self, IntArrayRef size);
  static Tensor unsqueeze(const Tensor & self, int64_t dim);
  static Tensor & unsqueeze_(Tensor & self, int64_t dim);
  static Tensor var(const Tensor & self, bool unbiased);
  static Tensor var(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  static Tensor & var_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  static std::tuple<Tensor,Tensor> var_mean(const Tensor & self, bool unbiased);
  static std::tuple<Tensor,Tensor> var_mean(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  static Tensor view_as(const Tensor & self, const Tensor & other);
  static Tensor where(const Tensor & condition, const Tensor & self, const Tensor & other);
  static std::vector<Tensor> where(const Tensor & condition);
  static Tensor norm_except_dim(const Tensor & v, int64_t pow, int64_t dim);
  static Tensor _weight_norm(const Tensor & v, const Tensor & g, int64_t dim);
  static std::tuple<Tensor,Tensor> _weight_norm_differentiable_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim);
  static Tensor zeros(IntArrayRef size, const TensorOptions & options);
  static Tensor & zeros_out(Tensor & out, IntArrayRef size);
  static Tensor zeros_like(const Tensor & self);
  static Tensor zeros_like(const Tensor & self, const TensorOptions & options);
  static Tensor _sparse_sum(const Tensor & self);
  static Tensor _sparse_sum(const Tensor & self, ScalarType dtype);
  static Tensor _sparse_sum(const Tensor & self, IntArrayRef dim);
  static Tensor _sparse_sum(const Tensor & self, IntArrayRef dim, ScalarType dtype);
  static Tensor norm(const Tensor & self, c10::optional<Scalar> p, ScalarType dtype);
  static Tensor norm(const Tensor & self, Scalar p);
  static Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype);
  static Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim);
  static Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype);
  static Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim);
  static Tensor frobenius_norm(const Tensor & self);
  static Tensor frobenius_norm(const Tensor & self, IntArrayRef dim, bool keepdim);
  static Tensor & frobenius_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim);
  static Tensor nuclear_norm(const Tensor & self, bool keepdim);
  static Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, bool keepdim);
  static Tensor nuclear_norm(const Tensor & self, IntArrayRef dim, bool keepdim);
  static Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim);
  static Tensor & sub_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha);
  static Tensor sub(const Tensor & self, const Tensor & other, Scalar alpha);
  static Tensor & sub_(Tensor & self, const Tensor & other, Scalar alpha);
  static Tensor sub(const Tensor & self, Scalar other, Scalar alpha);
  static Tensor & sub_(Tensor & self, Scalar other, Scalar alpha);
  static Tensor rsub(const Tensor & self, const Tensor & other, Scalar alpha);
  static Tensor rsub(const Tensor & self, Scalar other, Scalar alpha);
  static Tensor _sparse_addmm(const Tensor & self, const Tensor & sparse, const Tensor & dense, Scalar beta, Scalar alpha);
  static Tensor & addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  static Tensor addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  static Tensor & addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  static Tensor sparse_coo_tensor(IntArrayRef size, const TensorOptions & options);
  static Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, const TensorOptions & options);
  static Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options);
  static Tensor _sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options);
  static Tensor to_dense_backward(const Tensor & grad, const Tensor & input);
  static int64_t _dimI(const Tensor & self);
  static int64_t _dimV(const Tensor & self);
  static int64_t numel(const Tensor & self);
  static std::vector<Tensor> unbind(const Tensor & self, int64_t dim);
  static Tensor to_mkldnn_backward(const Tensor & grad, const Tensor & input);
  static Tensor to(const Tensor & self, const TensorOptions & options, bool non_blocking, bool copy);
  static Tensor to(const Tensor & self, Device device, ScalarType dtype, bool non_blocking, bool copy);
  static Tensor to(const Tensor & self, ScalarType dtype, bool non_blocking, bool copy);
  static Tensor to(const Tensor & self, const Tensor & other, bool non_blocking, bool copy);
  static std::vector<Tensor> meshgrid(TensorList tensors);
  static Tensor cartesian_prod(TensorList tensors);
  static Tensor combinations(const Tensor & self, int64_t r, bool with_replacement);
  static Scalar item(const Tensor & self);
  static std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
  static std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & data, const Tensor & batch_sizes, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
  static std::tuple<Tensor,Tensor> gru(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
  static std::tuple<Tensor,Tensor> gru(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
  static std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
  static std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
  static std::tuple<Tensor,Tensor> rnn_relu(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
  static std::tuple<Tensor,Tensor> rnn_relu(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
  static std::tuple<Tensor,Tensor> lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh);
  static Tensor gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh);
  static Tensor rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh);
  static Tensor rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh);
  static std::tuple<Tensor,Tensor,Tensor> quantized_lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first, c10::optional<ScalarType> dtype);
  static std::tuple<Tensor,Tensor> quantized_gru(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
  static std::tuple<Tensor,Tensor> quantized_gru(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
  static std::tuple<Tensor,Tensor> quantized_lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
  static Tensor quantized_gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
  static Tensor quantized_rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
  static Tensor quantized_rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
  static std::tuple<Tensor,Tensor> _pack_padded_sequence(const Tensor & input, const Tensor & lengths, bool batch_first);
  static Tensor _pack_padded_sequence_backward(const Tensor & grad, IntArrayRef input_size, const Tensor & batch_sizes, bool batch_first);
  static std::tuple<Tensor,Tensor> _pad_packed_sequence(const Tensor & data, const Tensor & batch_sizes, bool batch_first, Scalar padding_value, int64_t total_length);
  static Tensor masked_fill(const Tensor & self, const Tensor & mask, Scalar value);
  static Tensor masked_fill(const Tensor & self, const Tensor & mask, const Tensor & value);
  static Tensor masked_scatter(const Tensor & self, const Tensor & mask, const Tensor & source);
  static Tensor index_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
  static Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, Scalar value);
  static Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & value);
  static Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
  static Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, Scalar value);
  static Tensor scatter_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
  static Tensor & cross_out(Tensor & out, const Tensor & self, const Tensor & other, c10::optional<int64_t> dim);
  static Tensor cross(const Tensor & self, const Tensor & other, c10::optional<int64_t> dim);
  static Tensor triu(const Tensor & self, int64_t diagonal);
  static Tensor tril(const Tensor & self, int64_t diagonal);
  static std::vector<Tensor> nonzero_numpy(const Tensor & self);
  static Tensor _gather_sparse_backward(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & grad);
  static std::tuple<Tensor &,Tensor &> triangular_solve_out(Tensor & X, Tensor & M, const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular);
  static std::tuple<Tensor,Tensor> triangular_solve(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular);
  static std::tuple<Tensor &,Tensor &> symeig_out(Tensor & e, Tensor & V, const Tensor & self, bool eigenvectors, bool upper);
  static std::tuple<Tensor,Tensor> symeig(const Tensor & self, bool eigenvectors, bool upper);
  static std::tuple<Tensor &,Tensor &,Tensor &> svd_out(Tensor & U, Tensor & S, Tensor & V, const Tensor & self, bool some, bool compute_uv);
  static std::tuple<Tensor,Tensor,Tensor> svd(const Tensor & self, bool some, bool compute_uv);
  static Tensor & cholesky_out(Tensor & out, const Tensor & self, bool upper);
  static Tensor cholesky(const Tensor & self, bool upper);
  static Tensor & cholesky_solve_out(Tensor & out, const Tensor & self, const Tensor & input2, bool upper);
  static Tensor cholesky_solve(const Tensor & self, const Tensor & input2, bool upper);
  static std::tuple<Tensor,Tensor> solve(const Tensor & self, const Tensor & A);
  static std::tuple<Tensor &,Tensor &> solve_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A);
  static std::tuple<Tensor &,Tensor &> qr_out(Tensor & Q, Tensor & R, const Tensor & self, bool some);
  static std::tuple<Tensor,Tensor> qr(const Tensor & self, bool some);
  static Tensor & lu_solve_out(Tensor & out, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
  static Tensor lu_solve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
  static Tensor argsort(const Tensor & self, int64_t dim, bool descending);
  static std::tuple<Tensor,Tensor> topk(const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted);
  static Tensor all(const Tensor & self);
  static Tensor any(const Tensor & self);
  static Tensor normal(double mean, double std, IntArrayRef size, Generator * generator, const TensorOptions & options);
  static Tensor & normal_out(Tensor & out, double mean, double std, IntArrayRef size, Generator * generator);
  static Tensor alias(const Tensor & self);
  static Tensor & multilabel_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor multilabel_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor & nll_loss_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  static Tensor nll_loss(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  static Tensor & nll_loss2d_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  static Tensor nll_loss2d(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  static Tensor & log_sigmoid_out(Tensor & out, const Tensor & self);
  static Tensor log_sigmoid(const Tensor & self);
  static Tensor adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
  static Tensor & thnn_conv2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
  static Tensor thnn_conv2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
  static Tensor & thnn_conv_depthwise2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
  static Tensor thnn_conv_depthwise2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
  static Tensor & thnn_conv3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
  static Tensor thnn_conv3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
};

} // namespace at
