/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.GErrorStruct;
import com.intellij.credentialStore.LinuxSecretLibraryKt;
import com.intellij.credentialStore.SecretCredentialStore;
import com.intellij.credentialStore.SecretLibrary;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.jna.DisposableMemory;
import com.intellij.util.text.StringKt;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\u001b\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0096\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/credentialStore/SecretCredentialStore;", "Lcom/intellij/credentialStore/CredentialStore;", "schemeName", "", "(Ljava/lang/String;)V", "accountAttributeNamePointer", "Lcom/intellij/util/io/jna/DisposableMemory;", "getAccountAttributeNamePointer", "()Lcom/intellij/util/io/jna/DisposableMemory;", "accountAttributeNamePointer$delegate", "Lkotlin/Lazy;", "scheme", "Lcom/sun/jna/Pointer;", "getScheme", "()Lcom/sun/jna/Pointer;", "scheme$delegate", "serviceAttributeNamePointer", "getServiceAttributeNamePointer", "serviceAttributeNamePointer$delegate", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "set", "", "credentials", "Companion", "intellij.platform.credentialStore"})
public final class SecretCredentialStore
implements CredentialStore {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy serviceAttributeNamePointer$delegate;
    private final Lazy accountAttributeNamePointer$delegate;
    private final Lazy scheme$delegate;
    private static final SecretLibrary library;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SecretCredentialStore.class), "serviceAttributeNamePointer", "getServiceAttributeNamePointer()Lcom/intellij/util/io/jna/DisposableMemory;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SecretCredentialStore.class), "accountAttributeNamePointer", "getAccountAttributeNamePointer()Lcom/intellij/util/io/jna/DisposableMemory;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SecretCredentialStore.class), "scheme", "getScheme()Lcom/sun/jna/Pointer;"))};
        Companion = new Companion(null);
        library = (SecretLibrary)Native.load((String)"secret-1", SecretLibrary.class);
    }

    private final DisposableMemory getServiceAttributeNamePointer() {
        Lazy lazy = this.serviceAttributeNamePointer$delegate;
        SecretCredentialStore secretCredentialStore = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (DisposableMemory)lazy.getValue();
    }

    private final DisposableMemory getAccountAttributeNamePointer() {
        Lazy lazy = this.accountAttributeNamePointer$delegate;
        SecretCredentialStore secretCredentialStore = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (DisposableMemory)lazy.getValue();
    }

    private final Pointer getScheme() {
        Lazy lazy = this.scheme$delegate;
        SecretCredentialStore secretCredentialStore = this;
        KProperty kProperty = $$delegatedProperties[2];
        boolean bl = false;
        return (Pointer)lazy.getValue();
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        return (Credentials)CompletableFuture.supplyAsync((Supplier)new Supplier<Credentials>(this, attributes){
            final /* synthetic */ SecretCredentialStore this$0;
            final /* synthetic */ CredentialAttributes $attributes;

            @Nullable
            public final Credentials get() {
                Object v3;
                GErrorStruct[] errorRef$iv;
                String userName = StringKt.nullize$default((String)this.$attributes.getUserName(), (boolean)false, (int)1, null);
                String method$iv = "secret_password_lookup_sync";
                boolean $i$f$checkError = false;
                GErrorStruct[] errorRef = errorRef$iv = new GErrorStruct[]{null};
                boolean bl = false;
                String string = this.$attributes.getServiceName();
                Charset charset = Charsets.UTF_8;
                boolean bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                DisposableMemory serviceNamePointer = LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
                if (userName == null) {
                    String string3 = SecretCredentialStore.access$getLibrary$cp().secret_password_lookup_sync(SecretCredentialStore.access$getScheme$p(this.this$0), null, errorRef, (Pointer)SecretCredentialStore.access$getServiceAttributeNamePointer$p(this.this$0), (Pointer)serviceNamePointer, null);
                    if (string3 != null) {
                        string = string3;
                        boolean bl3 = false;
                        bl2 = false;
                        String it = string;
                        boolean bl4 = false;
                        return CredentialStoreKt.splitData(it);
                    }
                    v3 = null;
                } else {
                    Pointer[] pointerArray = new Pointer[5];
                    pointerArray[0] = (Pointer)SecretCredentialStore.access$getServiceAttributeNamePointer$p(this.this$0);
                    pointerArray[1] = (Pointer)serviceNamePointer;
                    pointerArray[2] = (Pointer)SecretCredentialStore.access$getAccountAttributeNamePointer$p(this.this$0);
                    string = userName;
                    int n = 3;
                    Pointer[] pointerArray2 = pointerArray;
                    Pointer[] pointerArray3 = pointerArray;
                    GErrorStruct[] gErrorStructArray = errorRef;
                    Pointer pointer = null;
                    Pointer pointer2 = SecretCredentialStore.access$getScheme$p(this.this$0);
                    SecretLibrary secretLibrary = SecretCredentialStore.access$getLibrary$cp();
                    charset = Charsets.UTF_8;
                    bl2 = false;
                    byte[] byArray2 = string.getBytes(charset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                    byte[] byArray3 = byArray2;
                    pointerArray2[n] = (Pointer)LinuxSecretLibraryKt.stringPointer$default(byArray3, false, 2, null);
                    pointerArray3[4] = null;
                    String string4 = secretLibrary.secret_password_lookup_sync(pointer2, pointer, gErrorStructArray, pointerArray3);
                    if (string4 != null) {
                        string = string4;
                        boolean bl5 = false;
                        bl2 = false;
                        String it = string;
                        boolean bl6 = false;
                        return CredentialStoreKt.splitData(it);
                    }
                    v3 = null;
                }
                Object result$iv = v3;
                GErrorStruct error$iv = errorRef$iv[0];
                if (error$iv != null && error$iv.code != 0) {
                    if (error$iv.code == 32584 || error$iv.code == 32618 || error$iv.code == 32606 || error$iv.code == 32642) {
                        CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
                    } else {
                        CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
                    }
                }
                return result$iv;
            }
            {
                this.this$0 = secretCredentialStore;
                this.$attributes = credentialAttributes;
            }
        }, AppExecutorUtil.getAppExecutorService()).get(30L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        GErrorStruct[] errorRef$iv;
        String accountName;
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        String string = attributes.getServiceName();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        DisposableMemory serviceNamePointer = LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
        String string3 = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
        if (string3 == null) {
            Credentials credentials2 = credentials;
            string3 = accountName = credentials2 != null ? credentials2.getUserName() : null;
        }
        if (CredentialAttributesKt.isEmpty((Credentials)credentials)) {
            GErrorStruct[] errorRef$iv2;
            String method$iv = "secret_password_store_sync";
            boolean $i$f$checkError = false;
            GErrorStruct[] errorRef = errorRef$iv2 = new GErrorStruct[]{null};
            boolean bl2 = false;
            if (accountName == null) {
                library.secret_password_clear_sync(this.getScheme(), null, errorRef, (Pointer)this.getServiceAttributeNamePointer(), (Pointer)serviceNamePointer, null);
            } else {
                Pointer[] pointerArray = new Pointer[5];
                pointerArray[0] = (Pointer)this.getServiceAttributeNamePointer();
                pointerArray[1] = (Pointer)serviceNamePointer;
                pointerArray[2] = (Pointer)this.getAccountAttributeNamePointer();
                String string4 = accountName;
                int n = 3;
                Pointer[] pointerArray2 = pointerArray;
                Pointer[] pointerArray3 = pointerArray;
                GErrorStruct[] gErrorStructArray = errorRef;
                Pointer pointer = null;
                Pointer pointer2 = this.getScheme();
                SecretLibrary secretLibrary = library;
                Charset charset2 = Charsets.UTF_8;
                boolean bl3 = false;
                byte[] byArray2 = string4.getBytes(charset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray3 = byArray2;
                pointerArray2[n] = (Pointer)LinuxSecretLibraryKt.stringPointer$default(byArray3, false, 2, null);
                pointerArray3[4] = null;
                secretLibrary.secret_password_clear_sync(pointer2, pointer, gErrorStructArray, pointerArray3);
            }
            Unit result$iv = Unit.INSTANCE;
            GErrorStruct error$iv = errorRef$iv2[0];
            if (error$iv != null && error$iv.code != 0) {
                if (error$iv.code == 32584 || error$iv.code == 32618 || error$iv.code == 32606 || error$iv.code == 32642) {
                    CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
                } else {
                    CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
                }
            }
            return;
        }
        Credentials credentials3 = credentials;
        if (credentials3 == null) {
            Intrinsics.throwNpe();
        }
        DisposableMemory passwordPointer = LinuxSecretLibraryKt.stringPointer(CredentialStoreKt.serialize(credentials3, !attributes.isPasswordMemoryOnly()), true);
        String method$iv = "secret_password_store_sync";
        boolean $i$f$checkError = false;
        GErrorStruct[] errorRef = errorRef$iv = new GErrorStruct[]{null};
        boolean bl4 = false;
        try {
            if (accountName == null) {
                library.secret_password_store_sync(this.getScheme(), null, (Pointer)serviceNamePointer, (Pointer)passwordPointer, null, errorRef, (Pointer)this.getServiceAttributeNamePointer(), (Pointer)serviceNamePointer, null);
            } else {
                Pointer[] pointerArray = new Pointer[5];
                pointerArray[0] = (Pointer)this.getServiceAttributeNamePointer();
                pointerArray[1] = (Pointer)serviceNamePointer;
                pointerArray[2] = (Pointer)this.getAccountAttributeNamePointer();
                String string5 = accountName;
                int n = 3;
                Pointer[] pointerArray4 = pointerArray;
                Pointer[] pointerArray5 = pointerArray;
                GErrorStruct[] gErrorStructArray = errorRef;
                Pointer pointer = null;
                Pointer pointer3 = (Pointer)passwordPointer;
                Pointer pointer4 = (Pointer)serviceNamePointer;
                Pointer pointer5 = null;
                Pointer pointer6 = this.getScheme();
                SecretLibrary secretLibrary = library;
                Charset charset3 = Charsets.UTF_8;
                boolean bl5 = false;
                byte[] byArray4 = string5.getBytes(charset3);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray5 = byArray4;
                pointerArray4[n] = (Pointer)LinuxSecretLibraryKt.stringPointer$default(byArray5, false, 2, null);
                pointerArray5[4] = null;
                secretLibrary.secret_password_store_sync(pointer6, pointer5, pointer4, pointer3, pointer, gErrorStructArray, pointerArray5);
            }
        }
        finally {
            passwordPointer.dispose();
        }
        Unit result$iv = Unit.INSTANCE;
        GErrorStruct error$iv = errorRef$iv[0];
        if (error$iv != null && error$iv.code != 0) {
            if (error$iv.code == 32584 || error$iv.code == 32618 || error$iv.code == 32606 || error$iv.code == 32642) {
                CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
            } else {
                CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
            }
        }
    }

    public SecretCredentialStore(@NotNull String schemeName) {
        Intrinsics.checkParameterIsNotNull((Object)schemeName, (String)"schemeName");
        this.serviceAttributeNamePointer$delegate = LazyKt.lazy((Function0)serviceAttributeNamePointer.2.INSTANCE);
        this.accountAttributeNamePointer$delegate = LazyKt.lazy((Function0)accountAttributeNamePointer.2.INSTANCE);
        this.scheme$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pointer>(this, schemeName){
            final /* synthetic */ SecretCredentialStore this$0;
            final /* synthetic */ String $schemeName;

            @NotNull
            public final Pointer invoke() {
                return SecretCredentialStore.access$getLibrary$cp().secret_schema_new(this.$schemeName, 0, SecretCredentialStore.access$getServiceAttributeNamePointer$p(this.this$0), 0, SecretCredentialStore.access$getAccountAttributeNamePointer$p(this.this$0), 0, null);
            }
            {
                this.this$0 = secretCredentialStore;
                this.$schemeName = string;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ SecretLibrary access$getLibrary$cp() {
        return library;
    }

    public static final /* synthetic */ Pointer access$getScheme$p(SecretCredentialStore $this) {
        return $this.getScheme();
    }

    public static final /* synthetic */ DisposableMemory access$getServiceAttributeNamePointer$p(SecretCredentialStore $this) {
        return $this.getServiceAttributeNamePointer();
    }

    public static final /* synthetic */ DisposableMemory access$getAccountAttributeNamePointer$p(SecretCredentialStore $this) {
        return $this.getAccountAttributeNamePointer();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/credentialStore/SecretCredentialStore$Companion;", "", "()V", "library", "Lcom/intellij/credentialStore/SecretLibrary;", "kotlin.jvm.PlatformType", "intellij.platform.credentialStore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

