/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.JBSplitter;
import com.intellij.util.TimeoutUtil;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.console.ConsolePromptDecorator;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PyConsoleCopyHandler;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleSourceHighlighter;
import com.jetbrains.python.console.PyConsoleStartFolding;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.completion.PythonConsoleAutopopupBlockingHandler;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.testing.PyTestsSharedKt;
import java.awt.Component;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonConsoleView
extends LanguageConsoleImpl
implements ObservableConsoleView,
PyCodeExecutor {
    static Key<Boolean> CONSOLE_KEY = new Key("PYDEV_CONSOLE_KEY");
    private static final Logger LOG = Logger.getInstance(PythonConsoleView.class);
    private final ConsolePromptDecorator myPromptView;
    private final boolean myTestMode;
    private PythonConsoleExecuteActionHandler myExecuteActionHandler;
    private PyConsoleSourceHighlighter mySourceHighlighter;
    private boolean myIsIPythonOutput;
    private final PyHighlighter myPyHighlighter;
    private final EditorColorsScheme myScheme;
    private boolean myHyperlink;
    private XStandaloneVariablesView mySplitView;
    private final ActionCallback myInitialized = new ActionCallback();
    private boolean isShowVars;
    @Nullable
    private String mySdkHomePath;

    public PythonConsoleView(Project project, String title, @Nullable Sdk sdk, boolean testMode) {
        super(project, title, (Language)PythonLanguage.getInstance());
        this.myTestMode = testMode;
        this.isShowVars = PyConsoleOptions.getInstance(project).isShowVariableByDefault();
        VirtualFile virtualFile = this.getVirtualFile();
        virtualFile.putUserData(LanguageLevel.KEY, (Object)PythonSdkType.getLanguageLevelForSdk(sdk));
        virtualFile.putUserData(CONSOLE_KEY, (Object)true);
        this.getConsoleEditor().putUserData(PythonConsoleAutopopupBlockingHandler.REPL_KEY, new Object());
        this.getHistoryViewer().putUserData(ConsoleViewUtil.EDITOR_IS_CONSOLE_HISTORY_VIEW, (Object)true);
        super.setPrompt(null);
        this.setUpdateFoldingsEnabled(false);
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (sdk != null) {
            PythonSdkFlavor sdkFlavor = PythonSdkFlavor.getFlavor(sdk);
            if (sdkFlavor != null) {
                languageLevel = sdkFlavor.getLanguageLevel(sdk);
            }
            this.mySdkHomePath = sdk.getHomePath();
        }
        this.myPyHighlighter = new PyHighlighter(languageLevel);
        this.myScheme = this.getConsoleEditor().getColorsScheme();
        PythonConsoleData data = PyConsoleUtil.getOrCreateIPythonData(this.getVirtualFile());
        this.myPromptView = new ConsolePromptDecorator(this.getConsoleEditor(), data);
    }

    public void setConsoleCommunication(ConsoleCommunication communication) {
        this.getFile().putCopyableUserData(PydevConsoleRunner.CONSOLE_COMMUNICATION_KEY, (Object)communication);
        if (this.isShowVars && communication instanceof PydevConsoleCommunication) {
            this.showVariables((PydevConsoleCommunication)communication);
        }
    }

    @Nullable
    private PyConsoleStartFolding createConsoleFolding(boolean addOnce) {
        PyConsoleStartFolding startFolding = new PyConsoleStartFolding(this, addOnce);
        this.myExecuteActionHandler.getConsoleCommunication().addCommunicationListener((ConsoleCommunicationListener)startFolding);
        Editor editor2 = this.getEditor();
        if (editor2 == null) {
            return null;
        }
        editor2.getDocument().addDocumentListener((DocumentListener)startFolding);
        ((FoldingModelEx)editor2.getFoldingModel()).addListener((FoldingListener)startFolding, (Disposable)this);
        return startFolding;
    }

    public void addConsoleFolding(boolean isDebugConsole, boolean addOnce) {
        try {
            if (isDebugConsole && this.myExecuteActionHandler != null && this.getEditor() != null) {
                PyConsoleStartFolding folding = this.createConsoleFolding(addOnce);
                if (folding != null) {
                    folding.setStartLineOffset(this.getEditor().getDocument().getTextLength());
                    folding.setNumberOfCommandToStop(2);
                }
            } else {
                this.myInitialized.doWhenDone(() -> this.createConsoleFolding(addOnce));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    public void setExecutionHandler(@NotNull PythonConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (consoleExecuteActionHandler == null) {
            PythonConsoleView.$$$reportNull$$$0(0);
        }
        this.myExecuteActionHandler = consoleExecuteActionHandler;
    }

    public PythonConsoleExecuteActionHandler getExecuteActionHandler() {
        return this.myExecuteActionHandler;
    }

    public void setConsoleEnabled(boolean flag) {
        if (this.myExecuteActionHandler != null) {
            this.myExecuteActionHandler.setEnabled(flag);
        } else {
            this.myInitialized.doWhenDone(() -> this.myExecuteActionHandler.setEnabled(flag));
        }
    }

    public void inputRequested() {
        ConsoleCommunication consoleCommunication;
        if (this.myExecuteActionHandler != null && (consoleCommunication = this.myExecuteActionHandler.getConsoleCommunication()) instanceof PythonDebugConsoleCommunication) {
            consoleCommunication.notifyInputRequested();
        }
    }

    public void inputReceived() {
        if (this.myExecuteActionHandler != null) {
            this.myExecuteActionHandler.getConsoleCommunication().notifyInputReceived();
        }
    }

    public void requestFocus() {
        this.myInitialized.doWhenDone(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getConsoleEditor().getContentComponent(), true));
    }

    @Override
    public void executeCode(final @Nullable String code, @Nullable Editor editor2) {
        this.myInitialized.doWhenDone(() -> {
            if (code != null) {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Executing Code in Console...", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        while (!(PythonConsoleView.this.myExecuteActionHandler.isEnabled() && PythonConsoleView.this.myExecuteActionHandler.canExecuteNow() || indicator.isCanceled())) {
                            TimeoutUtil.sleep((long)300L);
                        }
                        if (!indicator.isCanceled()) {
                            PythonConsoleView.this.executeInConsole(code);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PythonConsoleView$1", "run"));
                    }
                });
            } else {
                this.requestFocus();
            }
        });
    }

    public void executeInConsole(@NotNull String code) {
        if (code == null) {
            PythonConsoleView.$$$reportNull$$$0(1);
        }
        CountDownLatch latch = new CountDownLatch(1);
        TransactionGuard.submitTransaction((Disposable)this, () -> {
            String codeToExecute = code.endsWith("\n") || this.myExecuteActionHandler.checkSingleLine(code) ? code : code + "\n";
            DocumentEx document = this.getConsoleEditor().getDocument();
            String oldText = document.getText();
            ApplicationManager.getApplication().runWriteAction(() -> {
                this.setInputText(codeToExecute);
                PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument((Document)document);
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile((Document)document);
                if (psiFile != null) {
                    CommandProcessor.getInstance().runUndoTransparentAction(() -> CodeStyleManager.getInstance((Project)this.getProject()).adjustLineIndent(psiFile, new TextRange(0, psiFile.getTextLength())));
                }
                int oldOffset = this.getConsoleEditor().getCaretModel().getOffset();
                this.getConsoleEditor().getCaretModel().moveToOffset(document.getTextLength());
                this.myExecuteActionHandler.runExecuteAction((LanguageConsoleView)this);
                if (!StringUtil.isEmpty((String)oldText)) {
                    ApplicationManager.getApplication().runWriteAction(() -> this.setInputText(oldText));
                    this.getConsoleEditor().getCaretModel().moveToOffset(oldOffset);
                }
            });
            latch.countDown();
        });
        try {
            latch.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void executeStatement(@NotNull String statement, @NotNull Key attributes) {
        if (statement == null) {
            PythonConsoleView.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            PythonConsoleView.$$$reportNull$$$0(3);
        }
        this.print(statement, this.outputTypeForAttributes(attributes));
        this.myExecuteActionHandler.processLine(statement);
    }

    public void printText(String text2, ConsoleViewContentType outputType) {
        super.print(text2, outputType);
    }

    public void print(String text2, @NotNull Key attributes) {
        if (attributes == null) {
            PythonConsoleView.$$$reportNull$$$0(4);
        }
        this.print(text2, this.outputTypeForAttributes(attributes));
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType outputType) {
        if (text2 == null) {
            PythonConsoleView.$$$reportNull$$$0(5);
        }
        if (outputType == null) {
            PythonConsoleView.$$$reportNull$$$0(6);
        }
        if (this.myTestMode) {
            text2 = PyTestsSharedKt.processTCMessage(text2);
        }
        this.detectIPython(text2, outputType);
        if (PyConsoleUtil.detectIPythonEnd(text2)) {
            this.myIsIPythonOutput = false;
            this.mySourceHighlighter = null;
        } else if (PyConsoleUtil.detectIPythonStart(text2)) {
            this.myIsIPythonOutput = true;
        } else if (this.mySourceHighlighter == null || outputType == ConsoleViewContentType.ERROR_OUTPUT) {
            if (this.myHyperlink) {
                this.printHyperlink(text2, outputType);
            } else {
                super.print(text2, outputType);
            }
            this.myHyperlink = this.detectHyperlink(text2);
            if (this.mySourceHighlighter == null && this.myIsIPythonOutput && PyConsoleUtil.detectSourcePrinting(text2)) {
                this.mySourceHighlighter = new PyConsoleSourceHighlighter(this, this.myScheme, this.myPyHighlighter);
            }
        } else {
            try {
                this.mySourceHighlighter.printHighlightedSource(text2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void detectIPython(String text2, ConsoleViewContentType outputType) {
        VirtualFile file = this.getVirtualFile();
        if (PyConsoleUtil.detectIPythonImported(text2, outputType)) {
            PyConsoleUtil.markIPython(file);
            PythonConsoleExecuteActionHandler handler = this.getExecuteActionHandler();
            if (handler != null) {
                handler.updateConsoleState();
            }
        }
        if (PyConsoleUtil.detectIPythonAutomagicOn(text2)) {
            PyConsoleUtil.setIPythonAutomagic(file, true);
        }
        if (PyConsoleUtil.detectIPythonAutomagicOff(text2)) {
            PyConsoleUtil.setIPythonAutomagic(file, false);
        }
    }

    private boolean detectHyperlink(@NotNull String text2) {
        if (text2 == null) {
            PythonConsoleView.$$$reportNull$$$0(7);
        }
        return this.myIsIPythonOutput && text2.startsWith("File:");
    }

    private void printHyperlink(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            PythonConsoleView.$$$reportNull$$$0(8);
        }
        if (contentType == null) {
            PythonConsoleView.$$$reportNull$$$0(9);
        }
        if (!StringUtil.isEmpty((String)text2)) {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(text2.trim());
            if (vFile != null) {
                OpenFileHyperlinkInfo hyperlink = new OpenFileHyperlinkInfo(this.getProject(), vFile, -1);
                super.printHyperlink(text2, (HyperlinkInfo)hyperlink);
            } else {
                super.print(text2, contentType);
            }
        }
    }

    public ConsoleViewContentType outputTypeForAttributes(Key attributes) {
        ConsoleViewContentType outputType = attributes == ProcessOutputTypes.STDERR ? ConsoleViewContentType.ERROR_OUTPUT : (attributes == ProcessOutputTypes.SYSTEM ? ConsoleViewContentType.SYSTEM_OUTPUT : ConsoleViewContentType.getConsoleViewType((Key)attributes));
        return outputType;
    }

    public void setSdk(Sdk sdk) {
        this.getFile().putCopyableUserData(PydevConsoleRunner.CONSOLE_SDK, (Object)sdk);
    }

    public void showVariables(PydevConsoleCommunication consoleCommunication) {
        PyStackFrame stackFrame = new PyStackFrame(this.getProject(), consoleCommunication, new PyStackFrameInfo("", "", "", null), null);
        final XStandaloneVariablesView view = new XStandaloneVariablesView(this.getProject(), (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider(), (XStackFrame)stackFrame);
        consoleCommunication.addCommunicationListener(new ConsoleCommunicationListener(){

            public void commandExecuted(boolean more) {
                view.rebuildView();
            }

            public void inputRequested() {
            }
        });
        this.mySplitView = view;
        Disposer.register((Disposable)this, (Disposable)view);
        this.splitWindow();
    }

    protected final void doAddPromptToHistory(boolean isMainPrompt) {
        String prompt;
        this.flushDeferredText();
        EditorEx viewer = this.getHistoryViewer();
        DocumentEx document = viewer.getDocument();
        RangeHighlighter highlighter = this.getHistoryViewer().getMarkupModel().addRangeHighlighter(document.getTextLength(), document.getTextLength(), 0, null, HighlighterTargetArea.EXACT_RANGE);
        if (isMainPrompt) {
            prompt = this.myPromptView.getMainPrompt();
            this.print(prompt + " ", this.myPromptView.getPromptAttributes());
        } else {
            prompt = this.myPromptView.getIndentPrompt();
            this.print(prompt + " ", ConsoleViewContentType.USER_INPUT);
        }
        highlighter.putUserData(PyConsoleCopyHandler.PROMPT_LENGTH_MARKER, (Object)(prompt.length() + 1));
    }

    @NotNull
    protected String addTextRangeToHistory(@NotNull TextRange textRange, @NotNull EditorEx inputEditor, boolean preserveMarkup) {
        String text2;
        EditorHighlighter highlighter;
        if (textRange == null) {
            PythonConsoleView.$$$reportNull$$$0(10);
        }
        if (inputEditor == null) {
            PythonConsoleView.$$$reportNull$$$0(11);
        }
        if (inputEditor instanceof EditorWindow) {
            PsiFile file = ((EditorWindow)inputEditor).getInjectedFile();
            highlighter = HighlighterFactory.createHighlighter((VirtualFile)file.getVirtualFile(), (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)this.getProject());
            String fullText = InjectedLanguageUtil.getUnescapedText((PsiFile)file, null, null);
            highlighter.setText((CharSequence)fullText);
            text2 = textRange.substring(fullText);
        } else {
            text2 = inputEditor.getDocument().getText(textRange);
            highlighter = inputEditor.getHighlighter();
        }
        SyntaxHighlighter syntax = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
        this.doAddPromptToHistory(true);
        if (syntax != null) {
            ConsoleViewUtil.printWithHighlighting((ConsoleView)this, (String)text2, (SyntaxHighlighter)syntax, () -> this.doAddPromptToHistory(false));
        } else {
            this.print(text2, ConsoleViewContentType.USER_INPUT);
        }
        this.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        String string = text2;
        if (string == null) {
            PythonConsoleView.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    protected JComponent createCenterComponent() {
        JComponent centerComponent = super.createCenterComponent();
        this.getHistoryViewer().getSettings().setAdditionalLinesCount(0);
        this.getHistoryViewer().getSettings().setUseSoftWraps(false);
        this.getConsoleEditor().getGutter().registerTextAnnotation((TextAnnotationGutterProvider)this.myPromptView);
        this.getConsoleEditor().getGutterComponentEx().setBackground(this.getConsoleEditor().getBackgroundColor());
        this.getConsoleEditor().getGutterComponentEx().revalidate();
        this.getConsoleEditor().getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, this.getConsoleEditor().getBackgroundColor());
        JComponent jComponent = centerComponent;
        if (jComponent == null) {
            PythonConsoleView.$$$reportNull$$$0(13);
        }
        return jComponent;
    }

    private void splitWindow() {
        Component console = this.getComponent(0);
        this.removeAll();
        JBSplitter p = new JBSplitter(false, 0.6666667f);
        p.setFirstComponent((JComponent)console);
        p.setSecondComponent(this.mySplitView.getPanel());
        p.setShowDividerControls(true);
        p.setHonorComponentsMinimumSize(true);
        this.add((Component)p, "Center");
        this.validate();
        this.repaint();
    }

    public void restoreWindow() {
        Component component = this.getComponent(0);
        if (this.mySplitView != null && component instanceof JBSplitter) {
            JBSplitter pane = (JBSplitter)component;
            this.removeAll();
            Disposer.dispose((Disposable)this.mySplitView);
            this.mySplitView = null;
            this.add(pane.getFirstComponent(), "Center");
            this.validate();
            this.repaint();
        }
    }

    @Nullable
    public String getPrompt() {
        if (this.myPromptView == null) {
            return super.getPrompt();
        }
        return this.myPromptView.getMainPrompt();
    }

    public void setPrompt(@Nullable String prompt) {
        if (this.myPromptView == null) {
            super.setPrompt(prompt);
            return;
        }
        if (prompt != null) {
            this.myPromptView.setMainPrompt(prompt);
        }
    }

    @Nullable
    public String getSdkHomePath() {
        return this.mySdkHomePath;
    }

    public void setPromptAttributes(@NotNull ConsoleViewContentType textAttributes) {
        if (textAttributes == null) {
            PythonConsoleView.$$$reportNull$$$0(14);
        }
        this.myPromptView.setPromptAttributes(textAttributes);
    }

    public boolean isInitialized() {
        return this.myInitialized.isDone();
    }

    public void initialized() {
        this.myInitialized.setDone();
    }

    public void setShowVars(boolean showVars) {
        this.isShowVars = showVars;
    }

    public boolean isShowVars() {
        return this.isShowVars;
    }

    public void whenInitialized(Runnable runnable) {
        this.myInitialized.doWhenDone(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleExecuteActionHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputEditor";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PythonConsoleView";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PythonConsoleView";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addTextRangeToHistory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setExecutionHandler";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeInConsole";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeStatement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectHyperlink";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTextRangeToHistory";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setPromptAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

