/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.Intersect;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.PrimaryKey;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import gnu.trove.THashSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelMergerImpl
implements ModelMerger {
    private final List<Pair<ModelMerger.InvocationStrategy, Class>> myInvocationStrategies = new ArrayList<Pair<ModelMerger.InvocationStrategy, Class>>();
    private final List<ModelMerger.MergingStrategy> myMergingStrategies = new ArrayList<ModelMerger.MergingStrategy>();
    private final List<Class> myMergingStrategyClasses = new ArrayList<Class>();
    private static final Class<MergedObject> MERGED_OBJECT_CLASS = MergedObject.class;
    private final ConcurrentMap<Method, List<Pair<ModelMerger.InvocationStrategy, Class>>> myAcceptsCache = ConcurrentFactoryMap.createMap(method -> {
        ArrayList<Pair<ModelMerger.InvocationStrategy, Class>> result = new ArrayList<Pair<ModelMerger.InvocationStrategy, Class>>();
        for (int i = this.myInvocationStrategies.size() - 1; i >= 0; --i) {
            Pair<ModelMerger.InvocationStrategy, Class> pair = this.myInvocationStrategies.get(i);
            if (!((ModelMerger.InvocationStrategy)pair.first).accepts(method)) continue;
            result.add(pair);
        }
        return result;
    });
    private static final Map<Class<?>, Method> ourPrimaryKeyMethods = new HashMap();

    public ModelMergerImpl() {
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method) {
                return true;
            }

            public Object invokeMethod(JavaMethod javaMethod, Object proxy2, Object[] args, List<?> implementations) throws IllegalAccessException, InvocationTargetException {
                Method method = javaMethod.getMethod();
                List results = ModelMergerImpl.this.getMergedImplementations(method, args, method.getReturnType(), implementations, ModelMergerImpl.this.isIntersectionMethod(javaMethod));
                return results.isEmpty() ? null : results.get(0);
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method) {
                return Collection.class.isAssignableFrom(method.getReturnType());
            }

            public Object invokeMethod(JavaMethod method, Object proxy2, Object[] args, List<?> implementations) throws IllegalAccessException, InvocationTargetException {
                Type type = DomReflectionUtil.extractCollectionElementType((Type)method.getGenericReturnType());
                assert (type != null) : "No generic return type in method " + method;
                return ModelMergerImpl.this.getMergedImplementations(method.getMethod(), args, ReflectionUtil.getRawType((Type)type), implementations, ModelMergerImpl.this.isIntersectionMethod(method));
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method) {
                return Object.class.equals(method.getDeclaringClass());
            }

            public Object invokeMethod(JavaMethod method, Object proxy2, Object[] args, List<?> implementations) {
                String methodName = method.getName();
                if ("toString".equals(methodName)) {
                    return "Merger: " + implementations;
                }
                if ("hashCode".equals(methodName)) {
                    int result = 1;
                    for (Object element : implementations) {
                        result = 31 * result + element.hashCode();
                    }
                    return result;
                }
                if ("equals".equals(methodName)) {
                    Object arg = args[0];
                    return arg instanceof MergedObject && implementations.equals(((MergedObject)arg).getImplementations());
                }
                return null;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method) {
                return "isValid".equals(method.getName());
            }

            public Object invokeMethod(JavaMethod method, Object proxy2, Object[] args, List<?> implementations) throws IllegalAccessException, InvocationTargetException {
                for (Object implementation : implementations) {
                    if (((Boolean)method.invoke(implementation, args)).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method) {
                return Void.TYPE.equals(method.getReturnType());
            }

            public Object invokeMethod(JavaMethod method, Object proxy2, Object[] args, List<?> implementations) throws IllegalAccessException, InvocationTargetException {
                for (Object t : implementations) {
                    method.invoke(t, args);
                }
                return null;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method) {
                return MERGED_OBJECT_CLASS.equals(method.getDeclaringClass());
            }

            public Object invokeMethod(JavaMethod method, Object proxy2, Object[] args, List<?> implementations) throws IllegalAccessException, InvocationTargetException {
                assert ("getImplementations".equals(method.getName()));
                return implementations;
            }
        });
        this.addInvocationStrategy(DomElement.class, new ModelMerger.InvocationStrategy<DomElement>(){

            public boolean accepts(Method method) {
                return DomInvocationHandler.ACCEPT_METHOD.equals(method);
            }

            public Object invokeMethod(JavaMethod method, DomElement proxy2, Object[] args, List<? extends DomElement> implementations) throws IllegalAccessException, InvocationTargetException {
                DomElementVisitor visitor2 = (DomElementVisitor)args[0];
                ((DomManagerImpl)implementations.get(0).getManager()).getApplicationComponent().getVisitorDescription(visitor2.getClass()).acceptElement(visitor2, proxy2);
                return null;
            }
        });
        this.addInvocationStrategy(DomElement.class, new ModelMerger.InvocationStrategy<DomElement>(){

            public boolean accepts(Method method) {
                return DomInvocationHandler.ACCEPT_CHILDREN_METHOD.equals(method);
            }

            public Object invokeMethod(JavaMethod method, DomElement proxy2, Object[] args, List<? extends DomElement> implementations) throws IllegalAccessException, InvocationTargetException {
                DomElementVisitor visitor2 = (DomElementVisitor)args[0];
                for (AbstractDomChildrenDescription description : implementations.get(0).getGenericInfo().getChildrenDescriptions()) {
                    for (DomElement value : description.getValues(proxy2)) {
                        value.accept(visitor2);
                    }
                }
                return null;
            }
        });
    }

    private boolean isIntersectionMethod(JavaMethod javaMethod) {
        return javaMethod.getMethod().getAnnotation(Intersect.class) != null;
    }

    public final <T> void addInvocationStrategy(Class<T> aClass, ModelMerger.InvocationStrategy<T> strategy) {
        this.myInvocationStrategies.add((Pair<ModelMerger.InvocationStrategy, Class>)Pair.create(strategy, aClass));
    }

    public final <T> void addMergingStrategy(Class<T> aClass, ModelMerger.MergingStrategy<T> strategy) {
        this.myMergingStrategies.add(strategy);
        this.myMergingStrategyClasses.add(aClass);
    }

    public <T> T mergeModels(Class<T> aClass, T ... implementations) {
        if (implementations.length == 1) {
            return implementations[0];
        }
        MergingInvocationHandler<T> handler = new MergingInvocationHandler<T>(aClass, Arrays.asList(implementations));
        return this._mergeModels(aClass, handler, implementations);
    }

    public <T> T mergeModels(Class<T> aClass, Collection<? extends T> implementations) {
        return (T)this.mergeModels(aClass, implementations.toArray());
    }

    private <T> T _mergeModels(Class<? super T> aClass, MergingInvocationHandler<T> handler, T ... implementations) {
        Set commonClasses = (Set)ModelMergerImpl.getCommonClasses(new THashSet(), implementations);
        commonClasses.add(MERGED_OBJECT_CLASS);
        commonClasses.add(aClass);
        return (T)AdvancedProxy.createProxy(handler, null, (Class[])commonClasses.toArray(ArrayUtil.EMPTY_CLASS_ARRAY));
    }

    private static <T extends Collection<Class>> T getCommonClasses(T result, Object ... implementations) {
        if (implementations.length > 0) {
            DomUtil.getAllInterfaces(implementations[0].getClass(), result);
            for (int i = 1; i < implementations.length; ++i) {
                ArrayList list1 = new ArrayList();
                DomUtil.getAllInterfaces(implementations[i].getClass(), list1);
                result.retainAll(list1);
            }
        }
        return result;
    }

    @Nullable
    private static Object getPrimaryKey(Object implementation, boolean singleValuedInvocation) {
        Method method = ModelMergerImpl.getPrimaryKeyMethod(implementation.getClass());
        if (method != null) {
            Object o = DomReflectionUtil.invokeMethod((Method)method, (Object)implementation, (Object[])new Object[0]);
            return ReflectionUtil.isAssignable(GenericValue.class, method.getReturnType()) ? ((GenericValue)o).getValue() : o;
        }
        if (implementation instanceof GenericValue) {
            return singleValuedInvocation ? Boolean.TRUE : ((GenericValue)implementation).getValue();
        }
        return null;
    }

    @Nullable
    private static Method getPrimaryKeyMethod(Class<?> aClass) {
        Method method = ourPrimaryKeyMethods.get(aClass);
        if (method == null) {
            Method method1;
            if (ourPrimaryKeyMethods.containsKey(aClass)) {
                return null;
            }
            Iterator iterator = ReflectionUtil.getClassPublicMethods(aClass).iterator();
            while (iterator.hasNext() && (method = ModelMergerImpl.findPrimaryKeyAnnotatedMethod(method1 = (Method)iterator.next(), aClass)) == null) {
            }
            ourPrimaryKeyMethods.put(aClass, method);
        }
        return method;
    }

    @Nullable
    private static Method findPrimaryKeyAnnotatedMethod(Method method, Class aClass) {
        if (method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0) {
            for (Method each : new JavaMethodSignature(method).getAllMethods(aClass)) {
                if (each.getAnnotation(PrimaryKey.class) == null) continue;
                return each;
            }
        }
        return null;
    }

    private List<Object> getMergedImplementations(Method method, Object[] args, Class returnType, List<?> implementations, boolean intersect) throws IllegalAccessException, InvocationTargetException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (returnType.isInterface()) {
            SmartList orderedPrimaryKeys = new SmartList();
            Map map2 = FactoryMap.create(arg_0 -> ModelMergerImpl.lambda$getMergedImplementations$1((List)orderedPrimaryKeys, arg_0));
            Map counts = FactoryMap.create(key -> new int[implementations.size()]);
            for (int i = 0; i < implementations.size(); ++i) {
                Object t = implementations.get(i);
                Object o = method.invoke(t, args);
                if (o instanceof Collection) {
                    for (Object o1 : (Collection)o) {
                        this.addToMaps(o1, counts, map2, i, results, false, intersect);
                    }
                    continue;
                }
                if (o == null) continue;
                this.addToMaps(o, counts, map2, i, results, true, intersect);
            }
            for (Object primaryKey : orderedPrimaryKeys) {
                for (Set objects : (List)map2.get(primaryKey)) {
                    results.add(this.mergeImplementations(returnType, new ArrayList<Object>(objects)));
                }
            }
        } else {
            HashSet<Object> map3 = new HashSet<Object>();
            for (Object t : implementations) {
                Object o = method.invoke(t, args);
                if (o instanceof Collection) {
                    map3.addAll((Collection)o);
                    continue;
                }
                if (o == null) continue;
                map3.add(o);
                break;
            }
            results.addAll(map3);
        }
        return results;
    }

    protected final Object mergeImplementations(Class returnType, List<Object> implementations) {
        for (int i = this.myMergingStrategies.size() - 1; i >= 0; --i) {
            Object o;
            if (!ReflectionUtil.isAssignable((Class)this.myMergingStrategyClasses.get(i), (Class)returnType) || (o = this.myMergingStrategies.get(i).mergeChildren(returnType, implementations)) == null) continue;
            return o;
        }
        if (implementations.size() == 1) {
            return implementations.get(0);
        }
        return this.mergeModels((Class)returnType, (Collection)implementations);
    }

    private boolean addToMaps(Object o, Map<Object, int[]> counts, Map<Object, List<Set<Object>>> map2, int index, List<Object> results, boolean singleValuedInvocation, boolean intersect) {
        Object primaryKey = ModelMergerImpl.getPrimaryKey(o, singleValuedInvocation);
        if (primaryKey != null || singleValuedInvocation) {
            int n;
            List<Set<Object>> list = map2.get(primaryKey);
            int[] indices = counts.get(primaryKey);
            if (intersect) {
                n = indices[index];
            } else {
                int n2 = index;
                int n3 = indices[n2];
                n = n3;
                indices[n2] = n3 + 1;
            }
            int objIndex = n;
            if (list.size() <= objIndex) {
                list.add(new LinkedHashSet());
            }
            list.get(objIndex).add(o);
            return false;
        }
        results.add(o);
        return true;
    }

    private static /* synthetic */ List lambda$getMergedImplementations$1(List orderedPrimaryKeys, Object key) {
        orderedPrimaryKeys.add(key);
        return new SmartList();
    }

    public class MergingInvocationHandler<T>
    implements InvocationHandler {
        private final Class<? super T> myClass;
        private List<? extends T> myImplementations;

        public MergingInvocationHandler(Class<T> aClass, List<? extends T> implementations) {
            this(aClass);
            for (T implementation : implementations) {
                if (implementation instanceof StableElement) {
                    throw new AssertionError((Object)("Stable values merging is prohibited: " + implementation));
                }
            }
            this.myImplementations = implementations;
        }

        public MergingInvocationHandler(Class<T> aClass) {
            this.myClass = aClass;
        }

        @NotNull
        private ModelMerger.InvocationStrategy findStrategy(Object proxy2, Method method) {
            for (Pair pair : (List)ModelMergerImpl.this.myAcceptsCache.get(method)) {
                if (!Object.class.equals(pair.second) && !((Class)pair.second).isInstance(proxy2)) continue;
                ModelMerger.InvocationStrategy invocationStrategy = (ModelMerger.InvocationStrategy)pair.first;
                if (invocationStrategy == null) {
                    MergingInvocationHandler.$$$reportNull$$$0(0);
                }
                return invocationStrategy;
            }
            throw new AssertionError((Object)"impossible");
        }

        public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
            try {
                return this.findStrategy(proxy2, method).invokeMethod(this.getJavaMethod(method), proxy2, args, this.myImplementations);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private JavaMethod getJavaMethod(Method method) {
            if (ReflectionUtil.isAssignable((Class)MERGED_OBJECT_CLASS, method.getDeclaringClass())) {
                return JavaMethod.getMethod((Class)MERGED_OBJECT_CLASS, (Method)method);
            }
            if (ReflectionUtil.isAssignable(method.getDeclaringClass(), this.myClass)) {
                return JavaMethod.getMethod(this.myClass, (Method)method);
            }
            return JavaMethod.getMethod(method.getDeclaringClass(), (Method)method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ModelMergerImpl$MergingInvocationHandler", "findStrategy"));
        }
    }
}

