/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DockableEditorContainerFactory
implements DockContainerFactory.Persistent {
    public static final String TYPE = "file-editors";
    private final Project myProject;
    private final FileEditorManagerImpl myFileEditorManager;
    private final DockManager myDockManager;

    public DockableEditorContainerFactory(Project project, FileEditorManagerImpl fileEditorManager, DockManager dockManager) {
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
        this.myDockManager = dockManager;
    }

    public DockContainer createContainer(DockableContent content2) {
        return this.createContainer(false);
    }

    private DockContainer createContainer(boolean loadingState) {
        final Ref containerRef = new Ref();
        EditorsSplitters splitters = new EditorsSplitters(this.myFileEditorManager, this.myDockManager, false){

            @Override
            protected void afterFileClosed(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((DockableEditorTabbedContainer)containerRef.get()).fireContentClosed(file2);
            }

            @Override
            protected void afterFileOpen(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                ((DockableEditorTabbedContainer)containerRef.get()).fireContentOpen(file2);
            }

            @Override
            protected IdeFrame getFrame(Project project) {
                return DockManager.getInstance((Project)project).getIdeFrame((DockContainer)containerRef.get());
            }

            @Override
            public boolean isFloating() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/DockableEditorContainerFactory$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterFileClosed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterFileOpen";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (!loadingState) {
            splitters.createCurrentWindow();
        }
        DockableEditorTabbedContainer container = new DockableEditorTabbedContainer(this.myProject, splitters, true);
        Disposer.register((Disposable)container, (Disposable)splitters);
        containerRef.set((Object)container);
        container.getSplitters().startListeningFocus();
        return container;
    }

    public DockContainer loadContainerFrom(Element element) {
        DockableEditorTabbedContainer container = (DockableEditorTabbedContainer)this.createContainer(true);
        container.getSplitters().readExternal(element.getChild("state"));
        return container;
    }

    public void dispose() {
    }
}

