/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.parser;

import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.impl.PsiBuilderAdapter;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.ICompositeElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LimitedPool;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedParserUtilBase {
    private static final Logger LOG = Logger.getInstance((String)"org.intellij.grammar.parser.GeneratedParserUtilBase");
    private static final int MAX_RECURSION_LEVEL = StringUtil.parseInt((String)System.getProperty("grammar.kit.gpub.max.level"), (int)1000);
    private static final int MAX_VARIANTS_SIZE = 10000;
    private static final int MAX_VARIANTS_TO_DISPLAY = 50;
    private static final int MAX_ERROR_TOKEN_TEXT = 20;
    private static final int INITIAL_VARIANTS_SIZE = 1000;
    private static final int VARIANTS_POOL_SIZE = 10000;
    private static final int FRAMES_POOL_SIZE = 500;
    public static final IElementType DUMMY_BLOCK = new DummyBlockElementType();
    public static final Parser TOKEN_ADVANCER = (builder2, level) -> {
        if (builder2.eof()) {
            return false;
        }
        builder2.advanceLexer();
        return true;
    };
    public static final Parser TRUE_CONDITION = (builder2, level) -> true;
    public static final Hook<WhitespacesAndCommentsBinder> LEFT_BINDER = (builder2, marker, param) -> {
        if (marker != null) {
            marker.setCustomEdgeTokenBinders(param, null);
        }
        return marker;
    };
    public static final Hook<WhitespacesAndCommentsBinder> RIGHT_BINDER = (builder2, marker, param) -> {
        if (marker != null) {
            marker.setCustomEdgeTokenBinders(null, param);
        }
        return marker;
    };
    public static final Hook<WhitespacesAndCommentsBinder[]> WS_BINDERS = (builder2, marker, param) -> {
        if (marker != null) {
            marker.setCustomEdgeTokenBinders(param[0], param[1]);
        }
        return marker;
    };
    public static final Hook<String> LOG_HOOK = (builder2, marker, param) -> {
        PsiBuilderImpl.ProductionMarker m = (PsiBuilderImpl.ProductionMarker)marker;
        int start2 = m == null ? builder2.getCurrentOffset() : m.getStartOffset();
        int end = m == null ? start2 : m.getEndOffset();
        String prefix = "[" + start2 + ", " + end + "]" + (m == null ? "" : " " + m.getTokenType());
        builder2.mark().error(prefix + ": " + param);
        return marker;
    };
    public static final int _NONE_ = 0;
    public static final int _COLLAPSE_ = 1;
    public static final int _LEFT_ = 2;
    public static final int _LEFT_INNER_ = 4;
    public static final int _AND_ = 8;
    public static final int _NOT_ = 16;
    public static final int _UPPER_ = 32;
    public static final Key<CompletionState> COMPLETION_STATE_KEY = Key.create((String)"COMPLETION_STATE_KEY");
    private static final int MAX_CHILDREN_IN_TREE = 10;

    public static boolean eof(PsiBuilder builder2, int level) {
        return builder2.eof();
    }

    public static int current_position_(PsiBuilder builder2) {
        return builder2.rawTokenIndex();
    }

    public static boolean recursion_guard_(PsiBuilder builder2, int level, String funcName) {
        if (level > MAX_RECURSION_LEVEL) {
            builder2.mark().error("Maximum recursion level (" + MAX_RECURSION_LEVEL + ") reached in '" + funcName + "'");
            return false;
        }
        return true;
    }

    public static boolean empty_element_parsed_guard_(PsiBuilder builder2, String funcName, int pos) {
        if (pos == GeneratedParserUtilBase.current_position_(builder2)) {
            builder2.error("Empty element parsed in '" + funcName + "' at offset " + builder2.getCurrentOffset());
            return false;
        }
        return true;
    }

    public static boolean invalid_left_marker_guard_(PsiBuilder builder2, PsiBuilder.Marker marker, String funcName) {
        boolean goodMarker;
        boolean bl = goodMarker = marker != null;
        if (!goodMarker) {
            return false;
        }
        ErrorState state = ErrorState.get(builder2);
        return state.currentFrame != null;
    }

    public static TokenSet create_token_set_(IElementType ... tokenTypes) {
        return TokenSet.create((IElementType[])tokenTypes);
    }

    public static boolean leftMarkerIs(PsiBuilder builder2, IElementType type) {
        LighterASTNode marker = builder2.getLatestDoneMarker();
        return marker != null && marker.getTokenType() == type;
    }

    private static boolean consumeTokens(PsiBuilder builder2, boolean smart, int pin, IElementType ... tokens) {
        ErrorState state = ErrorState.get(builder2);
        if (state.completionState != null && state.predicateSign) {
            GeneratedParserUtilBase.addCompletionVariant(builder2, state.completionState, tokens);
        }
        CompletionState completionState = state.completionState;
        state.completionState = null;
        boolean result2 = true;
        boolean pinned = false;
        int tokensLength = tokens.length;
        for (int i = 0; i < tokensLength; ++i) {
            boolean fast;
            if (pin > 0 && i == pin) {
                pinned = result2;
            }
            if (!result2 && !pinned) continue;
            boolean bl = fast = smart && i == 0;
            if (!fast ? GeneratedParserUtilBase.consumeToken(builder2, tokens[i]) : GeneratedParserUtilBase.consumeTokenFast(builder2, tokens[i])) continue;
            result2 = false;
            if (pin >= 0 && !pinned) continue;
            GeneratedParserUtilBase.report_error_(builder2, state, false);
        }
        state.completionState = completionState;
        return pinned || result2;
    }

    public static boolean consumeTokens(PsiBuilder builder2, int pin, IElementType ... token) {
        return GeneratedParserUtilBase.consumeTokens(builder2, false, pin, token);
    }

    public static boolean consumeTokensSmart(PsiBuilder builder2, int pin, IElementType ... token) {
        return GeneratedParserUtilBase.consumeTokens(builder2, true, pin, token);
    }

    public static boolean parseTokens(PsiBuilder builder2, int pin, IElementType ... tokens) {
        return GeneratedParserUtilBase.parseTokens(builder2, false, pin, tokens);
    }

    public static boolean parseTokensSmart(PsiBuilder builder2, int pin, IElementType ... tokens) {
        return GeneratedParserUtilBase.parseTokens(builder2, true, pin, tokens);
    }

    public static boolean parseTokens(PsiBuilder builder2, boolean smart, int pin, IElementType ... tokens) {
        PsiBuilder.Marker marker = builder2.mark();
        boolean result2 = GeneratedParserUtilBase.consumeTokens(builder2, smart, pin, tokens);
        if (!result2) {
            marker.rollbackTo();
        } else {
            marker.drop();
        }
        return result2;
    }

    public static boolean consumeTokenSmart(PsiBuilder builder2, IElementType token) {
        GeneratedParserUtilBase.addCompletionVariantSmart(builder2, token);
        return GeneratedParserUtilBase.consumeTokenFast(builder2, token);
    }

    public static boolean consumeTokenSmart(PsiBuilder builder2, String token) {
        GeneratedParserUtilBase.addCompletionVariantSmart(builder2, token);
        return GeneratedParserUtilBase.consumeTokenFast(builder2, token);
    }

    public static boolean consumeToken(PsiBuilder builder2, IElementType token) {
        GeneratedParserUtilBase.addVariantSmart(builder2, token, true);
        if (GeneratedParserUtilBase.nextTokenIsFast(builder2, token)) {
            builder2.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean consumeTokenFast(PsiBuilder builder2, IElementType token) {
        if (GeneratedParserUtilBase.nextTokenIsFast(builder2, token)) {
            builder2.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean consumeToken(PsiBuilder builder2, String text2) {
        return GeneratedParserUtilBase.consumeToken(builder2, text2, ErrorState.get(builder2).caseSensitive);
    }

    public static boolean consumeToken(PsiBuilder builder2, String text2, boolean caseSensitive) {
        GeneratedParserUtilBase.addVariantSmart(builder2, text2, true);
        int count = GeneratedParserUtilBase.nextTokenIsFast(builder2, text2, caseSensitive);
        if (count > 0) {
            while (count-- > 0) {
                builder2.advanceLexer();
            }
            return true;
        }
        return false;
    }

    public static boolean consumeTokenFast(PsiBuilder builder2, String text2) {
        int count = GeneratedParserUtilBase.nextTokenIsFast(builder2, text2, ErrorState.get(builder2).caseSensitive);
        if (count > 0) {
            while (count-- > 0) {
                builder2.advanceLexer();
            }
            return true;
        }
        return false;
    }

    public static boolean consumeToken(PsiBuilder builder2, TokenSet tokens) {
        GeneratedParserUtilBase.addVariantSmart(builder2, tokens.getTypes(), true);
        return GeneratedParserUtilBase.consumeTokenFast(builder2, tokens);
    }

    public static boolean consumeTokenSmart(PsiBuilder builder2, TokenSet tokens) {
        GeneratedParserUtilBase.addCompletionVariantSmart(builder2, tokens.getTypes());
        return GeneratedParserUtilBase.consumeTokenFast(builder2, tokens);
    }

    public static boolean consumeTokenFast(PsiBuilder builder2, TokenSet tokens) {
        if (GeneratedParserUtilBase.nextTokenIsFast(builder2, tokens)) {
            builder2.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder2, IElementType token) {
        return builder2.getTokenType() == token;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder2, IElementType ... tokens) {
        IElementType tokenType = builder2.getTokenType();
        for (IElementType token : tokens) {
            if (token != tokenType) continue;
            return true;
        }
        return false;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder2, TokenSet tokens) {
        return tokens.contains(builder2.getTokenType());
    }

    public static boolean nextTokenIsSmart(PsiBuilder builder2, IElementType token) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder2, token) || ErrorState.get((PsiBuilder)builder2).completionState != null;
    }

    public static boolean nextTokenIsSmart(PsiBuilder builder2, IElementType ... tokens) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder2, tokens) || ErrorState.get((PsiBuilder)builder2).completionState != null;
    }

    public static boolean nextTokenIs(PsiBuilder builder2, String frameName, IElementType ... tokens) {
        ErrorState state = ErrorState.get(builder2);
        if (state.completionState != null) {
            return true;
        }
        boolean track = !state.suppressErrors && state.predicateCount < 2 && state.predicateSign;
        return !track ? GeneratedParserUtilBase.nextTokenIsFast(builder2, tokens) : GeneratedParserUtilBase.nextTokenIsSlow(builder2, frameName, tokens);
    }

    public static boolean nextTokenIsSlow(PsiBuilder builder2, String frameName, IElementType ... tokens) {
        ErrorState state = ErrorState.get(builder2);
        IElementType tokenType = builder2.getTokenType();
        if (StringUtil.isNotEmpty((String)frameName)) {
            GeneratedParserUtilBase.addVariantInner(state, state.currentFrame, builder2.rawTokenIndex(), frameName);
        } else {
            for (IElementType token : tokens) {
                GeneratedParserUtilBase.addVariant(builder2, state, token);
            }
        }
        if (tokenType == null) {
            return false;
        }
        for (IElementType token : tokens) {
            if (tokenType != token) continue;
            return true;
        }
        return false;
    }

    public static boolean nextTokenIs(PsiBuilder builder2, IElementType token) {
        if (!GeneratedParserUtilBase.addVariantSmart(builder2, token, false)) {
            return true;
        }
        return GeneratedParserUtilBase.nextTokenIsFast(builder2, token);
    }

    public static boolean nextTokenIs(PsiBuilder builder2, String tokenText) {
        if (!GeneratedParserUtilBase.addVariantSmart(builder2, tokenText, false)) {
            return true;
        }
        return GeneratedParserUtilBase.nextTokenIsFast(builder2, tokenText, ErrorState.get(builder2).caseSensitive) > 0;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder2, String tokenText) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder2, tokenText, ErrorState.get(builder2).caseSensitive) > 0;
    }

    public static int nextTokenIsFast(PsiBuilder builder2, String tokenText, boolean caseSensitive) {
        int nextOffset;
        int endOffset;
        int offset;
        CharSequence sequence = builder2.getOriginalText();
        CharSequence subSequence = sequence.subSequence(offset = builder2.getCurrentOffset(), Math.min(endOffset = offset + tokenText.length(), sequence.length()));
        if (!Comparing.equal((CharSequence)subSequence, (CharSequence)tokenText, (boolean)caseSensitive)) {
            return 0;
        }
        int count = 0;
        do {
            if ((nextOffset = builder2.rawTokenTypeStart(++count)) <= endOffset) continue;
            return -count;
        } while (nextOffset != endOffset);
        return count;
    }

    private static void addCompletionVariantSmart(PsiBuilder builder2, Object token) {
        ErrorState state = ErrorState.get(builder2);
        CompletionState completionState = state.completionState;
        if (completionState != null && state.predicateSign) {
            GeneratedParserUtilBase.addCompletionVariant(builder2, completionState, token);
        }
    }

    private static boolean addVariantSmart(PsiBuilder builder2, Object token, boolean force) {
        ErrorState state = ErrorState.get(builder2);
        if (state.completionState != null && !force) {
            return false;
        }
        builder2.eof();
        if (!state.suppressErrors && state.predicateCount < 2) {
            GeneratedParserUtilBase.addVariant(builder2, state, token);
        }
        return true;
    }

    public static void addVariant(PsiBuilder builder2, String text2) {
        GeneratedParserUtilBase.addVariant(builder2, ErrorState.get(builder2), text2);
    }

    private static void addVariant(PsiBuilder builder2, ErrorState state, Object o) {
        builder2.eof();
        GeneratedParserUtilBase.addVariantInner(state, state.currentFrame, builder2.rawTokenIndex(), o);
        CompletionState completionState = state.completionState;
        if (completionState != null && state.predicateSign) {
            GeneratedParserUtilBase.addCompletionVariant(builder2, completionState, o);
        }
    }

    private static void addVariantInner(ErrorState state, Frame frame, int pos, Object o) {
        Variant variant = ((Variant)state.VARIANTS.alloc()).init(pos, o);
        if (state.predicateSign) {
            state.variants.add(variant);
            if (frame.lastVariantAt < pos) {
                frame.lastVariantAt = pos;
            }
        } else {
            state.unexpected.add(variant);
        }
    }

    private static void addCompletionVariant(@NotNull PsiBuilder builder2, @NotNull CompletionState completionState, Object o) {
        if (builder2 == null) {
            GeneratedParserUtilBase.$$$reportNull$$$0(0);
        }
        if (completionState == null) {
            GeneratedParserUtilBase.$$$reportNull$$$0(1);
        }
        int offset = builder2.getCurrentOffset();
        if (!builder2.eof() && offset == builder2.rawTokenTypeStart(1)) {
            return;
        }
        String text2 = completionState.convertItem(o);
        int length = text2 == null ? 0 : text2.length();
        boolean add = length != 0 && completionState.prefixMatches(builder2, text2);
        boolean bl = add = !(!add || length <= 1 || text2.charAt(0) == '<' && text2.charAt(length - 1) == '>' || text2.charAt(0) == '\'' && text2.charAt(length - 1) == '\'' && length < 5);
        if (add) {
            completionState.addItem(builder2, text2);
        }
    }

    public static boolean isWhitespaceOrComment(@NotNull PsiBuilder builder2, @Nullable IElementType type) {
        if (builder2 == null) {
            GeneratedParserUtilBase.$$$reportNull$$$0(2);
        }
        return ((PsiBuilderImpl)((Builder)builder2).getDelegate()).whitespaceOrComment(type);
    }

    private static boolean wasAutoSkipped(@NotNull PsiBuilder builder2, int steps) {
        if (builder2 == null) {
            GeneratedParserUtilBase.$$$reportNull$$$0(3);
        }
        for (int i = -1; i >= -steps; --i) {
            if (GeneratedParserUtilBase.isWhitespaceOrComment(builder2, builder2.rawLookup(i))) continue;
            return false;
        }
        return true;
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder2) {
        ErrorState state = ErrorState.get(builder2);
        GeneratedParserUtilBase.reportFrameError(builder2, state);
        ++state.level;
        return builder2.mark();
    }

    public static void exit_section_(PsiBuilder builder2, PsiBuilder.Marker marker, @Nullable IElementType elementType, boolean result2) {
        ErrorState state = ErrorState.get(builder2);
        GeneratedParserUtilBase.close_marker_impl_(state.currentFrame, marker, elementType, result2);
        GeneratedParserUtilBase.run_hooks_impl_(builder2, state, (IElementType)(result2 ? elementType : null));
        --state.level;
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder2, int level, int modifiers, String frameName) {
        return GeneratedParserUtilBase.enter_section_(builder2, level, modifiers, null, frameName);
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder2, int level, int modifiers) {
        return GeneratedParserUtilBase.enter_section_(builder2, level, modifiers, null, null);
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder2, int level, int modifiers, IElementType elementType, String frameName) {
        GeneratedParserUtilBase.reportFrameError(builder2, ErrorState.get(builder2));
        PsiBuilder.Marker marker = builder2.mark();
        GeneratedParserUtilBase.enter_section_impl_(builder2, level, modifiers, elementType, frameName);
        return marker;
    }

    private static void enter_section_impl_(PsiBuilder builder2, int level, int modifiers, IElementType elementType, String frameName) {
        PsiBuilder.Marker left;
        ErrorState state = ErrorState.get(builder2);
        ++state.level;
        Frame frame = ((Frame)state.FRAMES.alloc()).init(builder2, state, level, modifiers, elementType, frameName);
        if ((frame.modifiers & 2 | frame.modifiers & 4) != 0 && GeneratedParserUtilBase.invalid_left_marker_guard_(builder2, left = (PsiBuilder.Marker)builder2.getLatestDoneMarker(), frameName)) {
            frame.leftMarker = left;
        }
        state.currentFrame = frame;
        if ((modifiers & 8) != 0) {
            if (state.predicateCount == 0 && !state.predicateSign) {
                throw new AssertionError((Object)"Incorrect false predicate sign");
            }
            ++state.predicateCount;
        } else if ((modifiers & 0x10) != 0) {
            state.predicateSign = state.predicateCount != 0 && !state.predicateSign;
            ++state.predicateCount;
        }
    }

    public static void exit_section_(PsiBuilder builder2, int level, PsiBuilder.Marker marker, boolean result2, boolean pinned, @Nullable Parser eatMore) {
        GeneratedParserUtilBase.exit_section_(builder2, level, marker, null, result2, pinned, eatMore);
    }

    public static void exit_section_(PsiBuilder builder2, int level, PsiBuilder.Marker marker, @Nullable IElementType elementType, boolean result2, boolean pinned, @Nullable Parser eatMore) {
        ErrorState state = ErrorState.get(builder2);
        Frame frame = state.currentFrame;
        Frame frame2 = state.currentFrame = frame == null ? null : frame.parentFrame;
        if (frame != null && frame.elementType != null) {
            elementType = frame.elementType;
        }
        if (frame == null || level != frame.level) {
            LOG.error("Unbalanced error section: got " + frame + ", expected level " + level);
            if (frame != null) {
                state.FRAMES.recycle((Object)frame);
            }
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, elementType, result2);
            return;
        }
        GeneratedParserUtilBase.close_frame_impl_(state, frame, builder2, marker, elementType, result2, pinned);
        GeneratedParserUtilBase.exit_section_impl_(state, frame, builder2, elementType, result2, pinned, eatMore);
        GeneratedParserUtilBase.run_hooks_impl_(builder2, state, (IElementType)(pinned || result2 ? elementType : null));
        state.FRAMES.recycle((Object)frame);
        --state.level;
    }

    public static <T> void register_hook_(PsiBuilder builder2, Hook<T> hook, T param) {
        ErrorState state = ErrorState.get(builder2);
        state.hooks = Hooks.concat(hook, param, state.level, state.hooks);
    }

    @SafeVarargs
    public static <T> void register_hook_(PsiBuilder builder2, Hook<T[]> hook, T ... param) {
        ErrorState state = ErrorState.get(builder2);
        state.hooks = Hooks.concat(hook, param, state.level, state.hooks);
    }

    private static void run_hooks_impl_(PsiBuilder builder2, ErrorState state, @Nullable IElementType elementType) {
        PsiBuilder.Marker marker;
        if (state.hooks == null) {
            return;
        }
        PsiBuilder.Marker marker2 = marker = elementType == null ? null : (PsiBuilder.Marker)builder2.getLatestDoneMarker();
        if (elementType != null && marker == null) {
            builder2.mark().error("No expected done marker at offset " + builder2.getCurrentOffset());
        }
        while (state.hooks != null && state.hooks.level >= state.level) {
            if (state.hooks.level == state.level) {
                marker = state.hooks.hook.run(builder2, marker, state.hooks.param);
            }
            state.hooks = state.hooks.next;
        }
    }

    private static void exit_section_impl_(ErrorState state, Frame frame, PsiBuilder builder2, @Nullable IElementType elementType, boolean result2, boolean pinned, @Nullable Parser eatMore) {
        int lastErrorPos;
        int initialPos = builder2.rawTokenIndex();
        GeneratedParserUtilBase.replace_variants_with_name_(state, frame, builder2, elementType, result2, pinned);
        int n = lastErrorPos = frame.lastVariantAt < 0 ? initialPos : frame.lastVariantAt;
        if (!state.suppressErrors && eatMore != null) {
            boolean errorReported;
            state.suppressErrors = true;
            boolean eatMoreFlagOnce = !builder2.eof() && eatMore.parse(builder2, frame.level + 1);
            boolean eatMoreFlag = eatMoreFlagOnce || !result2 && frame.position == initialPos && lastErrorPos > frame.position;
            PsiBuilderImpl.ProductionMarker latestDoneMarker = !(!pinned && !result2 || !state.altMode && elementType == null || !eatMoreFlagOnce) ? GeneratedParserUtilBase.getLatestExtensibleDoneMarker(builder2) : null;
            int parenCount = 0;
            while ((eatMoreFlag || parenCount > 0) && builder2.rawTokenIndex() < lastErrorPos) {
                IElementType tokenType = builder2.getTokenType();
                if (state.braces != null) {
                    if (tokenType == state.braces[0].getLeftBraceType()) {
                        ++parenCount;
                    } else if (tokenType == state.braces[0].getRightBraceType()) {
                        --parenCount;
                    }
                }
                if (builder2.rawTokenIndex() >= lastErrorPos) break;
                state.tokenAdvancer.parse(builder2, frame.level + 1);
                eatMoreFlag = eatMore.parse(builder2, frame.level + 1);
            }
            boolean bl = errorReported = frame.errorReportedAt == initialPos || !result2 && frame.errorReportedAt >= frame.position;
            if (errorReported || eatMoreFlag) {
                if (!errorReported) {
                    errorReported = GeneratedParserUtilBase.reportError(builder2, state, frame, false, true, true);
                } else if (eatMoreFlag) {
                    state.tokenAdvancer.parse(builder2, frame.level + 1);
                }
                if (eatMore.parse(builder2, frame.level + 1)) {
                    GeneratedParserUtilBase.parseAsTree(state, builder2, frame.level + 1, DUMMY_BLOCK, true, state.tokenAdvancer, eatMore);
                }
            } else if (eatMoreFlagOnce || !result2 && frame.position != builder2.rawTokenIndex() || frame.errorReportedAt > initialPos) {
                errorReported = GeneratedParserUtilBase.reportError(builder2, state, frame, false, true, false);
            } else if (!result2 && pinned && frame.errorReportedAt < 0) {
                errorReported = GeneratedParserUtilBase.reportError(builder2, state, frame, elementType != null, false, false);
            }
            if (latestDoneMarker != null && frame.position >= latestDoneMarker.getStartIndex() && frame.position <= latestDoneMarker.getEndIndex()) {
                GeneratedParserUtilBase.extend_marker_impl((PsiBuilder.Marker)latestDoneMarker);
            }
            state.suppressErrors = false;
            if (errorReported || result2) {
                state.clearVariants(true, 0);
                state.clearVariants(false, 0);
                frame.lastVariantAt = -1;
                Frame f = frame;
                while (f != null && f.variantCount > 0) {
                    f.variantCount = 0;
                    f = f.parentFrame;
                }
            }
        } else if (!result2 && pinned && frame.errorReportedAt < 0) {
            if (lastErrorPos == initialPos) {
                GeneratedParserUtilBase.reportError(builder2, state, frame, elementType != null, false, false);
            } else if (lastErrorPos > initialPos) {
                frame.errorReportedAt = lastErrorPos;
            }
        }
        if (state.currentFrame != null) {
            if (state.currentFrame.errorReportedAt < frame.errorReportedAt) {
                state.currentFrame.errorReportedAt = frame.errorReportedAt;
            }
            if (state.currentFrame.lastVariantAt < frame.lastVariantAt) {
                state.currentFrame.lastVariantAt = frame.lastVariantAt;
            }
        }
    }

    private static void close_frame_impl_(ErrorState state, Frame frame, PsiBuilder builder2, PsiBuilder.Marker marker, IElementType elementType, boolean result2, boolean pinned) {
        if ((frame.modifiers & 8 | frame.modifiers & 0x10) != 0) {
            boolean resetLastPos = !state.suppressErrors && frame.lastVariantAt < 0 && frame.position < builder2.rawTokenIndex();
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
            --state.predicateCount;
            if ((frame.modifiers & 0x10) != 0) {
                state.predicateSign = !state.predicateSign;
            }
            PsiBuilder.Marker marker2 = marker = elementType != null && marker != null && (result2 || pinned) ? builder2.mark() : null;
            if (resetLastPos) {
                frame.lastVariantAt = builder2.rawTokenIndex();
            }
        }
        if (elementType != null && marker != null) {
            if (result2 || pinned) {
                PsiBuilderImpl.ProductionMarker last;
                if ((frame.modifiers & 1) != 0 && (last = (PsiBuilderImpl.ProductionMarker)builder2.getLatestDoneMarker()) != null && last.getStartIndex() == frame.position && state.typeExtends(last.getTokenType(), elementType) && GeneratedParserUtilBase.wasAutoSkipped(builder2, builder2.rawTokenIndex() - last.getEndIndex())) {
                    elementType = last.getTokenType();
                    ((PsiBuilder.Marker)last).drop();
                }
                if ((frame.modifiers & 0x20) != 0) {
                    marker.drop();
                    Frame f = frame.parentFrame;
                    while (f != null) {
                        if (f.elementType != null) {
                            f.elementType = elementType;
                            break;
                        }
                        f = f.parentFrame;
                    }
                } else if ((frame.modifiers & 4) != 0 && frame.leftMarker != null) {
                    marker.done(elementType);
                    GeneratedParserUtilBase.extend_marker_impl(frame.leftMarker);
                } else if ((frame.modifiers & 2) != 0 && frame.leftMarker != null) {
                    marker.drop();
                    frame.leftMarker.precede().done(elementType);
                } else {
                    if (frame.level == 0) {
                        builder2.eof();
                    }
                    marker.done(elementType);
                }
            } else {
                GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
            }
        } else if (result2 || pinned) {
            if (marker != null) {
                marker.drop();
            }
            if ((frame.modifiers & 4) != 0 && frame.leftMarker != null) {
                GeneratedParserUtilBase.extend_marker_impl(frame.leftMarker);
            }
        } else {
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
        }
    }

    private static void extend_marker_impl(PsiBuilder.Marker marker) {
        PsiBuilder.Marker precede = marker.precede();
        IElementType elementType = ((LighterASTNode)marker).getTokenType();
        if (elementType == TokenType.ERROR_ELEMENT) {
            precede.error(StringUtil.notNullize((String)PsiBuilderImpl.getErrorMessage((LighterASTNode)marker)));
        } else {
            precede.done(elementType);
        }
        marker.drop();
    }

    private static void close_marker_impl_(Frame frame, PsiBuilder.Marker marker, IElementType elementType, boolean result2) {
        if (marker == null) {
            return;
        }
        if (result2) {
            if (elementType != null) {
                marker.done(elementType);
            } else {
                marker.drop();
            }
        } else {
            int position;
            if (frame != null && frame.errorReportedAt > (position = ((PsiBuilderImpl.ProductionMarker)marker).getStartIndex())) {
                frame.errorReportedAt = frame.parentFrame == null ? -1 : frame.parentFrame.errorReportedAt;
            }
            marker.rollbackTo();
        }
    }

    private static void replace_variants_with_name_(ErrorState state, Frame frame, PsiBuilder builder2, IElementType elementType, boolean result2, boolean pinned) {
        boolean willFail;
        int initialPos = builder2.rawTokenIndex();
        boolean bl = willFail = !result2 && !pinned;
        if (willFail && initialPos == frame.position && frame.lastVariantAt == frame.position && frame.name != null && state.variants.size() >= frame.variantCount + (elementType == null ? 0 : 2)) {
            state.clearVariants(true, frame.variantCount);
            GeneratedParserUtilBase.addVariantInner(state, frame, initialPos, frame.name);
        }
    }

    public static boolean report_error_(PsiBuilder builder2, boolean result2) {
        if (!result2) {
            GeneratedParserUtilBase.report_error_(builder2, ErrorState.get(builder2), false);
        }
        return result2;
    }

    public static void report_error_(PsiBuilder builder2, ErrorState state, boolean advance) {
        Frame frame = state.currentFrame;
        if (frame == null) {
            LOG.error("unbalanced enter/exit section call: got null");
            return;
        }
        int position = builder2.rawTokenIndex();
        if (frame.errorReportedAt < position && frame.lastVariantAt > -1 && frame.lastVariantAt <= position) {
            GeneratedParserUtilBase.reportError(builder2, state, frame, false, true, advance);
        }
    }

    @Nullable
    private static PsiBuilderImpl.ProductionMarker getLatestExtensibleDoneMarker(@NotNull PsiBuilder builder2) {
        PsiBuilderImpl.ProductionMarker marker;
        if (builder2 == null) {
            GeneratedParserUtilBase.$$$reportNull$$$0(4);
        }
        return (marker = (PsiBuilderImpl.ProductionMarker)ContainerUtil.getLastItem(((Builder)builder2).getProductions())) == null || marker.getTokenType() == null || !(marker instanceof PsiBuilder.Marker) ? null : marker;
    }

    private static boolean reportError(PsiBuilder builder2, ErrorState state, Frame frame, boolean inner, boolean force, boolean advance) {
        boolean empty;
        int position = builder2.rawTokenIndex();
        StringBuilder sb = new StringBuilder();
        state.appendExpected(sb, position, true);
        boolean bl = empty = sb.length() == 0;
        if (!force && empty && !advance) {
            return false;
        }
        String actual = StringUtil.trim((String)builder2.getTokenText());
        if (StringUtil.isEmpty((String)actual)) {
            sb.append(empty ? "unmatched input" : " expected");
        } else {
            if (!empty) {
                sb.append(" expected, got ");
            }
            sb.append("'").append(StringUtil.first((String)actual, (int)20, (boolean)true)).append("'");
            if (empty) {
                sb.append(" unexpected");
            }
        }
        String message = sb.toString();
        if (advance) {
            PsiBuilder.Marker mark = builder2.mark();
            state.tokenAdvancer.parse(builder2, frame.level + 1);
            mark.error(message);
        } else if (inner) {
            PsiBuilderImpl.ProductionMarker latestDoneMarker = GeneratedParserUtilBase.getLatestExtensibleDoneMarker(builder2);
            builder2.error(message);
            if (latestDoneMarker != null && frame.position >= latestDoneMarker.getStartIndex() && frame.position <= latestDoneMarker.getEndIndex()) {
                GeneratedParserUtilBase.extend_marker_impl((PsiBuilder.Marker)latestDoneMarker);
            }
        } else {
            builder2.error(message);
        }
        builder2.eof();
        frame.errorReportedAt = builder2.rawTokenIndex();
        return true;
    }

    private static void reportFrameError(PsiBuilder builder2, ErrorState state) {
        if (state.currentFrame == null || state.suppressErrors) {
            return;
        }
        Frame frame = state.currentFrame;
        int pos = builder2.rawTokenIndex();
        if (frame.errorReportedAt > pos) {
            int endOffset;
            LighterASTNode marker = builder2.getLatestDoneMarker();
            int n = endOffset = marker != null ? ((PsiBuilderImpl.ProductionMarker)marker).getEndIndex() : pos + 1;
            while (endOffset <= pos && GeneratedParserUtilBase.isWhitespaceOrComment(builder2, builder2.rawLookup(endOffset - pos))) {
                ++endOffset;
            }
            boolean inner = endOffset == pos;
            builder2.eof();
            GeneratedParserUtilBase.reportError(builder2, state, frame, inner, true, false);
        }
    }

    public static PsiBuilder adapt_builder_(IElementType root, PsiBuilder builder2, PsiParser parser) {
        return GeneratedParserUtilBase.adapt_builder_(root, builder2, parser, null);
    }

    public static PsiBuilder adapt_builder_(IElementType root, PsiBuilder builder2, PsiParser parser, TokenSet[] extendsSets) {
        ErrorState state = new ErrorState();
        ErrorState.initState(state, builder2, root, extendsSets);
        return new Builder(builder2, state, parser);
    }

    private static void checkSiblings(IElementType chunkType, ArrayDeque<Pair<PsiBuilder.Marker, PsiBuilder.Marker>> parens, ArrayDeque<Pair<PsiBuilder.Marker, Integer>> siblings2) {
        block0: while (!siblings2.isEmpty()) {
            Pair<PsiBuilder.Marker, PsiBuilder.Marker> parenPair = parens.peek();
            int rating = (Integer)siblings2.getFirst().second;
            int count = 0;
            for (Pair<PsiBuilder.Marker, Integer> pair : siblings2) {
                if ((Integer)pair.second != rating || parenPair != null && pair.first == parenPair.second) break block0;
                if (++count < 10) continue;
                PsiBuilder.Marker parentMarker = ((PsiBuilder.Marker)pair.first).precede();
                parentMarker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
                while (count-- > 0) {
                    siblings2.removeFirst();
                }
                parentMarker.done(chunkType);
                siblings2.addFirst((Pair<PsiBuilder.Marker, Integer>)Pair.create((Object)parentMarker, (Object)(rating + 1)));
                continue block0;
            }
        }
    }

    public static boolean parseAsTree(ErrorState state, PsiBuilder builder2, int level, IElementType chunkType, boolean checkBraces, Parser parser, Parser eatMoreCondition) {
        ArrayDeque<Pair<PsiBuilder.Marker, PsiBuilder.Marker>> parens = new ArrayDeque<Pair<PsiBuilder.Marker, PsiBuilder.Marker>>(4);
        ArrayDeque<Pair<PsiBuilder.Marker, Integer>> siblings2 = new ArrayDeque<Pair<PsiBuilder.Marker, Integer>>();
        PsiBuilder.Marker marker = null;
        IElementType lBrace = checkBraces && state.braces != null && state.braces.length > 0 ? state.braces[0].getLeftBraceType() : null;
        IElementType rBrace = lBrace != null ? state.braces[0].getRightBraceType() : null;
        int totalCount = 0;
        int tokenCount = 0;
        if (lBrace != null) {
            LighterASTNode doneMarker;
            int tokenIdx = -1;
            while (builder2.rawLookup(tokenIdx) == TokenType.WHITE_SPACE) {
                --tokenIdx;
            }
            LighterASTNode lighterASTNode = doneMarker = builder2.rawLookup(tokenIdx) == lBrace ? builder2.getLatestDoneMarker() : null;
            if (doneMarker != null && doneMarker.getStartOffset() == builder2.rawTokenTypeStart(tokenIdx) && doneMarker.getTokenType() == TokenType.ERROR_ELEMENT) {
                parens.add((Pair<PsiBuilder.Marker, PsiBuilder.Marker>)Pair.create((Object)((PsiBuilder.Marker)doneMarker).precede(), null));
            }
        }
        int c2 = GeneratedParserUtilBase.current_position_(builder2);
        while (true) {
            IElementType tokenType = builder2.getTokenType();
            if (lBrace != null && (tokenType == lBrace || tokenType == rBrace && !parens.isEmpty())) {
                if (marker != null) {
                    marker.done(chunkType);
                    siblings2.addFirst((Pair<PsiBuilder.Marker, Integer>)Pair.create((Object)marker, (Object)1));
                    marker = null;
                    tokenCount = 0;
                }
                if (tokenType == lBrace) {
                    Pair prev = (Pair)siblings2.peek();
                    parens.addFirst((Pair<PsiBuilder.Marker, PsiBuilder.Marker>)Pair.create((Object)builder2.mark(), (Object)Pair.getFirst((Pair)prev)));
                }
                GeneratedParserUtilBase.checkSiblings(chunkType, parens, siblings2);
                state.tokenAdvancer.parse(builder2, level);
                if (tokenType == rBrace) {
                    Pair<PsiBuilder.Marker, PsiBuilder.Marker> pair = parens.removeFirst();
                    ((PsiBuilder.Marker)pair.first).done(chunkType);
                    while (!siblings2.isEmpty() && siblings2.getFirst().first != pair.second) {
                        siblings2.removeFirst();
                    }
                    siblings2.addFirst((Pair<PsiBuilder.Marker, Integer>)Pair.create((Object)pair.first, (Object)1));
                    GeneratedParserUtilBase.checkSiblings(chunkType, parens, siblings2);
                }
            } else {
                boolean result2;
                if (marker == null) {
                    marker = builder2.mark();
                    marker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
                }
                boolean bl = result2 = (!parens.isEmpty() || eatMoreCondition.parse(builder2, level + 1)) && parser.parse(builder2, level + 1);
                if (!result2) break;
                ++tokenCount;
                ++totalCount;
            }
            if (tokenCount >= 10) {
                marker.done(chunkType);
                siblings2.addFirst((Pair<PsiBuilder.Marker, Integer>)Pair.create((Object)marker, (Object)1));
                GeneratedParserUtilBase.checkSiblings(chunkType, parens, siblings2);
                marker = null;
                tokenCount = 0;
            }
            if (!GeneratedParserUtilBase.empty_element_parsed_guard_(builder2, "parseAsTree", c2)) break;
            c2 = GeneratedParserUtilBase.current_position_(builder2);
        }
        if (marker != null) {
            marker.drop();
        }
        for (Pair<PsiBuilder.Marker, PsiBuilder.Marker> pair : parens) {
            ((PsiBuilder.Marker)pair.first).drop();
        }
        return totalCount != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionState";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/parser/GeneratedParserUtilBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionVariant";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhitespaceOrComment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "wasAutoSkipped";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLatestExtensibleDoneMarker";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyList<E>
    extends ArrayList<E> {
        MyList(int initialCapacity) {
            super(initialCapacity);
        }

        protected void setSize(int fromIndex) {
            this.removeRange(fromIndex, this.size());
        }

        @Override
        public boolean add(E e) {
            int size = this.size();
            if (size >= 10000) {
                this.removeRange(2500, size - 2500);
            }
            return super.add(e);
        }
    }

    public static class DummyBlock
    extends CompositePsiElement {
        DummyBlock() {
            super(DUMMY_BLOCK);
        }

        @Override
        @NotNull
        public PsiReference[] getReferences() {
            if (PsiReference.EMPTY_ARRAY == null) {
                DummyBlock.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public Language getLanguage() {
            Language language = this.getParent().getLanguage();
            if (language == null) {
                DummyBlock.$$$reportNull$$$0(1);
            }
            return language;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/parser/GeneratedParserUtilBase$DummyBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferences";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class DummyBlockElementType
    extends IElementType
    implements ICompositeElementType {
        DummyBlockElementType() {
            super("DUMMY_BLOCK", Language.ANY);
        }

        @NotNull
        public ASTNode createCompositeNode() {
            DummyBlock dummyBlock = new DummyBlock();
            if (dummyBlock == null) {
                DummyBlockElementType.$$$reportNull$$$0(0);
            }
            return dummyBlock;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/parser/GeneratedParserUtilBase$DummyBlockElementType", "createCompositeNode"));
        }
    }

    private static class Hooks<T> {
        final Hook<T> hook;
        final T param;
        final int level;
        final Hooks<?> next;

        Hooks(Hook<T> hook, T param, int level, Hooks next) {
            this.hook = hook;
            this.param = param;
            this.level = level;
            this.next = next;
        }

        static <E> Hooks<E> concat(Hook<E> hook, E param, int level, Hooks<?> hooks) {
            return new Hooks<E>(hook, param, level, hooks);
        }
    }

    private static class Variant {
        int position;
        Object object;

        private Variant() {
        }

        public Variant init(int pos, Object o) {
            this.position = pos;
            this.object = o;
            return this;
        }

        public String toString() {
            return "<" + this.position + ", " + this.object + ">";
        }
    }

    public static class Frame {
        public Frame parentFrame;
        public IElementType elementType;
        public int offset;
        public int position;
        public int level;
        public int modifiers;
        public String name;
        public int variantCount;
        public int errorReportedAt;
        public int lastVariantAt;
        public PsiBuilder.Marker leftMarker;

        public Frame init(PsiBuilder builder2, ErrorState state, int level_, int modifiers_, IElementType elementType_, String name_) {
            this.parentFrame = state.currentFrame;
            this.elementType = elementType_;
            this.offset = builder2.getCurrentOffset();
            this.position = builder2.rawTokenIndex();
            this.level = level_;
            this.modifiers = modifiers_;
            this.name = name_;
            this.variantCount = state.variants.size();
            this.errorReportedAt = -1;
            this.lastVariantAt = -1;
            this.leftMarker = null;
            return this;
        }

        public String toString() {
            String mod = this.modifiers == 0 ? "_NONE_, " : ((this.modifiers & 1) != 0 ? "_CAN_COLLAPSE_, " : "") + ((this.modifiers & 2) != 0 ? "_LEFT_, " : "") + ((this.modifiers & 4) != 0 ? "_LEFT_INNER_, " : "") + ((this.modifiers & 8) != 0 ? "_AND_, " : "") + ((this.modifiers & 0x10) != 0 ? "_NOT_, " : "") + ((this.modifiers & 0x20) != 0 ? "_UPPER_, " : "");
            return String.format("{%s:%s:%d, %d, %s%s, %s}", this.offset, this.position, this.level, this.errorReportedAt, mod, this.elementType, this.name);
        }
    }

    public static class ErrorState {
        public Frame currentFrame;
        public CompletionState completionState;
        MyList<Variant> variants = new MyList(1000);
        MyList<Variant> unexpected = new MyList(100);
        int predicateCount;
        int level;
        boolean predicateSign = true;
        boolean suppressErrors;
        Hooks<?> hooks;
        TokenSet[] extendsSets;
        public PairProcessor<IElementType, IElementType> altExtendsChecker;
        private boolean caseSensitive;
        public BracePair[] braces;
        public Parser tokenAdvancer = TOKEN_ADVANCER;
        public boolean altMode;
        final LimitedPool<Variant> VARIANTS = new LimitedPool(10000, () -> new Variant());
        final LimitedPool<Frame> FRAMES = new LimitedPool(500, () -> new Frame());

        public static ErrorState get(PsiBuilder builder2) {
            return ((Builder)builder2).state;
        }

        public static void initState(ErrorState state, PsiBuilder builder2, IElementType root, TokenSet[] extendsSets) {
            state.extendsSets = extendsSets;
            PsiFile file2 = (PsiFile)builder2.getUserData(FileContextUtil.CONTAINING_FILE_KEY);
            state.completionState = file2 == null ? null : (CompletionState)file2.getUserData(COMPLETION_STATE_KEY);
            Language language = file2 == null ? root.getLanguage() : file2.getLanguage();
            state.caseSensitive = language.isCaseSensitive();
            PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(language);
            BracePair[] bracePairArray = state.braces = matcher == null ? null : matcher.getPairs();
            if (state.braces != null && state.braces.length == 0) {
                state.braces = null;
            }
        }

        public void appendExpected(@NotNull StringBuilder sb, int position, boolean expected) {
            if (sb == null) {
                ErrorState.$$$reportNull$$$0(0);
            }
            MyList<Variant> list2 = expected ? this.variants : this.unexpected;
            Object[] strings = new String[list2.size()];
            long[] hashes = new long[strings.length];
            Arrays.fill(strings, "");
            int count = 0;
            block0: for (Variant variant : list2) {
                if (position != variant.position) continue;
                String text2 = String.valueOf(variant.object);
                long hash = StringHash.calc((String)text2);
                for (int i = 0; i < count; ++i) {
                    if (hashes[i] == hash) continue block0;
                }
                hashes[count] = hash;
                strings[count] = text2;
                ++count;
            }
            Arrays.sort(strings);
            count = 0;
            for (Object s : strings) {
                char c2;
                if (((String)s).length() == 0) continue;
                if (count++ > 0) {
                    if (count > 50) {
                        sb.append(" and ...");
                        break;
                    }
                    sb.append(", ");
                }
                Object displayText = (c2 = ((String)s).charAt(0)) == '<' || StringUtil.isJavaIdentifierStart((char)c2) ? s : '\'' + (String)s + '\'';
                sb.append((String)displayText);
            }
            if (count > 1 && count < 50) {
                int idx = sb.lastIndexOf(", ");
                sb.replace(idx, idx + 1, " or");
            }
        }

        public void clearVariants(Frame frame) {
            this.clearVariants(true, frame == null ? 0 : frame.variantCount);
            if (frame != null) {
                frame.lastVariantAt = -1;
            }
        }

        void clearVariants(boolean expected, int start2) {
            MyList<Variant> list2;
            MyList<Variant> myList = list2 = expected ? this.variants : this.unexpected;
            if (start2 < 0 || start2 >= list2.size()) {
                return;
            }
            int len = list2.size();
            for (int i = start2; i < len; ++i) {
                this.VARIANTS.recycle(list2.get(i));
            }
            list2.setSize(start2);
        }

        public boolean typeExtends(IElementType child2, IElementType parent) {
            if (child2 == parent) {
                return true;
            }
            if (this.extendsSets != null) {
                for (TokenSet set : this.extendsSets) {
                    if (!set.contains(child2) || !set.contains(parent)) continue;
                    return true;
                }
            }
            return this.altExtendsChecker != null && this.altExtendsChecker.process((Object)child2, (Object)parent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/lang/parser/GeneratedParserUtilBase$ErrorState", "appendExpected"));
        }
    }

    public static class Builder
    extends PsiBuilderAdapter {
        public final ErrorState state;
        public final PsiParser parser;

        public Builder(PsiBuilder builder2, ErrorState state_, PsiParser parser_) {
            super(builder2);
            this.state = state_;
            this.parser = parser_;
        }

        public Lexer getLexer() {
            return ((PsiBuilderImpl)this.myDelegate).getLexer();
        }

        @Nullable
        public List<PsiBuilderImpl.ProductionMarker> getProductions() {
            return ((PsiBuilderImpl)this.myDelegate).getProductions();
        }
    }

    public static class CompletionState
    implements Function<Object, String> {
        public final int offset;
        public final Collection<String> items = new THashSet();

        public CompletionState(int offset_) {
            this.offset = offset_;
        }

        @Nullable
        public String convertItem(Object o) {
            return o instanceof Object[] ? StringUtil.join((Object[])((Object[])o), (Function)this, (String)" ") : o.toString();
        }

        public String fun(Object o) {
            return this.convertItem(o);
        }

        public void addItem(@NotNull PsiBuilder builder2, @NotNull String text2) {
            if (builder2 == null) {
                CompletionState.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                CompletionState.$$$reportNull$$$0(1);
            }
            this.items.add(text2);
        }

        public boolean prefixMatches(@NotNull PsiBuilder builder2, @NotNull String text2) {
            if (builder2 == null) {
                CompletionState.$$$reportNull$$$0(2);
            }
            if (text2 == null) {
                CompletionState.$$$reportNull$$$0(3);
            }
            int builderOffset = builder2.getCurrentOffset();
            int diff = this.offset - builderOffset;
            int length = text2.length();
            if (diff == 0) {
                return true;
            }
            if (diff > 0 && diff <= length) {
                CharSequence fragment = builder2.getOriginalText().subSequence(builderOffset, this.offset);
                return this.prefixMatches(fragment.toString(), text2);
            }
            if (diff < 0) {
                int i = -1;
                while (true) {
                    IElementType type = builder2.rawLookup(i);
                    int tokenStart = builder2.rawTokenTypeStart(i);
                    if (!GeneratedParserUtilBase.isWhitespaceOrComment(builder2, type)) {
                        CharSequence fragment;
                        if (type == null || tokenStart >= this.offset || !this.prefixMatches((fragment = builder2.getOriginalText().subSequence(tokenStart, this.offset)).toString(), text2)) break;
                        diff = this.offset - tokenStart;
                        break;
                    }
                    diff = this.offset - tokenStart;
                    --i;
                }
                return diff >= 0 && diff < length;
            }
            return false;
        }

        public boolean prefixMatches(@NotNull String prefix, @NotNull String variant) {
            boolean matches;
            if (prefix == null) {
                CompletionState.$$$reportNull$$$0(4);
            }
            if (variant == null) {
                CompletionState.$$$reportNull$$$0(5);
            }
            if ((matches = new CamelHumpMatcher(prefix, false).prefixMatches(variant.replace(' ', '_'))) && StringUtil.isWhiteSpace((char)prefix.charAt(prefix.length() - 1))) {
                return StringUtil.startsWithIgnoreCase((String)variant, (String)prefix);
            }
            return matches;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/parser/GeneratedParserUtilBase$CompletionState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addItem";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prefixMatches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Hook<T> {
        @Contract(value="_,null,_->null")
        public PsiBuilder.Marker run(PsiBuilder var1, PsiBuilder.Marker var2, T var3);
    }

    public static interface Parser {
        public boolean parse(PsiBuilder var1, int var2);
    }
}

