/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.ClickListener;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;

public class MnemonicChooser
extends JPanel {
    private static final Color OCCUPIED_CELL_COLOR = new JBColor(16448139, 6770995);
    private static final Color FREE_CELL_COLOR = new JBColor(LightColors.SLIGHTLY_GRAY, (Color)Gray._80);

    public MnemonicChooser() {
        super((LayoutManager)new VerticalFlowLayout());
        NonOpaquePanel numbers = new NonOpaquePanel((LayoutManager)new GridLayout(2, 5, 2, 2));
        for (char i = '1'; i <= '9'; i = (char)(i + '\u0001')) {
            numbers.add(new MnemonicLabel(i));
        }
        numbers.add(new MnemonicLabel('0'));
        NonOpaquePanel letters = new NonOpaquePanel((LayoutManager)new GridLayout(5, 6, 2, 2));
        for (char c2 = 'A'; c2 <= 'Z'; c2 = (char)(c2 + '\u0001')) {
            letters.add(new MnemonicLabel(c2));
        }
        this.add((Component)numbers);
        this.add(new JSeparator());
        this.add((Component)letters);
        this.setBackground(UIUtil.getListBackground());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                char typed;
                if (e.getKeyCode() == 27) {
                    MnemonicChooser.this.onCancelled();
                } else if (e.getModifiersEx() == 0 && ((typed = Character.toUpperCase(e.getKeyChar())) >= '0' && typed <= '9' || typed >= 'A' && typed <= 'Z')) {
                    MnemonicChooser.this.onMnemonicChosen(typed);
                }
            }
        });
        this.setFocusable(true);
    }

    protected boolean isOccupied(char c2) {
        return false;
    }

    protected void onMnemonicChosen(char c2) {
    }

    protected void onCancelled() {
    }

    private Color backgroundForMnemonic(char c2) {
        return this.isOccupied(c2) ? OCCUPIED_CELL_COLOR : FREE_CELL_COLOR;
    }

    private class MnemonicLabel
    extends JLabel {
        private MnemonicLabel(final char c2) {
            this.setOpaque(true);
            this.setText(Character.toString(c2));
            this.setBorder(JBUI.Borders.customLine((Color)new JBColor((Color)Gray._192, (Color)Gray._150)));
            this.setHorizontalAlignment(0);
            this.setBackground(MnemonicChooser.this.backgroundForMnemonic(c2));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    MnemonicLabel.this.setForeground(UIUtil.getListSelectionForeground());
                    MnemonicLabel.this.setBackground(UIUtil.getListSelectionBackground());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    MnemonicLabel.this.setForeground(UIUtil.getListForeground());
                    MnemonicLabel.this.setBackground(MnemonicChooser.this.backgroundForMnemonic(c2));
                }
            });
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    MnemonicChooser.this.onMnemonicChosen(c2);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/bookmarks/actions/MnemonicChooser$MnemonicLabel$2", "onClick"));
                }
            }.installOn((Component)this);
        }
    }
}

