/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CantRunException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptFileUtil {
    private static final Logger LOG = Logger.getInstance(ScriptFileUtil.class);
    private static final String SCHEME = "mem://";
    private static final Map<String, VirtualFile> ourFilesMap = ContainerUtil.createConcurrentWeakValueMap();
    private static final AtomicLong ourFileCounter = new AtomicLong();

    private ScriptFileUtil() {
    }

    public static boolean isMemoryScriptPath(@Nullable String url) {
        return url != null && url.startsWith(SCHEME);
    }

    public static String getScriptFilePath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ScriptFileUtil.$$$reportNull$$$0(0);
        }
        if (file2.isInLocalFileSystem()) {
            return file2.getPath();
        }
        long id = ourFileCounter.incrementAndGet();
        String url = SCHEME + id + "/" + file2.getName();
        ourFilesMap.put(url, file2);
        return url;
    }

    @Nullable
    public static VirtualFile findScriptFileByPath(@Nullable String path) {
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        if (!path.startsWith(SCHEME)) {
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return ourFilesMap.get(path);
    }

    @NotNull
    public static String getLocalFilePath(@NotNull String scriptPath) throws CantRunException {
        if (scriptPath == null) {
            ScriptFileUtil.$$$reportNull$$$0(1);
        }
        if (ScriptFileUtil.isMemoryScriptPath(scriptPath)) {
            File tmpFile = ScriptFileUtil.copyToTempFile(scriptPath);
            String string = tmpFile.getAbsolutePath();
            if (string == null) {
                ScriptFileUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = scriptPath;
        if (string == null) {
            ScriptFileUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static File copyToTempFile(@NotNull String path) throws CantRunException {
        File file2;
        File ioFile;
        VirtualFile virtualFile;
        if (path == null) {
            ScriptFileUtil.$$$reportNull$$$0(4);
        }
        if ((virtualFile = ScriptFileUtil.findScriptFileByPath(path)) == null) {
            throw new CantRunException("File not found: " + path);
        }
        try {
            ioFile = FileUtil.createTempFile((String)virtualFile.getName(), (String)"", (boolean)true);
        }
        catch (IOException e) {
            throw new CantRunException("Cannot create temporary file " + virtualFile.getName(), (Throwable)e);
        }
        try {
            ScriptFileUtil.copyFile(virtualFile, ioFile);
            file2 = ioFile;
        }
        catch (IOException e) {
            throw new CantRunException("Cannot write temp file " + virtualFile.getPath() + " to " + ioFile.getAbsolutePath(), (Throwable)e);
        }
        if (file2 == null) {
            ScriptFileUtil.$$$reportNull$$$0(5);
        }
        return file2;
    }

    private static void copyFile(@NotNull VirtualFile srcFile, @NotNull File destFile) throws IOException {
        if (srcFile == null) {
            ScriptFileUtil.$$$reportNull$$$0(6);
        }
        if (destFile == null) {
            ScriptFileUtil.$$$reportNull$$$0(7);
        }
        LOG.info("Copying to " + destFile.getPath());
        CharSequence content2 = ScriptFileUtil.getContent(srcFile);
        CharBuffer cb = CharBuffer.wrap(content2);
        ByteBuffer bb = StandardCharsets.UTF_8.encode(cb);
        byte[] result2 = new byte[bb.remaining()];
        bb.get(result2);
        FileUtil.writeToFile((File)destFile, (byte[])result2, (boolean)false);
    }

    @NotNull
    private static CharSequence getContent(@NotNull VirtualFile file2) {
        Document document;
        if (file2 == null) {
            ScriptFileUtil.$$$reportNull$$$0(8);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file2)) != null) {
            String string = document.getText();
            if (string == null) {
                ScriptFileUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        CharSequence charSequence = LoadTextUtil.loadText(file2);
        if (charSequence == null) {
            ScriptFileUtil.$$$reportNull$$$0(10);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/util/ScriptFileUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/util/ScriptFileUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFilePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToTempFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScriptFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFilePath";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyToTempFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

