/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewActionProvider;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.execution.services.ServiceViewNavBarPanel;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.execution.services.ServiceViewTree;
import com.intellij.execution.services.ServiceViewTreeModel;
import com.intellij.execution.services.ServiceViewUi;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class ServiceTreeView
extends ServiceView {
    private final ServiceViewTree myTree;
    private final ServiceViewTreeModel myTreeModel;
    private final ServiceViewModel.ServiceViewModelListener myListener;
    private final NavBarPanel myNavBarPanel;
    private volatile ServiceModel.ServiceViewItem myLastSelection;
    private boolean mySelected;

    ServiceTreeView(@NotNull Project project, @NotNull ServiceViewModel model2, @NotNull ServiceViewUi ui, @NotNull ServiceViewState state) {
        if (project == null) {
            ServiceTreeView.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            ServiceTreeView.$$$reportNull$$$0(1);
        }
        if (ui == null) {
            ServiceTreeView.$$$reportNull$$$0(2);
        }
        if (state == null) {
            ServiceTreeView.$$$reportNull$$$0(3);
        }
        super(new BorderLayout(), project, model2, ui);
        this.myTreeModel = new ServiceViewTreeModel(model2);
        this.myTree = new ServiceViewTree((TreeModel)((Object)this.myTreeModel), this);
        this.myListener = new MyViewModelListener();
        model2.addModelListener(this.myListener);
        ServiceViewActionProvider actionProvider = ServiceViewActionProvider.getInstance();
        ui.setServiceToolbar(actionProvider);
        ui.setMasterComponent((JComponent)((Object)this.myTree), actionProvider);
        DnDManager.getInstance().registerSource(ServiceViewDragHelper.createSource(this), (JComponent)((Object)this.myTree));
        this.add((Component)this.myUi.getComponent(), "Center");
        this.myTree.addTreeSelectionListener(new RestoreSelectionListener());
        this.myTree.addTreeSelectionListener(e -> this.onSelectionChanged());
        model2.addModelListener(this::rootsChanged);
        Consumer<ServiceModel.ServiceViewItem> selector = item -> this.select(item.getValue(), item.getRootContributor().getClass()).onSuccess(result2 -> AppUIUtil.invokeOnEdt(() -> {
            JComponent component = this.getUi().getDetailsComponent();
            if (component != null) {
                IdeFocusManager.getInstance((Project)this.myProject).requestFocusInProject((Component)component, this.myProject);
            }
        }, this.myProject.getDisposed()));
        this.myNavBarPanel = new ServiceViewNavBarPanel(this.myProject, true, this.getModel(), selector);
        this.myNavBarPanel.getModel().updateModel((Object)null);
        this.myUi.setNavBar(this.myNavBarPanel);
        state.treeState.applyTo((JTree)((Object)this.myTree), this.myTreeModel.getRoot());
    }

    @Override
    public void dispose() {
        this.getModel().removeModelListener(this.myListener);
        super.dispose();
    }

    @Override
    void saveState(@NotNull ServiceViewState state) {
        if (state == null) {
            ServiceTreeView.$$$reportNull$$$0(4);
        }
        super.saveState(state);
        this.myUi.saveState(state);
        state.treeState = TreeState.createOn((JTree)((Object)this.myTree));
    }

    @Override
    @NotNull
    List<ServiceModel.ServiceViewItem> getSelectedItems() {
        int[] rows = this.myTree.getSelectionRows();
        if (rows == null || rows.length == 0) {
            List<ServiceModel.ServiceViewItem> list2 = Collections.emptyList();
            if (list2 == null) {
                ServiceTreeView.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List objects = TreeUtil.collectSelectedUserObjects((JTree)((Object)this.myTree));
        if (objects.size() != rows.length) {
            List list3 = ContainerUtil.mapNotNull((Collection)objects, o -> (ServiceModel.ServiceViewItem)ObjectUtils.tryCast((Object)o, ServiceModel.ServiceViewItem.class));
            if (list3 == null) {
                ServiceTreeView.$$$reportNull$$$0(6);
            }
            return list3;
        }
        ArrayList<Pair> objectRows = new ArrayList<Pair>();
        for (int i = 0; i < rows.length; ++i) {
            objectRows.add(Pair.create(objects.get(i), (Object)rows[i]));
        }
        Collections.sort(objectRows, Comparator.comparing(pair -> (Integer)pair.second));
        List list4 = ContainerUtil.mapNotNull(objectRows, pair -> (ServiceModel.ServiceViewItem)ObjectUtils.tryCast((Object)pair.first, ServiceModel.ServiceViewItem.class));
        if (list4 == null) {
            ServiceTreeView.$$$reportNull$$$0(7);
        }
        return list4;
    }

    @Override
    Promise<Void> select(@NotNull Object service, @NotNull Class<?> contributorClass) {
        ServiceModel.ServiceViewItem selectedItem;
        if (service == null) {
            ServiceTreeView.$$$reportNull$$$0(8);
        }
        if (contributorClass == null) {
            ServiceTreeView.$$$reportNull$$$0(9);
        }
        if ((selectedItem = this.myLastSelection) == null || !selectedItem.getValue().equals(service)) {
            AsyncPromise result2 = new AsyncPromise();
            this.myTreeModel.findPath(service, contributorClass).onError(arg_0 -> ((AsyncPromise)result2).setError(arg_0)).onSuccess(path -> TreeUtil.promiseSelect((JTree)((Object)this.myTree), (TreeVisitor)new PathSelectionVisitor((TreePath)path)).onError(arg_0 -> ((AsyncPromise)result2).setError(arg_0)).onSuccess(selectedPath -> result2.setResult(null)));
            return result2;
        }
        return Promises.resolvedPromise();
    }

    @Override
    void onViewSelected() {
        this.mySelected = true;
        if (this.myLastSelection != null) {
            ServiceViewDescriptor descriptor2 = this.myLastSelection.getViewDescriptor();
            this.onViewSelected(descriptor2);
            this.myUi.setDetailsComponent(descriptor2.getContentComponent());
        } else {
            this.myUi.setDetailsComponent(null);
        }
    }

    @Override
    void onViewUnselected() {
        this.mySelected = false;
        if (this.myLastSelection != null) {
            this.myLastSelection.getViewDescriptor().onNodeUnselected();
        }
    }

    @Override
    void jumpToServices() {
        if (this.myTree.isShowing()) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocusInProject((Component)((Object)this.myTree), this.myProject);
        } else {
            this.myNavBarPanel.rebuildAndSelectTail(true);
        }
    }

    private void onSelectionChanged() {
        ServiceViewDescriptor newDescriptor;
        ServiceViewDescriptor oldDescriptor;
        List<ServiceModel.ServiceViewItem> selected2 = this.getSelectedItems();
        ServiceModel.ServiceViewItem newSelection = (ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(selected2);
        if (Comparing.equal((Object)newSelection, (Object)this.myLastSelection)) {
            return;
        }
        ServiceViewDescriptor serviceViewDescriptor = oldDescriptor = this.myLastSelection == null ? null : this.myLastSelection.getViewDescriptor();
        if (oldDescriptor != null && this.mySelected) {
            oldDescriptor.onNodeUnselected();
        }
        this.myLastSelection = newSelection;
        this.myNavBarPanel.getModel().updateModel(newSelection);
        if (!this.mySelected) {
            return;
        }
        ServiceViewDescriptor serviceViewDescriptor2 = newDescriptor = newSelection == null ? null : newSelection.getViewDescriptor();
        if (newDescriptor != null) {
            newDescriptor.onNodeSelected();
        }
        this.myUi.setDetailsComponent(newDescriptor == null ? null : newDescriptor.getContentComponent());
    }

    private void rootsChanged() {
        this.updateNavBar();
        ServiceModel.ServiceViewItem lastSelection = this.myLastSelection;
        ServiceModel.ServiceViewItem updatedItem = lastSelection == null ? null : this.getModel().findItem(lastSelection);
        AppUIUtil.invokeOnEdt(() -> {
            ServiceModel.ServiceViewItem item;
            List<ServiceModel.ServiceViewItem> selected2 = this.getSelectedItems();
            if (selected2.isEmpty() && (item = (ServiceModel.ServiceViewItem)ContainerUtil.getFirstItem(this.getModel().getRoots())) != null) {
                this.select(item.getValue(), item.getRootContributor().getClass());
                return;
            }
            ServiceModel.ServiceViewItem newSelection = (ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(selected2);
            if (Comparing.equal((Object)newSelection, (Object)updatedItem)) {
                newSelection = updatedItem;
            }
            if (Comparing.equal((Object)newSelection, (Object)this.myLastSelection)) {
                this.myLastSelection = newSelection;
                if (this.mySelected) {
                    ServiceViewDescriptor descriptor2 = newSelection == null ? null : newSelection.getViewDescriptor();
                    this.myUi.setDetailsComponent(descriptor2 == null ? null : descriptor2.getContentComponent());
                }
            }
        }, this.myProject.getDisposed());
    }

    private void updateNavBar() {
        AsyncPromise itemPromise = new AsyncPromise();
        itemPromise.onSuccess(item -> {
            if (item == null) {
                return;
            }
            this.getModel().getInvoker().runOrInvokeLater(() -> {
                ServiceModel.ServiceViewItem updatedItem = this.getModel().findItem((ServiceModel.ServiceViewItem)item);
                if (updatedItem != null) {
                    AppUIUtil.invokeOnEdt(() -> {
                        ServiceModel.ServiceViewItem navBarItem = this.getNavBarItem();
                        if (updatedItem.equals(navBarItem)) {
                            this.myNavBarPanel.getModel().updateModel(updatedItem);
                        }
                    }, this.myProject.getDisposed());
                }
            });
        });
        AppUIUtil.invokeOnEdt(() -> itemPromise.setResult((Object)this.getNavBarItem()), this.myProject.getDisposed());
    }

    private ServiceModel.ServiceViewItem getNavBarItem() {
        NavBarModel navBarModel = this.myNavBarPanel.getModel();
        if (navBarModel.isEmpty()) {
            return null;
        }
        return (ServiceModel.ServiceViewItem)ObjectUtils.tryCast((Object)navBarModel.getElement(navBarModel.size() - 1), ServiceModel.ServiceViewItem.class);
    }

    @Override
    void setAutoScrollToSourceHandler(@NotNull AutoScrollToSourceHandler autoScrollToSourceHandler) {
        if (autoScrollToSourceHandler == null) {
            ServiceTreeView.$$$reportNull$$$0(10);
        }
        super.setAutoScrollToSourceHandler(autoScrollToSourceHandler);
        autoScrollToSourceHandler.install((JTree)((Object)this.myTree));
    }

    @Override
    List<Object> getChildrenSafe(@NotNull Object value) {
        if (value == null) {
            ServiceTreeView.$$$reportNull$$$0(11);
        }
        int count = this.myTree.getRowCount();
        for (int i = 0; i < count; ++i) {
            ServiceModel.ServiceViewItem item;
            TreePath path = this.myTree.getPathForRow(i);
            Object node = path.getLastPathComponent();
            if (!(node instanceof ServiceModel.ServiceViewItem) || !value.equals((item = (ServiceModel.ServiceViewItem)node).getValue())) continue;
            return ContainerUtil.map(this.getModel().getChildren(item), ServiceModel.ServiceViewItem::getValue);
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceTreeView";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoScrollToSourceHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceTreeView";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setAutoScrollToSourceHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenSafe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PathSelectionVisitor
    implements TreeVisitor {
        private final Queue<Object> myPath;

        PathSelectionVisitor(TreePath path) {
            this.myPath = ContainerUtil.newLinkedList((Object[])path.getPath());
        }

        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path) {
            Object node;
            if (path == null) {
                PathSelectionVisitor.$$$reportNull$$$0(0);
            }
            if ((node = path.getLastPathComponent()).equals(this.myPath.peek())) {
                this.myPath.poll();
                TreeVisitor.Action action2 = this.myPath.isEmpty() ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
                if (action2 == null) {
                    PathSelectionVisitor.$$$reportNull$$$0(1);
                }
                return action2;
            }
            TreeVisitor.Action action3 = TreeVisitor.Action.SKIP_CHILDREN;
            if (action3 == null) {
                PathSelectionVisitor.$$$reportNull$$$0(2);
            }
            return action3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceTreeView$PathSelectionVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceTreeView$PathSelectionVisitor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyViewModelListener
    implements ServiceViewModel.ServiceViewModelListener {
        private MyViewModelListener() {
        }

        @Override
        public void rootsChanged() {
            AppUIUtil.invokeOnEdt(() -> {
                TreePath[] currentPaths = ServiceTreeView.this.myTree.getSelectionPaths();
                List selectedPaths = currentPaths == null || currentPaths.length == 0 ? Collections.emptyList() : Arrays.asList(currentPaths);
                ServiceTreeView.this.myTreeModel.rootsChanged();
                if (selectedPaths.isEmpty()) {
                    return;
                }
                ServiceTreeView.this.myTreeModel.getInvoker().invokeLater(() -> {
                    List pathPromises = ContainerUtil.mapNotNull((Collection)selectedPaths, path -> {
                        ServiceModel.ServiceViewItem item = (ServiceModel.ServiceViewItem)ObjectUtils.tryCast((Object)path.getLastPathComponent(), ServiceModel.ServiceViewItem.class);
                        return item == null ? null : ServiceTreeView.this.myTreeModel.findPath(item.getValue(), item.getRootContributor().getClass());
                    });
                    Promises.collectResults((Collection)pathPromises, (boolean)true).onProcessed(paths -> {
                        if (paths != null && !paths.isEmpty() && !paths.equals(selectedPaths)) {
                            TreeUtil.promiseSelect((JTree)((Object)ServiceTreeView.this.myTree), paths.stream().map(PathSelectionVisitor::new));
                        }
                    });
                });
            }, ServiceTreeView.this.myProject.getDisposed());
        }
    }
}

