/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIdentityHashingStrategy;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimatedIcon
implements Icon {
    @ApiStatus.Experimental
    public static final Key<Boolean> ANIMATION_IN_RENDERER_ALLOWED = Key.create((String)"ANIMATION_IN_RENDERER_ALLOWED");
    private final Frame[] frames;
    private final Set<Component> requested;
    private long time;
    private int index;

    public AnimatedIcon(int delay, Icon ... icons) {
        if (icons == null) {
            AnimatedIcon.$$$reportNull$$$0(0);
        }
        this(AnimatedIcon.getFrames(delay, icons));
    }

    public AnimatedIcon(Frame ... frames) {
        if (frames == null) {
            AnimatedIcon.$$$reportNull$$$0(1);
        }
        this.requested = new SmartHashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
        this.frames = frames;
        assert (frames.length > 0) : "empty array";
        for (Frame frame : frames) {
            assert (frame != null) : "null animation frame";
        }
        this.time = System.currentTimeMillis();
    }

    private static Frame[] getFrames(final int delay, Icon ... icons) {
        if (icons == null) {
            AnimatedIcon.$$$reportNull$$$0(2);
        }
        int length = icons.length;
        assert (length > 0) : "empty array";
        Frame[] frames = new Frame[length];
        for (int i = 0; i < length; ++i) {
            final Icon icon = icons[i];
            assert (icon != null) : "null icon";
            frames[i] = new Frame(){

                @Override
                @NotNull
                public Icon getIcon() {
                    Icon icon2 = icon;
                    if (icon2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon2;
                }

                @Override
                public int getDelay() {
                    return delay;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AnimatedIcon$1", "getIcon"));
                }
            };
        }
        return frames;
    }

    private void updateFrameAt(long current) {
        int next = this.index + 1;
        this.index = next < this.frames.length ? next : 0;
        this.time = current;
    }

    @NotNull
    private Icon getUpdatedIcon() {
        int index = this.getCurrentIndex();
        Icon icon = this.frames[index].getIcon();
        if (icon == null) {
            AnimatedIcon.$$$reportNull$$$0(3);
        }
        return icon;
    }

    private int getCurrentIndex() {
        long current = System.currentTimeMillis();
        Frame frame = this.frames[this.index];
        if ((long)frame.getDelay() <= current - this.time) {
            this.updateFrameAt(current);
        }
        return this.index;
    }

    private void requestRefresh(@Nullable Component c) {
        if (c != null && !this.requested.contains(c) && this.canRefresh(c)) {
            Frame frame = this.frames[this.index];
            int delay = frame.getDelay();
            if (delay > 0) {
                this.requested.add(c);
                EdtScheduledExecutorService.getInstance().schedule(() -> {
                    this.requested.remove(c);
                    if (this.canRefresh(c)) {
                        this.doRefresh(c);
                    }
                }, (long)delay, TimeUnit.MILLISECONDS);
            } else {
                this.doRefresh(c);
            }
        }
    }

    @Override
    public final void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.getUpdatedIcon();
        CellRendererPane pane = (CellRendererPane)ComponentUtil.getParentOfType(CellRendererPane.class, (Component)c);
        this.requestRefresh(pane == null ? c : this.getRendererOwner(pane.getParent()));
        icon.paintIcon(c, g, x, y);
    }

    @Override
    public final int getIconWidth() {
        return this.getUpdatedIcon().getIconWidth();
    }

    @Override
    public final int getIconHeight() {
        return this.getUpdatedIcon().getIconHeight();
    }

    protected boolean canRefresh(@NotNull Component component) {
        if (component == null) {
            AnimatedIcon.$$$reportNull$$$0(4);
        }
        return component.isShowing();
    }

    protected void doRefresh(@NotNull Component component) {
        if (component == null) {
            AnimatedIcon.$$$reportNull$$$0(5);
        }
        component.repaint();
    }

    @Nullable
    protected Component getRendererOwner(@Nullable Component component) {
        return UIUtil.isClientPropertyTrue((Object)component, ANIMATION_IN_RENDERER_ALLOWED) ? component : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/AnimatedIcon";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/AnimatedIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFrames";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canRefresh";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doRefresh";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Experimental
    public static class Fading
    extends AnimatedIcon {
        public Fading(@NotNull Icon icon) {
            if (icon == null) {
                Fading.$$$reportNull$$$0(0);
            }
            this(1000, icon);
        }

        public Fading(final int period, final @NotNull Icon icon) {
            if (icon == null) {
                Fading.$$$reportNull$$$0(1);
            }
            super(50, new Icon(){
                private final long time = System.currentTimeMillis();

                @Override
                public int getIconWidth() {
                    return icon.getIconWidth();
                }

                @Override
                public int getIconHeight() {
                    return icon.getIconHeight();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    assert (period > 0) : "unexpected";
                    long time = (System.currentTimeMillis() - this.time) % (long)period;
                    float alpha = (float)((Math.cos(Math.PI * 2 * (double)time / (double)period) + 1.0) / 2.0);
                    if (alpha > 0.0f) {
                        if (alpha < 1.0f && g instanceof Graphics2D) {
                            Graphics2D g2d = (Graphics2D)g.create();
                            try {
                                g2d.setComposite(AlphaComposite.SrcAtop.derive(alpha));
                                icon.paintIcon(c, g2d, x, y);
                            }
                            finally {
                                g2d.dispose();
                            }
                        } else {
                            icon.paintIcon(c, g, x, y);
                        }
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/AnimatedIcon$Fading", "<init>"));
        }
    }

    @ApiStatus.Experimental
    public static class Blinking
    extends AnimatedIcon {
        public Blinking(@NotNull Icon icon) {
            if (icon == null) {
                Blinking.$$$reportNull$$$0(0);
            }
            this(1000, icon);
        }

        public Blinking(int delay, @NotNull Icon icon) {
            if (icon == null) {
                Blinking.$$$reportNull$$$0(1);
            }
            super(delay, icon, (Icon)ObjectUtils.notNull((Object)IconLoader.getDisabledIcon((Icon)icon), (Object)icon));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/AnimatedIcon$Blinking", "<init>"));
        }
    }

    @ApiStatus.Experimental
    public static class FS
    extends AnimatedIcon {
        public static final int DELAY = 50;
        public static final List<Icon> ICONS = ContainerUtil.immutableList((Object[])new Icon[]{AllIcons.Process.FS.Step_1, AllIcons.Process.FS.Step_2, AllIcons.Process.FS.Step_3, AllIcons.Process.FS.Step_4, AllIcons.Process.FS.Step_5, AllIcons.Process.FS.Step_6, AllIcons.Process.FS.Step_7, AllIcons.Process.FS.Step_8, AllIcons.Process.FS.Step_9, AllIcons.Process.FS.Step_10, AllIcons.Process.FS.Step_11, AllIcons.Process.FS.Step_12, AllIcons.Process.FS.Step_13, AllIcons.Process.FS.Step_14, AllIcons.Process.FS.Step_15, AllIcons.Process.FS.Step_16, AllIcons.Process.FS.Step_17, AllIcons.Process.FS.Step_18});

        public FS() {
            super(50, ICONS.toArray(new Icon[0]));
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public static class Grey
    extends AnimatedIcon {
        public static final int DELAY = 130;
        public static final List<Icon> ICONS = ContainerUtil.immutableList((Object[])new Icon[]{AllIcons.Process.State.GreyProgr_1, AllIcons.Process.State.GreyProgr_2, AllIcons.Process.State.GreyProgr_3, AllIcons.Process.State.GreyProgr_4, AllIcons.Process.State.GreyProgr_5, AllIcons.Process.State.GreyProgr_6, AllIcons.Process.State.GreyProgr_7, AllIcons.Process.State.GreyProgr_8});

        public Grey() {
            super(130, ICONS.toArray(new Icon[0]));
        }
    }

    public static class Recording
    extends AnimatedIcon {
        public static final int DELAY = 250;
        public static final List<Icon> ICONS = ContainerUtil.immutableList((Object[])new Icon[]{AllIcons.Ide.Macro.Recording_1, AllIcons.Ide.Macro.Recording_2, AllIcons.Ide.Macro.Recording_3, AllIcons.Ide.Macro.Recording_4});

        public Recording() {
            super(250, ICONS.toArray(new Icon[0]));
        }
    }

    public static class Big
    extends AnimatedIcon {
        public static final int DELAY = 130;
        public static final List<Icon> ICONS = ContainerUtil.immutableList((Object[])new Icon[]{AllIcons.Process.Big.Step_1, AllIcons.Process.Big.Step_2, AllIcons.Process.Big.Step_3, AllIcons.Process.Big.Step_4, AllIcons.Process.Big.Step_5, AllIcons.Process.Big.Step_6, AllIcons.Process.Big.Step_7, AllIcons.Process.Big.Step_8});

        public Big() {
            super(130, ICONS.toArray(new Icon[0]));
        }
    }

    public static class Default
    extends AnimatedIcon {
        public static final int DELAY = 130;
        public static final List<Icon> ICONS = ContainerUtil.immutableList((Object[])new Icon[]{AllIcons.Process.Step_1, AllIcons.Process.Step_2, AllIcons.Process.Step_3, AllIcons.Process.Step_4, AllIcons.Process.Step_5, AllIcons.Process.Step_6, AllIcons.Process.Step_7, AllIcons.Process.Step_8});
        public static final AnimatedIcon INSTANCE = new Default();

        public Default() {
            super(130, ICONS.toArray(new Icon[0]));
        }
    }

    public static interface Frame {
        @NotNull
        public Icon getIcon();

        public int getDelay();
    }
}

