/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlTextManipulator
extends AbstractElementManipulator<XmlText> {
    public XmlText handleContentChange(@NotNull XmlText text, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String newValue;
        if (text == null) {
            XmlTextManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            XmlTextManipulator.$$$reportNull$$$0(1);
        }
        String value = text.getValue();
        if (range.equals((Object)this.getRangeInElement(text))) {
            newValue = newContent;
        } else {
            StringBuilder replacement = new StringBuilder(value);
            replacement.replace(range.getStartOffset(), range.getEndOffset(), newContent);
            newValue = replacement.toString();
        }
        if (Comparing.equal((String)value, (String)newValue)) {
            return text;
        }
        if (!newValue.isEmpty()) {
            text.setValue(newValue);
        } else {
            text.deleteChildRange(text.getFirstChild(), text.getLastChild());
        }
        return text;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlText text) {
        if (text == null) {
            XmlTextManipulator.$$$reportNull$$$0(2);
        }
        TextRange textRange = XmlTextManipulator.getValueRange(text);
        if (textRange == null) {
            XmlTextManipulator.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static TextRange getValueRange(XmlText xmlText) {
        String value = xmlText.getValue();
        int i = value.indexOf(value);
        int start = xmlText.displayToPhysical(i);
        return value.isEmpty() ? new TextRange(start, start) : new TextRange(start, xmlText.displayToPhysical(i + value.length() - 1) + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

