/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XmlEnclosingTagUnwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RemoveTagAndPromoteChildrenIntentionAction
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("remove.tag.quickfix.family", new Object[0]);
        if (string == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        XmlTag tag;
        if (project == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(2);
        }
        if ((tag = RemoveTagAndPromoteChildrenIntentionAction.getTag(editor, file)) == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        ASTNode startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        if (startEnd == null || offset <= startEnd.getStartOffset()) {
            return true;
        }
        ASTNode endStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tag.getNode());
        return endStart == null || offset >= startEnd.getStartOffset();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(3);
        }
        new XmlEnclosingTagUnwrapper().unwrap(editor, (PsiElement)RemoveTagAndPromoteChildrenIntentionAction.getTag(editor, file));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static XmlTag getTag(Editor editor, PsiFile file) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        PsiElement psiElement = parent = element != null ? element.getParent() : null;
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        if (parent instanceof XmlAttribute) {
            return null;
        }
        element = file.findElementAt(offset - 1);
        PsiElement psiElement2 = parent = element != null ? element.getParent() : null;
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveTagAndPromoteChildrenIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveTagAndPromoteChildrenIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

