/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.util.Date;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class CommitTimeRevFilter
extends RevFilter {
    final int when;

    public static final RevFilter before(Date ts) {
        return CommitTimeRevFilter.before(ts.getTime());
    }

    public static final RevFilter before(long ts) {
        return new Before(ts);
    }

    public static final RevFilter after(Date ts) {
        return CommitTimeRevFilter.after(ts.getTime());
    }

    public static final RevFilter after(long ts) {
        return new After(ts);
    }

    public static final RevFilter between(Date since, Date until) {
        return CommitTimeRevFilter.between(since.getTime(), until.getTime());
    }

    public static final RevFilter between(long since, long until) {
        return new Between(since, until);
    }

    CommitTimeRevFilter(long ts) {
        this.when = (int)(ts / 1000L);
    }

    @Override
    public RevFilter clone() {
        return this;
    }

    @Override
    public boolean requiresCommitBody() {
        return false;
    }

    private static class Between
    extends CommitTimeRevFilter {
        private final int until;

        Between(long since, long until) {
            super(since);
            this.until = (int)(until / 1000L);
        }

        @Override
        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
            return cmit.getCommitTime() <= this.until && cmit.getCommitTime() >= this.when;
        }

        @Override
        public String toString() {
            return super.toString() + "(" + new Date((long)this.when * 1000L) + " - " + new Date((long)this.until * 1000L) + ")";
        }
    }

    private static class After
    extends CommitTimeRevFilter {
        After(long ts) {
            super(ts);
        }

        @Override
        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
            if (cmit.getCommitTime() < this.when) {
                throw StopWalkException.INSTANCE;
            }
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + "(" + new Date((long)this.when * 1000L) + ")";
        }
    }

    private static class Before
    extends CommitTimeRevFilter {
        Before(long ts) {
            super(ts);
        }

        @Override
        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
            return cmit.getCommitTime() <= this.when;
        }

        @Override
        public String toString() {
            return super.toString() + "(" + new Date((long)this.when * 1000L) + ")";
        }
    }
}

