/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.FontFallbackIterator;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import org.jetbrains.annotations.NotNull;

public class FontUtil {
    @NotNull
    public static String getHtmlWithFonts(@NotNull String input) {
        if (input == null) {
            FontUtil.$$$reportNull$$$0(0);
        }
        Font font = UIUtil.getLabelFont();
        String string = FontUtil.getHtmlWithFonts(input, font.getStyle(), font);
        if (string == null) {
            FontUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getHtmlWithFonts(@NotNull String input, int style, @NotNull Font baseFont) {
        int start;
        if (input == null) {
            FontUtil.$$$reportNull$$$0(2);
        }
        if (baseFont == null) {
            FontUtil.$$$reportNull$$$0(3);
        }
        if ((start = baseFont.canDisplayUpTo(input)) == -1) {
            String string = input;
            if (string == null) {
                FontUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder result2 = new StringBuilder();
        FontFallbackIterator it = new FontFallbackIterator();
        it.setPreferredFont(baseFont.getFamily(), baseFont.getSize());
        it.setFontStyle(style);
        it.start((CharSequence)input, 0, input.length());
        while (!it.atEnd()) {
            boolean insideFallbackBlock;
            Font font = it.getFont();
            boolean bl = insideFallbackBlock = !font.getFamily().equals(baseFont.getFamily());
            if (insideFallbackBlock) {
                result2.append("<font face=\"").append(font.getFamily()).append("\">");
            }
            result2.append(input, it.getStart(), it.getEnd());
            if (insideFallbackBlock) {
                result2.append("</font>");
            }
            it.advance();
        }
        String string = result2.toString();
        if (string == null) {
            FontUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static Font getEditorFont() {
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        if (font == null) {
            FontUtil.$$$reportNull$$$0(6);
        }
        return font;
    }

    @NotNull
    public static Font getCommitMessageFont() {
        Font font = FontUtil.getEditorFont();
        if (font == null) {
            FontUtil.$$$reportNull$$$0(7);
        }
        return font;
    }

    public static Font getCommitMetadataFont() {
        return UIUtil.getLabelFont();
    }

    public static int getStandardAscent(@NotNull Font font, @NotNull Graphics g) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(8);
        }
        if (g == null) {
            FontUtil.$$$reportNull$$$0(9);
        }
        FontRenderContext context = ((Graphics2D)g).getFontRenderContext();
        char[] chars = new char[]{'G', 'l', 'd', 'h', 'f'};
        double y = font.layoutGlyphVector(context, chars, 0, chars.length, 0).getVisualBounds().getY();
        return Math.toIntExact(Math.round(Math.ceil(-y)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ui/FontUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFont";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ui/FontUtil";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlWithFonts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorFont";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMessageFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlWithFonts";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStandardAscent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

